/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.quickfind;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.CompletionActionsProvider;
import com.oxygenxml.positron.plugin.chat.quickfind.GenericFilteringPanel;
import com.oxygenxml.positron.plugin.chat.quickfind.PositronActionAdapter;
import com.oxygenxml.positron.plugin.chat.quickfind.PositronActionWrapper;
import com.oxygenxml.positron.plugin.chat.quickfind.QuickSearchItemSelectionListener;
import com.oxygenxml.positron.plugin.chat.quickfind.QuickSearchListItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import ro.sync.exml.workspace.api.standalone.ui.OKCancelDialog;

public class QuickSearchItemDialog<T extends QuickSearchListItem>
extends JDialog {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private GenericFilteringPanel<T> filteringPanel;

    public QuickSearchItemDialog(Supplier<Component> componentRelativeToSupplier, List<T> items, String title, String placeholderText, QuickSearchItemSelectionListener<T> itemSelectionListener, boolean shouldPlaceAboveComponent) {
        super(OKCancelDialog.detectParentFrame(null), title, Dialog.ModalityType.MODELESS);
        this.configureQuickSearchActionDialogClosing();
        this.setUndecorated(true);
        this.getRootPane().setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.filteringPanel = new GenericFilteringPanel<T>(items, placeholderText);
        this.filteringPanel.setItemSelectionListener(item -> {
            this.hideDialog();
            if (itemSelectionListener != null) {
                itemSelectionListener.onItemSelected(item);
            }
        });
        this.getContentPane().add(this.filteringPanel, "Center");
        this.pack();
        int locationX = 0;
        int locationY = 0;
        Component componentRelativeTo = componentRelativeToSupplier.get();
        if (componentRelativeTo != null) {
            Point componentLocation = componentRelativeTo.getLocationOnScreen();
            int yOffset = componentRelativeTo.getSize().height;
            locationX = componentLocation.x;
            locationY = shouldPlaceAboveComponent ? componentLocation.y - yOffset : componentLocation.y + yOffset;
        }
        Point constrainedLocation = this.constrainDialogWithinParent(locationX, locationY);
        this.setLocation(constrainedLocation.x, constrainedLocation.y);
    }

    private Point constrainDialogWithinParent(int initialX, int initialY) {
        Window parentWindow = this.getOwner();
        if (parentWindow == null) {
            return new Point(initialX, initialY);
        }
        Rectangle parentBounds = parentWindow.getBounds();
        Dimension dialogSize = this.getSize();
        int constrainedX = initialX;
        int constrainedY = initialY;
        int delta = 10;
        if (constrainedX + dialogSize.width > parentBounds.x + parentBounds.width) {
            constrainedX = parentBounds.x + parentBounds.width - dialogSize.width - delta;
        }
        if (constrainedY + dialogSize.height > parentBounds.y + parentBounds.height) {
            constrainedY = parentBounds.y + parentBounds.height - dialogSize.height - delta;
        }
        return new Point(constrainedX, constrainedY);
    }

    public QuickSearchItemDialog(Supplier<Component> componentRelativeToSupplier, CompletionActionsProvider completionActionsProvider, boolean shouldPlaceDialogAboveComponent) {
        this(componentRelativeToSupplier, new PositronActionAdapter(completionActionsProvider.getCurrentCompletionActions()).getItems(), TRANSLATOR.getTranslation("Quick_Search_Action"), TRANSLATOR.getTranslation("Search_Action_Placeholder"), item -> {
            if (item instanceof PositronActionWrapper) {
                ((PositronActionWrapper)item).getAction().actionPerformed(null);
            }
        }, shouldPlaceDialogAboveComponent);
    }

    private void configureQuickSearchActionDialogClosing() {
        final AbstractAction cancelAction = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickSearchItemDialog.this.hideDialog();
            }
        };
        JRootPane rootPane = this.getRootPane();
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        rootPane.getActionMap().put("Cancel", cancelAction);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                cancelAction.actionPerformed(null);
            }
        });
    }

    private void hideDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public List<T> getItems() {
        return new ArrayList<T>(this.filteringPanel.getItems());
    }

    public JList<T> getList() {
        return this.filteringPanel.getSuggestionList();
    }

    public JTextField getSearchField() {
        return this.filteringPanel.getSearchField();
    }
}

