/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.project;

import com.oxygenxml.positron.core.aiignore.AiIgnoreManager;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManagerProvider;
import com.oxygenxml.positron.core.tools.project.ProjectHelperSandbox;
import com.oxygenxml.positron.plugin.chat.project.CopyMoveRenameUtil;
import com.oxygenxml.positron.plugin.chat.project.ProjectHelper;
import com.oxygenxml.positron.plugin.chat.project.find.FindMatch;
import com.oxygenxml.positron.plugin.chat.project.find.FindReport;
import com.oxygenxml.positron.plugin.chat.project.find.FindResult;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.exceptions.AccessDeniedException;
import com.oxygenxml.positron.utilities.functions.FileOperation;
import com.oxygenxml.positron.utilities.functions.RAGException;
import com.oxygenxml.positron.utilities.functions.RelatedReusableComponent;
import com.oxygenxml.positron.utilities.functions.parameters.AdvancedSearchKeywords;
import com.oxygenxml.positron.utilities.functions.parameters.SearchParams;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.basic.util.URLUtil;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.process.ProcessController;
import ro.sync.exml.workspace.api.process.ProcessListener;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.project.ProjectController;
import ro.sync.exml.workspace.api.standalone.project.ProjectIndexer;
import ro.sync.exml.workspace.api.standalone.project.ProjectIndexerException;

public class SAProjectHelper
extends ProjectHelper {
    private static final int MAX_SEARCH_RESULTS_COUNT = 5000;
    private static final int MAX_MATCHES_NUMBER = 5;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SAProjectHelper.class.getName());
    private static final int SEARCH_IN_PRJ_MAX_NO_OF_EXACT_MATCHES = 50;

    private Method getSearchMethod() {
        ProjectIndexer projectIndexer = this.getProjectIndexer();
        if (projectIndexer != null) {
            try {
                return projectIndexer.getClass().getMethod("search", String.class, Integer.TYPE);
            }
            catch (Exception e) {
                LOGGER.debug((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    private Method getAdvancedSearchMethod() {
        ProjectIndexer projectIndexer = this.getProjectIndexer();
        if (projectIndexer != null) {
            try {
                Class<?> searchOptionsClazz = Class.forName("ro.sync.exml.workspace.api.standalone.project.SearchOptions");
                return projectIndexer.getClass().getMethod("search", searchOptionsClazz, Predicate.class);
            }
            catch (Exception e) {
                LOGGER.debug((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    protected Method getSearchInFilesMethod() {
        ProjectController projectController;
        if (PluginWorkspaceProvider.getPluginWorkspace() instanceof StandalonePluginWorkspace && (projectController = ((StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getProjectManager()) != null) {
            try {
                return projectController.getClass().getMethod("findInFiles", Class.forName("ro.sync.exml.workspace.api.standalone.project.SearchParams"));
            }
            catch (Exception e) {
                LOGGER.debug((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    private Method getSearchReusableComponentsMethod() {
        ProjectIndexer projectIndexer = this.getProjectIndexer();
        if (projectIndexer != null) {
            try {
                return projectIndexer.getClass().getMethod("searchInReusableComponents", String.class, Integer.TYPE);
            }
            catch (Exception e) {
                LOGGER.debug((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    protected ProjectIndexer getProjectIndexer() {
        if (PluginWorkspaceProvider.getPluginWorkspace() instanceof StandalonePluginWorkspace) {
            ProjectController projectManager = ((StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getProjectManager();
            return projectManager != null ? projectManager.getProjectIndexer() : null;
        }
        return null;
    }

    @Override
    protected List<URL> getRelatedProjectURLs(String keywords) throws RAGException {
        ArrayList<URL> urls;
        block7: {
            urls = new ArrayList<URL>();
            Method searchMethod = this.getSearchMethod();
            ProjectIndexer projectIndexer = this.getProjectIndexer();
            if (searchMethod != null && projectIndexer != null) {
                try {
                    keywords = keywords.replace('/', ' ');
                    List found = (List)searchMethod.invoke((Object)projectIndexer, keywords, 5);
                    if (found != null && !found.isEmpty()) {
                        for (int i = 0; i < found.size(); ++i) {
                            String extension;
                            URL url = (URL)found.get(i);
                            String contentType = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().getContentType(url.toString());
                            if (!SAProjectHelper.isContentTypeOfInterest(contentType, extension = URLUtil.getExtension((String)((URL)found.get(i)).toString()))) continue;
                            urls.add(url);
                        }
                    }
                }
                catch (Exception ex) {
                    boolean isParseException;
                    Throwable t = ex;
                    if (ex instanceof InvocationTargetException) {
                        t = ((InvocationTargetException)ex).getCause();
                    }
                    LOGGER.error((Object)t, t);
                    if (!(t instanceof ProjectIndexerException)) break block7;
                    ProjectIndexerException indexerException = (ProjectIndexerException)t;
                    String message = "Could not succesfully search for keywords: " + keywords;
                    boolean bl = isParseException = indexerException.getCause() != null && indexerException.getCause().getClass().getName().contains("ParseException");
                    if (!isParseException) {
                        message = message + " Reason: " + indexerException.getMessage();
                    }
                    throw new RAGException(message, indexerException.getCause());
                }
            }
        }
        return urls;
    }

    @Override
    public boolean isRagAvailable() {
        return this.getSearchMethod() != null;
    }

    @Override
    public List<RelatedReusableComponent> getRelatedReusableComponents(String keywords) throws RAGException {
        Method searchMethod = this.getSearchReusableComponentsMethod();
        ProjectIndexer projectIndexer = this.getProjectIndexer();
        if (searchMethod != null && projectIndexer != null) {
            try {
                List found = (List)searchMethod.invoke((Object)projectIndexer, keywords, 15);
                if (found != null && !found.isEmpty()) {
                    WSEditor currentEditor = PluginWorkspaceProvider.getPluginWorkspace().getCurrentEditorAccess(0);
                    URL base = currentEditor != null ? currentEditor.getEditorLocation() : null;
                    ArrayList<RelatedReusableComponent> comps = new ArrayList<RelatedReusableComponent>();
                    for (Object object : found) {
                        this.processReusableComponentInfo(base, object, comps);
                    }
                    return comps;
                }
            }
            catch (Exception ex) {
                Throwable t = ex;
                if (ex instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)ex).getCause();
                }
                if (t instanceof ProjectIndexerException) {
                    ProjectIndexerException indexerException = (ProjectIndexerException)t;
                    throw new RAGException(indexerException.getMessage(), indexerException.getCause());
                }
                LOGGER.error((Object)t, t);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isReusableComponentsRagAvailable() {
        return this.getSearchReusableComponentsMethod() != null;
    }

    public boolean isPersistentMemoryStoreEnabled() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        return Boolean.valueOf(optionsStorage.getOption("oxygen.positron.plugin.enable.memory", "true"));
    }

    public String searchInProject(SearchParams params) throws RAGException {
        block7: {
            LinkedHashMap<String, FindResult> matches = new LinkedHashMap<String, FindResult>();
            Method searchMethod = this.getSearchInFilesMethod();
            if (searchMethod != null) {
                ProjectController projectManager = ((StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getProjectManager();
                HashSet<String> safeSystemIDs = new HashSet<String>();
                try {
                    int maxPreciseMatches = params.maxNumberOfMatches > 0 ? params.maxNumberOfMatches : 50;
                    int matchesCount = 0;
                    List<DocumentPositionedInfo> found = this.searchWithSDKAPI(params, searchMethod, projectManager);
                    if (found != null && !found.isEmpty()) {
                        for (DocumentPositionedInfo dpi : found) {
                            matchesCount = this.addMatch(matches, safeSystemIDs, dpi, maxPreciseMatches, matchesCount);
                        }
                    }
                    int preciseMatchesCnt = 0;
                    Iterator frIterator = matches.values().iterator();
                    while (frIterator.hasNext()) {
                        preciseMatchesCnt += ((FindResult)frIterator.next()).getReturnedMatchesCount();
                    }
                    StringWriter sw = new StringWriter();
                    FindReport report = new FindReport(matchesCount, preciseMatchesCnt, matches);
                    AIRequestUtil.defaultObjectMapper().writeValue((Writer)sw, (Object)report);
                    return sw.toString();
                }
                catch (Exception ex) {
                    Throwable t = ex;
                    if (ex instanceof InvocationTargetException) {
                        t = ((InvocationTargetException)ex).getCause();
                    }
                    LOGGER.error((Object)t, t);
                    if (!(t instanceof ProjectIndexerException)) break block7;
                    ProjectIndexerException indexerException = (ProjectIndexerException)t;
                    String message = "Could not succesfully search for text: " + params.textToFind;
                    message = message + " Reason: " + indexerException.getMessage();
                    throw new RAGException(message, indexerException.getCause());
                }
            }
        }
        return "Search in project not available.";
    }

    protected List<DocumentPositionedInfo> searchWithSDKAPI(SearchParams params, Method searchMethod, ProjectController projectManager) throws Exception {
        Class<?> searchParams = Class.forName("ro.sync.exml.workspace.api.standalone.project.SearchParams");
        Object searchParamsObj = searchParams.getConstructor(String.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE).newInstance(params.includedFileNamesPattern != null ? params.includedFileNamesPattern : "*", params.textToFind, params.xpathExpression, params.caseSensitive, params.regexp, 5000);
        searchMethod.setAccessible(true);
        return (List)searchMethod.invoke((Object)projectManager, searchParamsObj);
    }

    private int addMatch(Map<String, FindResult> matches, Set<String> safeSystemIDs, DocumentPositionedInfo dpi, int maxPreciseMatches, int matchesCount) {
        String match = null;
        try {
            match = dpi.getMessage().substring(dpi.getMessageHighlightOffset(), dpi.getMessageHighlightOffset() + dpi.getLength());
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        FindMatch searchMatch = new FindMatch(match, dpi.getMessage(), dpi.getLine(), dpi.getColumn(), dpi.getLength());
        try {
            if (!safeSystemIDs.contains(dpi.getSystemID())) {
                this.checkDocumentAccessPermissions(dpi.getSystemID(), false, false);
                safeSystemIDs.add(dpi.getSystemID());
            }
            FindResult searchResult = matches.computeIfAbsent(dpi.getSystemID(), key -> new FindResult());
            searchResult.setTotalMatchesCount(searchResult.getTotalMatchesCount() + 1);
            if (matchesCount < maxPreciseMatches) {
                searchResult.getMatches().add(searchMatch);
                searchResult.setReturnedMatchesCount(searchResult.getReturnedMatchesCount() + 1);
            }
            ++matchesCount;
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        return matchesCount;
    }

    @Override
    public boolean isSearchInProjectAvailable() {
        boolean isAvailable;
        boolean bl = isAvailable = this.getSearchInFilesMethod() != null;
        if (isAvailable) {
            isAvailable = this.editsLocalResources();
        }
        return isAvailable;
    }

    private boolean editsLocalResources() {
        WSEditor currentDM;
        boolean editsLocal = true;
        PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
        WSEditor currentEd = pw.getCurrentEditorAccess(0);
        if (this.isRemoteResource(currentEd)) {
            editsLocal = false;
        }
        if (editsLocal && this.isRemoteResource(currentDM = pw.getCurrentEditorAccess(1))) {
            editsLocal = false;
        }
        return editsLocal;
    }

    @Override
    public boolean isListDirectoryFilesAvailable() {
        return this.editsLocalResources();
    }

    private boolean isRemoteResource(WSEditor currentEd) {
        return currentEd != null && !"file".equals(currentEd.getEditorLocation().getProtocol());
    }

    public boolean isAdvancedSearchAvailable() {
        return this.getAdvancedSearchMethod() != null;
    }

    public String getRelatedProjectResourcesOverview(AdvancedSearchKeywords keywords) throws RAGException {
        try {
            Method advancedSearchMethod = this.getAdvancedSearchMethod();
            ProjectIndexer projectIndexer = this.getProjectIndexer();
            if (projectIndexer != null && advancedSearchMethod != null) {
                AiIgnoreManager aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker();
                Class<?> searchOptions = Class.forName("ro.sync.exml.workspace.api.standalone.project.SearchOptions");
                Object options = searchOptions.getConstructor(String.class, String.class, Integer.TYPE, Integer.TYPE).newInstance(keywords.keywords, keywords.defaultJoinOperator, keywords.pageSize, keywords.currentPage);
                return (String)advancedSearchMethod.invoke((Object)projectIndexer, options, SAProjectHelper.testAIIgnored(aiIgnoreChecker));
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private static Predicate<String> testAIIgnored(final AiIgnoreManager aiIgnoreChecker) {
        return new Predicate<String>(){

            @Override
            public boolean test(String urlString) {
                try {
                    URL url = new URL(urlString);
                    if (aiIgnoreChecker != null && aiIgnoreChecker.isIgnoredFromAiIgnoreFile(url)) {
                        if (LOGGER.isDebugEnabled()) {
                            String msg = String.format("Skipping %s while getting related project resources overview because the file is marked for AI to ignore", URLUtil.filterPasswords((String)url.toExternalForm()));
                            LOGGER.debug(msg);
                        }
                        return true;
                    }
                }
                catch (MalformedURLException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                return false;
            }
        };
    }

    public boolean hasDITAMapOpenedInDITAMapsManager() {
        PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
        if (pw != null) {
            URL[] allOpenedMaps = pw.getAllEditorLocations(1);
            return allOpenedMaps != null && allOpenedMaps.length > 0;
        }
        return false;
    }

    @Override
    public String listFiles(String folderPath) throws RAGException {
        ArrayList<Object> entries = new ArrayList<Object>();
        try {
            folderPath = SAProjectHelper.convertFromURLPath(folderPath);
            File rootFolder = new File(folderPath);
            if (!rootFolder.exists()) {
                return this.createErrorJson("Folder does not exist: " + folderPath);
            }
            if (!rootFolder.isDirectory()) {
                return this.createErrorJson("Path is not a directory: " + folderPath);
            }
            String folderURL = URLUtil.correct((File)new File(folderPath)).toString();
            if (!ProjectHelperSandbox.accept((String)folderURL)) {
                return this.createErrorJson(ProjectHelperSandbox.getAccessDeniedMessage((String)folderURL));
            }
            File[] files = rootFolder.listFiles();
            if (files != null) {
                SAProjectHelper.sortFilesAlphabeticallyFoldersFirst(files);
                AiIgnoreManager aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker();
                for (File file : files) {
                    try {
                        if (file.isHidden()) continue;
                        URL fileUrl = URLUtil.correct((File)file);
                        if (aiIgnoreChecker != null && aiIgnoreChecker.isIgnoredFromAiIgnoreFile(fileUrl) || !ProjectHelperSandbox.accept((String)fileUrl.toExternalForm())) continue;
                        String name = file.getName();
                        entries.add(file.isDirectory() ? name + "/" : name);
                    }
                    catch (MalformedURLException e) {
                        LOGGER.error((Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return this.createErrorJson("Failed to list files: " + e.getMessage());
        }
        try {
            StringWriter sw = new StringWriter();
            AIRequestUtil.defaultObjectMapper().writeValue((Writer)sw, entries);
            return sw.toString();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return this.createErrorJson("Failed to serialize list files result: " + e.getMessage());
        }
    }

    private static void sortFilesAlphabeticallyFoldersFirst(File[] files) {
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                if (f1.isDirectory() && !f2.isDirectory()) {
                    return -1;
                }
                if (!f1.isDirectory() && f2.isDirectory()) {
                    return 1;
                }
                return f1.getName().compareToIgnoreCase(f2.getName());
            }
        });
    }

    private String createErrorJson(String errorMessage) {
        try {
            LinkedHashMap<String, String> errorMap = new LinkedHashMap<String, String>();
            errorMap.put("error", errorMessage);
            StringWriter sw = new StringWriter();
            AIRequestUtil.defaultObjectMapper().writeValue((Writer)sw, errorMap);
            return sw.toString();
        }
        catch (Exception e) {
            LOGGER.error("Failed to create error JSON: " + e.getMessage(), (Throwable)e);
            return "{\"error\":\"" + errorMessage.replace("\"", "\\\"") + "\"}";
        }
    }

    private static String convertFromURLPath(String folderPath) {
        try {
            File folder;
            URL possibleFolderURL = URLUtil.correct((URL)new URL(folderPath));
            if (possibleFolderURL != null && (folder = URLUtil.getCanonicalFileFromFileUrl((URL)possibleFolderURL)) != null) {
                folderPath = folder.getAbsolutePath();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return folderPath;
    }

    @Override
    public boolean isCopyMoveRenamePathsAvailable() {
        return true;
    }

    @Override
    public String copyMoveRename(String sourcePath, String destinationPath, FileOperation operation) throws IOException {
        return CopyMoveRenameUtil.copyMoveRename(sourcePath, destinationPath, operation);
    }

    public boolean canInvokeCommandLine() {
        return true;
    }

    public String invokeCommandLine(String commandLine, int timeout) throws IOException {
        if (!PlatformDetector.isWin() && commandLine.contains("&&") && !commandLine.startsWith("bash -c") && !commandLine.startsWith("sh -c")) {
            return SAProjectHelper.invokeSimpleCommandLine("bash -c \"" + commandLine + "\"", timeout);
        }
        return SAProjectHelper.invokeSimpleCommandLine(commandLine, timeout);
    }

    private static String invokeSimpleCommandLine(String commandLine, int timeout) {
        PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
        final StringBuilder output = new StringBuilder();
        final StringBuilder error = new StringBuilder();
        final ProcessController pc = pw.createProcess(new ProcessListener(){

            public void newErrorLine(String line) {
                error.append(line).append("\n");
            }

            public void newOutputLine(String line) {
                output.append(line).append("\n");
            }

            public void processCouldNotStart(String message) {
                error.append(message).append("\n");
            }

            public void processEnded(int exitCode) {
                output.append("Process exit code: " + exitCode).append("\n");
            }
        }, commandLine, new File(pw.getUtilAccess().expandEditorVariables("${pd}", null)), commandLine, false);
        Thread th = new Thread(){

            @Override
            public void run() {
                pc.start();
            }
        };
        th.start();
        try {
            th.join(timeout * 1000);
        }
        catch (InterruptedException e) {
            LOGGER.error((Throwable)e);
        }
        boolean forcedStop = false;
        if (th.isAlive()) {
            pc.stop();
            forcedStop = true;
        }
        Object result = "";
        if (output.length() > 0) {
            result = (String)result + "\n" + output + "\n";
        }
        if (error.length() > 0) {
            result = (String)result + "\nErrors:\n" + error;
        }
        if (forcedStop) {
            result = (String)result + "\nProcess timed out and was forcefully stopped.";
        }
        return result;
    }
}

