/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.project;

import com.oxygenxml.positron.core.aiignore.AiIgnoreManager;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManagerProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.tools.project.ProjectHelperBase;
import com.oxygenxml.positron.core.tools.project.ProjectHelperSandbox;
import com.oxygenxml.positron.core.util.ContextExtractorUtil;
import com.oxygenxml.positron.utilities.exceptions.AccessDeniedException;
import com.oxygenxml.positron.utilities.functions.FileOperation;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelper;
import com.oxygenxml.positron.utilities.functions.RAGException;
import com.oxygenxml.positron.utilities.functions.RelatedReusableComponent;
import com.oxygenxml.positron.utilities.functions.parameters.ContentParams;
import com.oxygenxml.positron.utilities.functions.parameters.DocumentOverview;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Segment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.extensions.api.node.AuthorDocumentProvider;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public abstract class ProjectHelper
extends ProjectHelperBase {
    private static final int MAX_TEXT_LEN_OVERVIEW = 200;
    private static final String OVERVIEW_IMPORTANT_KEYWORDS_XPATH = "//title | //keyword | //indexterm | //shortdesc | //abstract";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ProjectHelper.class.getName());

    protected abstract List<URL> getRelatedProjectURLs(String var1) throws RAGException;

    public static boolean isContentTypeOfInterest(String contentType, String extension) {
        return contentType != null && ("text/plain".equals(contentType) || "text/markdown".equals(contentType) || "text/xml".equals(contentType)) && !"ditamap".equals(extension) && !"framwework".equals(extension) && !"xpr".equals(extension);
    }

    public abstract boolean isRagAvailable();

    public boolean isListDirectoryFilesAvailable() {
        return false;
    }

    public boolean isSearchInProjectAvailable() {
        return false;
    }

    public List<DocumentOverview> getRelatedProjectResourcesOverview(String keywords) throws RAGException {
        AiIgnoreManager aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker();
        ArrayList<DocumentOverview> docs = new ArrayList<DocumentOverview>();
        List<URL> relatedURLs = this.getRelatedProjectURLs(keywords);
        if (!relatedURLs.isEmpty()) {
            for (URL url : relatedURLs) {
                if (aiIgnoreChecker != null && aiIgnoreChecker.isIgnoredFromAiIgnoreFile(url)) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    String msg = String.format("Skipping %s while getting related project resources overview because the file is marked for AI to ignore", URLUtil.filterPasswords((String)url.toExternalForm()));
                    LOGGER.debug(msg);
                    continue;
                }
                DocumentOverview overview = ProjectHelper.getOverview(url);
                if (overview == null) continue;
                docs.add(overview);
            }
        }
        return docs;
    }

    private static DocumentOverview getOverview(URL url) {
        String contentType = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().getContentType(url.toString());
        try {
            String overview = null;
            if ("text/xml".equals(contentType)) {
                AuthorDocumentProvider authProvider = PluginWorkspaceProvider.getPluginWorkspace().createAuthorDocumentProvider(url, null);
                AuthorNode[] nodes = authProvider.getAuthorDocumentController().findNodesByXPath(OVERVIEW_IMPORTANT_KEYWORDS_XPATH, true, true, true);
                if (nodes != null && nodes.length > 0) {
                    StringBuilder overviewBuilder = new StringBuilder();
                    for (AuthorNode node : nodes) {
                        Segment seg = new Segment();
                        authProvider.getAuthorDocumentController().getChars(node.getStartOffset(), node.getEndOffset() - node.getStartOffset(), seg);
                        overviewBuilder.append(seg.toString().replace('\u0000', ' ').trim());
                        overviewBuilder.append(" ");
                    }
                    overview = overviewBuilder.toString();
                }
            } else {
                StringBuilder content = IOUtil.read((Reader)PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().createReader(url, "UTF-8"));
                if (content.length() > 0) {
                    String string = overview = content.length() > 200 ? content.substring(0, 200) : content.toString();
                }
            }
            if (overview != null) {
                return new DocumentOverview(url.toExternalForm(), overview);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex, (Throwable)ex);
        }
        return null;
    }

    public abstract List<RelatedReusableComponent> getRelatedReusableComponents(String var1) throws RAGException;

    public abstract boolean isReusableComponentsRagAvailable();

    public String getDocumentContent(String docURL, ContentParams properties) throws IOException {
        IOException[] ex = new IOException[1];
        String toReturn = ContextExtractorUtil.getContentOrAccessDeniedMessage((String)docURL, () -> {
            try {
                return super.getDocumentContent(docURL, properties);
            }
            catch (IOException e) {
                ex[0] = e;
                return null;
            }
        }, (boolean)false, (FunctionsAndRAGHelper)this);
        if (ex[0] != null) {
            throw ex[0];
        }
        return toReturn;
    }

    public void checkDocumentAccessPermissions(String docURL, boolean isCurrentEditedDocument, boolean forceSkipAiIgnoreChecks) throws AccessDeniedException {
        AiIgnoreManager aiIgnoreChecker;
        if (!forceSkipAiIgnoreChecks && (aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker()) != null && aiIgnoreChecker.isIgnoredFromAiIgnoreFile(URLUtil.convertToURL((String)docURL))) {
            String msg = MessageFormat.format(Translator.getInstance().getTranslation("Access_denied_to_File_is_not_AI_accessible"), URLUtil.filterPasswords((String)docURL));
            throw new AccessDeniedException(msg);
        }
        if (docURL != null && !isCurrentEditedDocument && !ProjectHelperSandbox.accept((String)docURL)) {
            throw new AccessDeniedException(ProjectHelperSandbox.getAccessDeniedMessage((String)docURL));
        }
    }

    protected void processReusableComponentInfo(URL base, Object object, List<RelatedReusableComponent> comps) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, MalformedURLException {
        String description = (String)object.getClass().getMethod("getDescription", null).invoke(object, (Object[])null);
        String qname = (String)object.getClass().getMethod("getQName", null).invoke(object, (Object[])null);
        String topicIDPath = (String)object.getClass().getMethod("getTopicElementIDPath", null).invoke(object, (Object[])null);
        String url = (String)object.getClass().getMethod("getURL", null).invoke(object, (Object[])null);
        URL urlOfReusableComponent = new URL(url);
        AiIgnoreManager aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker();
        if (aiIgnoreChecker != null && aiIgnoreChecker.isIgnoredFromAiIgnoreFile(urlOfReusableComponent)) {
            if (LOGGER.isDebugEnabled()) {
                String msg = String.format("Skipping %s while processing reusable components because the file is marked for AI to ignore", URLUtil.filterPasswords((String)url));
                LOGGER.debug(msg);
            }
        } else {
            String insertConref = null;
            String keyForURL = DITAAccess.getKeyForUrl((URL)urlOfReusableComponent, (URL)base);
            String anchor = "#" + topicIDPath;
            if (keyForURL != null) {
                String elementId = topicIDPath;
                int slashIndex = elementId.indexOf(47);
                if (slashIndex != -1 && slashIndex < elementId.length() - 1) {
                    elementId = elementId.substring(slashIndex + 1);
                }
                insertConref = "<" + qname + " conkeyref=\"" + keyForURL + "/" + elementId + "\"/>";
            } else {
                String relativeUrl = url;
                if (base != null) {
                    relativeUrl = URLUtil.makeRelative((URL)base, (URL)urlOfReusableComponent);
                }
                insertConref = "<" + qname + " conref=\"" + relativeUrl + anchor + "\"/>";
            }
            comps.add(new RelatedReusableComponent(url + anchor, description, insertConref));
        }
    }

    public String listFiles(String folderPath) throws RAGException {
        return null;
    }

    public boolean isCopyMoveRenamePathsAvailable() {
        return false;
    }

    public String copyMoveRename(String sourcePath, String destinationPath, FileOperation operation) throws IOException {
        return null;
    }
}

