/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.project;

import com.oxygenxml.positron.utilities.functions.FileOperation;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.project.ProjectController;

public class CopyMoveRenameUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CopyMoveRenameUtil.class.getName());
    private static final String STATUS_SUCCESS = "Operation successful.";
    private static final String STATUS_SUCCESS_WITH_DESTINATION = "Operation successful. Destination path created: '";
    private static final String STATUS_REFERENCES_NOT_UPDATED = "References to the original resource were not automatically updated.";

    private CopyMoveRenameUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String copyMoveRename(String sourcePath, String destinationPath, FileOperation operation) throws IOException {
        sourcePath = CopyMoveRenameUtil.getPathAsLocalPath(sourcePath);
        destinationPath = CopyMoveRenameUtil.getPathAsLocalPath(destinationPath);
        File sourceFile = new File(sourcePath);
        File destinationFile = new File(destinationPath);
        if (!sourceFile.exists()) {
            throw new IOException("Source file does not exist: " + sourceFile);
        }
        if (destinationFile.equals(sourceFile)) {
            throw new IOException("Source and destination paths are the same: " + sourceFile);
        }
        Object statusMessage = null;
        if (operation == FileOperation.MOVE_OR_RENAME) {
            statusMessage = CopyMoveRenameUtil.moveRenameWithProjectAPI(sourcePath, destinationPath);
        }
        if (statusMessage == null) {
            WSEditor editorAccess = PluginWorkspaceProvider.getPluginWorkspace().getEditorAccess(URLUtil.correct((File)sourceFile), 0);
            if (editorAccess != null && editorAccess.isModified()) {
                editorAccess.save();
            }
            File destFile = CopyMoveRenameUtil.copyFileOrFolderToDestination(sourceFile, destinationFile, destinationPath);
            if (operation == FileOperation.MOVE_OR_RENAME) {
                FileSystemUtil.deleteRecursivelly((File)sourceFile);
            }
            CopyMoveRenameUtil.refreshProject(sourceFile, destFile);
            statusMessage = STATUS_SUCCESS_WITH_DESTINATION + destFile + "'.";
            if (operation == FileOperation.MOVE_OR_RENAME) {
                statusMessage = (String)statusMessage + STATUS_REFERENCES_NOT_UPDATED;
            }
        }
        return statusMessage;
    }

    private static void refreshProject(File sourceFile, File destFile) {
        ProjectController projectController;
        if (PluginWorkspaceProvider.getPluginWorkspace() instanceof StandalonePluginWorkspace && (projectController = ((StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getProjectManager()) != null) {
            ArrayList<File> toRefresh = new ArrayList<File>();
            File toRefreshSrc = sourceFile;
            if (toRefreshSrc.isFile() && (toRefreshSrc = toRefreshSrc.getParentFile()) != null) {
                toRefresh.add(toRefreshSrc);
            }
            if (destFile.isFile()) {
                File parent = destFile.getParentFile();
                if (parent != null) {
                    toRefresh.add(parent);
                }
            } else {
                File parent = destFile.getParentFile();
                if (parent != null) {
                    toRefresh.add(parent);
                }
                toRefresh.add(destFile);
            }
            if (!toRefresh.isEmpty()) {
                projectController.refreshFolders(toRefresh.toArray(new File[0]));
            }
        }
    }

    private static File copyFileOrFolderToDestination(File sourceFile, File destinationFile, String destinationPath) throws IOException {
        boolean isDestinationAFolder;
        boolean bl = isDestinationAFolder = destinationPath.endsWith("/") || destinationFile.isDirectory();
        if (sourceFile.isFile()) {
            return CopyMoveRenameUtil.copyFileToDestination(sourceFile, destinationFile, isDestinationAFolder);
        }
        return CopyMoveRenameUtil.copyDirectoryToDestination(sourceFile, destinationFile);
    }

    private static File copyFileToDestination(File sourceFile, File destinationFile, boolean isDestinationAFolder) throws IOException {
        if (destinationFile.isFile()) {
            FileSystemUtil.copyFile((File)sourceFile, (File)destinationFile, (boolean)false);
            return destinationFile;
        }
        File targetFile = CopyMoveRenameUtil.resolveTargetFileForFileCopy(sourceFile, destinationFile, isDestinationAFolder);
        FileSystemUtil.copyFile((File)sourceFile, (File)targetFile, (boolean)false);
        return targetFile;
    }

    private static File resolveTargetFileForFileCopy(File sourceFile, File destinationFile, boolean isDestinationAFolder) {
        if (isDestinationAFolder) {
            if (!destinationFile.exists()) {
                destinationFile.mkdirs();
            }
            return new File(destinationFile, sourceFile.getName());
        }
        return destinationFile;
    }

    private static File copyDirectoryToDestination(File sourceDirectory, File destinationFile) throws IOException {
        if (destinationFile.isFile()) {
            throw new IOException("Cannot copy folder to file");
        }
        boolean copyInsideDestination = destinationFile.exists();
        destinationFile.mkdirs();
        File targetDirectory = copyInsideDestination ? new File(destinationFile, sourceDirectory.getName()) : destinationFile;
        FileSystemUtil.copyDir((File)sourceDirectory, (File)targetDirectory, (boolean)true, (boolean)false);
        return targetDirectory;
    }

    private static String moveRenameWithProjectAPI(String sourcePath, String destinationPath) throws IOException {
        ProjectController projectController;
        Object message = null;
        if (PluginWorkspaceProvider.getPluginWorkspace() instanceof StandalonePluginWorkspace && (projectController = ((StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getProjectManager()) != null) {
            try {
                Method moveRename = projectController.getClass().getMethod("moveRename", String.class, String.class);
                Object result = moveRename.invoke((Object)projectController, sourcePath, destinationPath);
                boolean success = (Boolean)result.getClass().getMethod("isSuccesfull", new Class[0]).invoke(result, new Object[0]);
                if (success) {
                    message = STATUS_SUCCESS;
                    message = (String)message + "\nModified resources which contain references to the changed resource: " + result.getClass().getMethod("getModifiedResources", new Class[0]).invoke(result, new Object[0]);
                }
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() instanceof IOException) {
                    throw (IOException)ex.getTargetException();
                }
                LOGGER.error(ex.getTargetException());
                throw new IOException(ex.getTargetException().getMessage(), ex.getTargetException());
            }
            catch (Exception e) {
                LOGGER.debug("API does not exist.\n" + e.getMessage(), (Throwable)e);
            }
        }
        return message;
    }

    private static String getPathAsLocalPath(String path) throws IOException {
        try {
            URL sourceURL = new URL(path);
            File file = URLUtil.getCanonicalFileFromFileUrl((URL)sourceURL);
            if (file == null) {
                throw new IOException("Path does not point to local resource: " + path);
            }
            path = file.getAbsolutePath();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return path;
    }
}

