/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.history;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.plugin.chat.ChatModel;
import com.oxygenxml.positron.plugin.ui.history.LimitedSizeHistoryList;
import com.oxygenxml.positron.plugin.util.SecurityHelper;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class ChatHistoryOptionsManager {
    private static final Logger log = LoggerFactory.getLogger(ChatHistoryOptionsManager.class);
    private static final SecurityHelper SECURITY_HELPER = SecurityHelper.getInstance();
    public static final int MAX_ENTRIES = 20;

    private ChatHistoryOptionsManager() {
        throw new UnsupportedOperationException("Instantiation of this class is not allowed!");
    }

    public static void clearHistory() {
        ChatHistoryOptionsManager.getOptionsStorage().setStringArrayOption("oxygen.positron.plugin.chat.history.encrypted", null);
    }

    public static void save(ChatModel chatModel) {
        WSOptionsStorage optionsStorage = ChatHistoryOptionsManager.getOptionsStorage();
        String[] chatHistory = optionsStorage.getStringArrayOption("oxygen.positron.plugin.chat.history", null);
        if (chatHistory != null) {
            ChatHistoryOptionsManager.save(chatModel, chatHistory, false);
            optionsStorage.setStringArrayOption("oxygen.positron.plugin.chat.history", null);
        } else {
            chatHistory = optionsStorage.getStringArrayOption("oxygen.positron.plugin.chat.history.encrypted", null);
            if (chatHistory != null) {
                ChatHistoryOptionsManager.save(chatModel, chatHistory, true);
            } else {
                try {
                    String modelToSaveAsString = AIRequestUtil.defaultObjectMapper().writeValueAsString((Object)chatModel);
                    optionsStorage.setStringArrayOption("oxygen.positron.plugin.chat.history.encrypted", new String[]{SECURITY_HELPER.encryptText(modelToSaveAsString)});
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
        }
    }

    private static void save(ChatModel chatModel, String[] chatHistory, boolean modelsAreEncrypted) {
        ObjectMapper objectMapper = AIRequestUtil.defaultObjectMapper();
        LimitedSizeHistoryList<String> historyList = new LimitedSizeHistoryList<String>(20);
        for (String modelFromHistory : chatHistory) {
            try {
                ChatModel modelFromOptions;
                boolean isOlderVersionOfModelToSave;
                String modelJson;
                String string = modelJson = modelsAreEncrypted ? SECURITY_HELPER.decryptText(modelFromHistory) : modelFromHistory;
                if (modelJson == null || (isOlderVersionOfModelToSave = (modelFromOptions = (ChatModel)objectMapper.readValue(modelJson, ChatModel.class)).isSameInteraction(chatModel))) continue;
                historyList.append(SECURITY_HELPER.encryptText(modelJson));
            }
            catch (JsonProcessingException e) {
                log.debug((Object)e, (Throwable)e);
            }
        }
        try {
            String modelToSaveAsString = objectMapper.writeValueAsString((Object)chatModel);
            historyList.append(SECURITY_HELPER.encryptText(modelToSaveAsString));
        }
        catch (JsonProcessingException e) {
            log.debug((Object)e, (Throwable)e);
        }
        ChatHistoryOptionsManager.getOptionsStorage().setStringArrayOption("oxygen.positron.plugin.chat.history.encrypted", historyList.toArray(new String[0]));
    }

    public static List<ChatModel> load() {
        ArrayList<ChatModel> historyObjects = new ArrayList<ChatModel>();
        WSOptionsStorage optionsStorage = ChatHistoryOptionsManager.getOptionsStorage();
        String[] currentChatHistory = optionsStorage.getStringArrayOption("oxygen.positron.plugin.chat.history", null);
        if (currentChatHistory != null) {
            ChatHistoryOptionsManager.loadModelsFromOptions(historyObjects, currentChatHistory, false);
        } else {
            currentChatHistory = optionsStorage.getStringArrayOption("oxygen.positron.plugin.chat.history.encrypted", null);
            if (currentChatHistory != null) {
                ChatHistoryOptionsManager.loadModelsFromOptions(historyObjects, currentChatHistory, true);
            }
        }
        return historyObjects;
    }

    private static void loadModelsFromOptions(List<ChatModel> historyObjects, String[] currentChatHistory, boolean isHistoryEncrypted) {
        ObjectMapper mapper = AIRequestUtil.defaultObjectMapper();
        for (String model : currentChatHistory) {
            try {
                String decryptedModel;
                String string = decryptedModel = isHistoryEncrypted ? SECURITY_HELPER.decryptText(model) : model;
                if (decryptedModel == null) continue;
                ChatModel chatModel = (ChatModel)mapper.readValue(decryptedModel, ChatModel.class);
                historyObjects.add(chatModel);
            }
            catch (JsonProcessingException e) {
                log.debug((Object)e, (Throwable)e);
            }
        }
    }

    private static WSOptionsStorage getOptionsStorage() {
        return PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
    }
}

