/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.favorites;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.attach.SelectionAttachmentUtil;
import com.oxygenxml.positron.plugin.chat.UserInputTextHandler;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentsChangedListener;
import com.oxygenxml.positron.plugin.chat.attachments.ChatChipAttachmentManager;
import com.oxygenxml.positron.plugin.chat.attachments.MessageDescriptionUtil;
import com.oxygenxml.positron.plugin.chat.favorites.AddFavoriteDialog;
import com.oxygenxml.positron.plugin.chat.favorites.NewChatStarter;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.SecurityHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.SplitMenuButton;

public class FavoritesManager {
    private static final Pattern ATTACH_PATTERN_WITH_PREFIX_AND_SUFFIX_GROUPS = Pattern.compile("(\\$\\{attach\\()(.*?)(\\)\\})");
    private static final ImageIcon REMOVE_ALL_ICON = IconsLoader.loadIcon("/images/RemoveAll16.png");
    private static final ImageIcon FAVORTIES_DROP_DOWN_ICON = IconsLoader.loadIcon("/images/XPathAdd2Favorites16.png");
    private static final ImageIcon REMOVE_FAVORITES_ICON = IconsLoader.loadIcon("/images/RemoveSelected16.png");
    private static final ImageIcon NEW_CHAT_ICON = IconsLoader.loadIcon("/images/NewChat16.png");
    private static final String FAVORITES_DELIM = "###-Delim-###";
    private static final Translator TRANSLATOR = Translator.getInstance();
    private static final SecurityHelper SECURITY_HELPER = SecurityHelper.getInstance();
    private AbstractAction addRemoveFavoritesAction;
    private SplitMenuButton favoritesComponent;
    private UserInputTextHandler userInputTextUpdater;
    private PluginWorkspace pluginWorkspace;
    private NewChatStarter newChatStarter;
    private ChatChipAttachmentManager chipsManager;

    public FavoritesManager(PluginWorkspace pluginWorkspace) {
        this.pluginWorkspace = pluginWorkspace;
    }

    public SplitMenuButton createFavoritesDropDown(UserInputTextHandler userInputTextUpdater, ChatChipAttachmentManager chipsManager) {
        this.userInputTextUpdater = userInputTextUpdater;
        this.chipsManager = chipsManager;
        this.favoritesComponent = OxygenUIComponentsFactory.createSplitMenuButton(null, (Icon)FAVORTIES_DROP_DOWN_ICON, (boolean)false, (boolean)false, (boolean)true, (boolean)false);
        this.favoritesComponent.setToolTipText(TRANSLATOR.getTranslation("Favorites"));
        this.addRemoveFavoritesAction = this.createAddRemoveFavoritesAction(userInputTextUpdater);
        this.addRemoveFavoritesAction.setEnabled(false);
        userInputTextUpdater.onTextUpdate(this::reconfigureAddRemoveFavorites);
        chipsManager.addAttachmentsChangedListener(new AttachmentsChangedListener(){

            @Override
            public void attachmentAdded(URL attachment) {
                SwingUtilities.invokeLater(() -> FavoritesManager.this.reconfigureAddRemoveFavorites());
            }

            @Override
            public void attachmentRemoved(URL attachment) {
                SwingUtilities.invokeLater(() -> FavoritesManager.this.reconfigureAddRemoveFavorites());
            }
        });
        this.populateFavorites();
        return this.favoritesComponent;
    }

    public void addFavoritePrompt(String promptText, String favPromptName, boolean shouldStartNewChat) {
        this.addNewFavoriteToOptions(promptText, favPromptName, shouldStartNewChat);
        this.reconfigureAddRemoveFavorites();
    }

    private AbstractAction createAddRemoveFavoritesAction(final UserInputTextHandler userInputTextUpdater) {
        return new AbstractAction(TRANSLATOR.getTranslation("Add_to_favorites") + "...", FAVORTIES_DROP_DOWN_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                String currentTextWithAttachments = FavoritesManager.this.computeFavoriteTextFromUserInput(userInputTextUpdater);
                boolean isInFavorites = FavoritesManager.this.isCurrentTextInFavorites(currentTextWithAttachments);
                String matchingFavorite = null;
                if (isInFavorites) {
                    for (String favorite : FavoritesManager.this.getFavorites()) {
                        if (!FavoritesManager.areFavoritesEquivalent(currentTextWithAttachments, favorite)) continue;
                        matchingFavorite = favorite;
                        break;
                    }
                }
                if (isInFavorites) {
                    FavoritesManager.this.removeFromFavorites(matchingFavorite);
                } else {
                    boolean hasContent;
                    boolean hasText = !userInputTextUpdater.getText().isEmpty();
                    boolean hasAttachments = FavoritesManager.this.chipsManager != null && FavoritesManager.this.chipsManager.hasAttachments();
                    boolean bl = hasContent = hasText || hasAttachments;
                    if (hasContent) {
                        FavoritesManager.this.addNewFavoriteToOptions(currentTextWithAttachments);
                    }
                }
                FavoritesManager.this.reconfigureAddRemoveFavorites();
            }
        };
    }

    private boolean isCurrentTextInFavorites(String currentTextWithAttachments) {
        return this.getFavorites().stream().anyMatch(favorite -> FavoritesManager.areFavoritesEquivalent(currentTextWithAttachments, favorite));
    }

    @VisibleForTesting
    void reconfigureAddRemoveFavorites() {
        this.addRemoveFavoritesAction.setEnabled(true);
        String currentTextWithAttachments = this.computeFavoriteTextFromUserInput(this.userInputTextUpdater);
        boolean isInFavorites = this.isCurrentTextInFavorites(currentTextWithAttachments);
        if (isInFavorites) {
            this.addRemoveFavoritesAction.putValue("Name", TRANSLATOR.getTranslation("Remove_from_favorites"));
            this.addRemoveFavoritesAction.putValue("SmallIcon", REMOVE_FAVORITES_ICON);
        } else {
            boolean hasText = !this.userInputTextUpdater.getText().isEmpty();
            boolean hasAttachments = this.chipsManager != null && this.chipsManager.hasAttachments();
            boolean hasContent = hasText || hasAttachments;
            this.addRemoveFavoritesAction.setEnabled(hasContent);
            this.addRemoveFavoritesAction.putValue("Name", TRANSLATOR.getTranslation("Add_to_favorites") + "...");
            this.addRemoveFavoritesAction.putValue("SmallIcon", FAVORTIES_DROP_DOWN_ICON);
        }
        this.populateFavorites();
    }

    private String computeFavoriteTextFromUserInput(UserInputTextHandler userInputTextUpdater) {
        String rawUserInput = userInputTextUpdater.getPlainTextContentWithAttachmentsExpanded() + userInputTextUpdater.getUnreferencedAttachmentsWithMarkerToAddToModel();
        StringBuilder builder = new StringBuilder();
        Matcher matcher = ATTACH_PATTERN_WITH_PREFIX_AND_SUFFIX_GROUPS.matcher(rawUserInput);
        while (matcher.find()) {
            String resource = matcher.group(2);
            if (!SelectionAttachmentUtil.isSelectionURL((String)resource)) continue;
            matcher.appendReplacement(builder, Matcher.quoteReplacement(matcher.group(1) + "selection://aipositron/selection" + matcher.group(3)));
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    private void populateFavorites() {
        this.favoritesComponent.removeAll();
        this.favoritesComponent.add((Action)this.addRemoveFavoritesAction);
        List<String> favoritePrompts = this.getFavorites();
        List<String> favoritePromptNames = this.getOptionListValue("oxygen.positron.plugin.favorite.prompt.names");
        List<String> favoritePromptNewChatOptions = this.getOptionListValue("oxygen.positron.plugin.favorite.prompts.start.new.chat.checked.list");
        if (!favoritePrompts.isEmpty()) {
            this.favoritesComponent.addSeparator();
            for (int i = 0; i < favoritePromptNames.size(); ++i) {
                if (i >= favoritePrompts.size()) continue;
                AbstractAction usePromptAction = this.createUsePromptAction(favoritePrompts, favoritePromptNames, favoritePromptNewChatOptions, i);
                this.favoritesComponent.add((Action)usePromptAction);
            }
            this.favoritesComponent.addSeparator();
            this.favoritesComponent.add((Action)this.createClearFavoritesAction());
        }
    }

    private AbstractAction createClearFavoritesAction() {
        return new AbstractAction(TRANSLATOR.getTranslation("Clear_favorites") + "...", REMOVE_ALL_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog((Component)FavoritesManager.this.pluginWorkspace.getParentFrame(), TRANSLATOR.getTranslation("Clear_favorites_confirmation"), TRANSLATOR.getTranslation("Clear_favorites"), 0);
                if (0 == result) {
                    FavoritesManager.this.saveList(null, "oxygen.positron.plugin.favorite.prompts.encrypted");
                    FavoritesManager.this.saveList(null, "oxygen.positron.plugin.favorite.prompt.names");
                    FavoritesManager.this.saveList(null, "oxygen.positron.plugin.favorite.prompts.start.new.chat.checked.list");
                    FavoritesManager.this.reconfigureAddRemoveFavorites();
                }
            }
        };
    }

    private AbstractAction createUsePromptAction(final List<String> favoritePrompts, List<String> favoritePromptNames, List<String> favoritePromptNewChatOptions, final int index) {
        final boolean shouldStartNewChat = favoritePromptNewChatOptions.size() > index && Boolean.parseBoolean(favoritePromptNewChatOptions.get(index));
        return new AbstractAction(favoritePromptNames.get(index), shouldStartNewChat ? NEW_CHAT_ICON : null){
            {
                super(arg0, arg1);
                String cleanTooltip = MessageDescriptionUtil.computeHumanReadableDescription((String)favoritePrompts.get(index));
                this.putValue("ShortDescription", cleanTooltip);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (shouldStartNewChat && FavoritesManager.this.newChatStarter != null) {
                    FavoritesManager.this.newChatStarter.start();
                }
                String favoritePrompt = (String)favoritePrompts.get(index);
                FavoritesManager.this.processFavoriteWithAttachments(favoritePrompt);
                FavoritesManager.this.reconfigureAddRemoveFavorites();
            }
        };
    }

    private void processFavoriteWithAttachments(String favoritePrompt) {
        this.userInputTextUpdater.clearAll();
        this.userInputTextUpdater.setText(favoritePrompt);
    }

    private void removeFromFavorites(String favPrompt) {
        List<String> prompts;
        int index;
        if (!favPrompt.isEmpty() && (index = (prompts = this.getFavorites()).indexOf(favPrompt)) != -1) {
            List<String> promptNewChat;
            prompts.remove(index);
            this.saveFavorites(prompts);
            List<String> promptNames = this.getOptionListValue("oxygen.positron.plugin.favorite.prompt.names");
            if (index < promptNames.size()) {
                promptNames.remove(index);
                this.saveList(promptNames, "oxygen.positron.plugin.favorite.prompt.names");
            }
            if (index < (promptNewChat = this.getOptionListValue("oxygen.positron.plugin.favorite.prompts.start.new.chat.checked.list")).size()) {
                promptNewChat.remove(index);
                this.saveList(promptNewChat, "oxygen.positron.plugin.favorite.prompts.start.new.chat.checked.list");
            }
        }
    }

    private List<String> getFavorites() {
        List<String> favorites = this.getOptionListValue("oxygen.positron.plugin.favorite.prompts");
        if (!favorites.isEmpty()) {
            this.pluginWorkspace.getOptionsStorage().setOption("oxygen.positron.plugin.favorite.prompts", null);
            this.saveFavorites(favorites);
        } else {
            String value = this.pluginWorkspace.getOptionsStorage().getOption("oxygen.positron.plugin.favorite.prompts.encrypted", "");
            String[] favsPromptsArray = value.split(FAVORITES_DELIM);
            for (int i = 0; i < favsPromptsArray.length; ++i) {
                String prompt;
                if (favsPromptsArray[i].isEmpty() || (prompt = SECURITY_HELPER.decryptText(favsPromptsArray[i])) == null) continue;
                favorites.add(prompt);
            }
        }
        return favorites;
    }

    private void saveFavorites(List<String> list) {
        StringBuilder val = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            for (String value : list) {
                val.append(SECURITY_HELPER.encryptText(value)).append(FAVORITES_DELIM);
            }
        }
        this.pluginWorkspace.getOptionsStorage().setOption("oxygen.positron.plugin.favorite.prompts.encrypted", val.toString());
    }

    private List<String> getOptionListValue(String optionTag) {
        ArrayList<String> toReturn = new ArrayList<String>();
        String value = this.pluginWorkspace.getOptionsStorage().getOption(optionTag, "");
        String[] favsPromptsArray = value.split(FAVORITES_DELIM);
        if (favsPromptsArray != null) {
            for (int i = 0; i < favsPromptsArray.length; ++i) {
                if (favsPromptsArray[i].isEmpty()) continue;
                toReturn.add(favsPromptsArray[i]);
            }
        }
        return toReturn;
    }

    private void saveList(List<String> list, String optionTag) {
        StringBuilder val = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            for (String value : list) {
                val.append(value).append(FAVORITES_DELIM);
            }
        }
        this.pluginWorkspace.getOptionsStorage().setOption(optionTag, val.toString());
    }

    private void addNewFavoriteToOptions(String promptText) {
        AddFavoriteDialog addFavoriteDialog = new AddFavoriteDialog();
        addFavoriteDialog.setVisible(true);
        if (1 == addFavoriteDialog.getResult()) {
            String favPromptName = addFavoriteDialog.getFavoriteName();
            this.addNewFavoriteToOptions(promptText, favPromptName, addFavoriteDialog.shouldStartNewChat());
        }
    }

    @VisibleForTesting
    void addNewFavoriteToOptions(String promptText, String promptName, boolean shouldStartNewChat) {
        if (promptName != null) {
            List<String> prompts = this.getFavorites();
            List<String> promptsNewChatOptions = this.getOptionListValue("oxygen.positron.plugin.favorite.prompts.start.new.chat.checked.list");
            if (prompts.size() > promptsNewChatOptions.size()) {
                int noOfPromptsWithoutOptions = prompts.size() - promptsNewChatOptions.size();
                IntStream.range(0, noOfPromptsWithoutOptions).forEach(it -> promptsNewChatOptions.add(String.valueOf(Boolean.FALSE)));
            }
            prompts.add(promptText);
            this.saveFavorites(prompts);
            List<String> promptNames = this.getOptionListValue("oxygen.positron.plugin.favorite.prompt.names");
            promptNames.add(promptName);
            this.saveList(promptNames, "oxygen.positron.plugin.favorite.prompt.names");
            promptsNewChatOptions.add(String.valueOf(shouldStartNewChat));
            this.saveList(promptsNewChatOptions, "oxygen.positron.plugin.favorite.prompts.start.new.chat.checked.list");
        }
    }

    public void setNewChatCreator(NewChatStarter newChatStarter) {
        this.newChatStarter = newChatStarter;
    }

    static boolean areFavoritesEquivalent(String text1, String text2) {
        String[] parts2;
        if (text1 == null || text2 == null) {
            return false;
        }
        String[] parts1 = text1.split("#################attachments#################", 2);
        if (!parts1[0].equals((parts2 = text2.split("#################attachments#################", 2))[0])) {
            return false;
        }
        if (parts1.length > 1 && parts2.length > 1) {
            return FavoritesManager.areUnreferencedAttachmentsEquivalent(parts1[1], parts2[1]);
        }
        return parts1.length == parts2.length;
    }

    private static boolean areUnreferencedAttachmentsEquivalent(String attachments1, String attachments2) {
        if (attachments1.equals(attachments2)) {
            return true;
        }
        List<String> patterns1 = FavoritesManager.extractAttachmentPatterns(attachments1);
        List<String> patterns2 = FavoritesManager.extractAttachmentPatterns(attachments2);
        return patterns1.size() == patterns2.size() && patterns1.containsAll(patterns2);
    }

    private static List<String> extractAttachmentPatterns(String text) {
        ArrayList<String> patterns = new ArrayList<String>();
        String pattern = "\\$\\{attach\\([^}]+\\)\\}";
        Pattern attachPattern = Pattern.compile(pattern);
        Matcher matcher = attachPattern.matcher(text);
        while (matcher.find()) {
            patterns.add(matcher.group(0));
        }
        return patterns;
    }

    public SplitMenuButton getFavoritesSplitButtonForTC() {
        return this.favoritesComponent;
    }
}

