/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.favorites;

import com.oxygenxml.positron.core.plugin.Translator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.ui.OKCancelDialog;
import ro.sync.exml.workspace.api.standalone.ui.TextField;

public class AddFavoriteDialog
extends OKCancelDialog {
    private static final int DEFAULT_INSET = 3;
    private static final Translator TRANSLATOR = Translator.getInstance();
    private final JTextField favoriteNameField = new TextField();
    private final JCheckBox shouldStartNewChat = new JCheckBox(TRANSLATOR.getTranslation("Start_New_Chat"));
    private static final int DIALOG_WIDTH = 300;
    private final WSOptionsStorage optionsManager = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();

    public AddFavoriteDialog() {
        super(PluginWorkspaceProvider.getPluginWorkspace() != null ? (JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame() : null, TRANSLATOR.getTranslation("Add_to_favorites"), true);
        this.setOkButtonText(TRANSLATOR.getTranslation("Add"));
        this.getOkButton().setEnabled(false);
        JPanel panel = new JPanel(new GridBagLayout());
        this.createGUI(panel);
        this.add(panel);
        this.setResizable(true);
        this.pack();
        this.favoriteNameField.requestFocus();
        this.favoriteNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateOKButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateOKButton();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void updateOKButton() {
                AddFavoriteDialog.this.getOkButton().setEnabled(!AddFavoriteDialog.this.favoriteNameField.getText().isBlank());
            }
        });
        this.setMinimumSize(this.getPreferredSize());
        Dimension maximumSize = this.getMaximumSize();
        maximumSize.height = this.getPreferredSize().height;
        this.setMaximumSize(maximumSize);
    }

    private void createGUI(JPanel panel) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 3, 0);
        JLabel nameLabel = new JLabel(TRANSLATOR.getTranslation("Name") + ":");
        panel.add((Component)nameLabel, constraints);
        this.favoriteNameField.setPreferredSize(new Dimension(300, this.favoriteNameField.getPreferredSize().height));
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.insets = new Insets(3, 0, 0, 0);
        panel.add((Component)this.favoriteNameField, constraints);
        nameLabel.setLabelFor(this.favoriteNameField);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.fill = 0;
        this.shouldStartNewChat.setSelected(Boolean.parseBoolean(this.optionsManager.getOption("oxygen.positron.plugin.favorite.prompts.start.new.chat.default", String.valueOf(Boolean.TRUE))));
        panel.add((Component)this.shouldStartNewChat, constraints);
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 1;
        constraints.weighty = 1.0;
        ++constraints.gridy;
        panel.add((Component)new JPanel(), constraints);
    }

    protected void doOK() {
        super.doOK();
        this.optionsManager.setOption("oxygen.positron.plugin.favorite.prompts.start.new.chat.default", String.valueOf(this.shouldStartNewChat.isSelected()));
    }

    public String getFavoriteName() {
        return this.favoriteNameField.getText();
    }

    public boolean shouldStartNewChat() {
        return this.shouldStartNewChat.isSelected();
    }
}

