/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.editorvariables;

import com.oxygenxml.positron.core.actions.DefaultActionInteractor;
import com.oxygenxml.positron.core.actions.DefaultActionInteractorProvider;
import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.chat.editorvariables.EditorVariablesExpandException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorReviewController;
import ro.sync.ecss.extensions.api.component.AuthorComponentException;
import ro.sync.ecss.extensions.api.component.AuthorComponentFactory;
import ro.sync.ecss.extensions.api.component.EditorComponentProvider;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;

public class EditorVariablesManager {
    private static final Logger logger = LoggerFactory.getLogger(EditorVariablesManager.class);
    public static final String DOCUMENT_EDITOR_VARIABLE = "${document}";
    public static final String SELECTION_ORIGINAL_EDITOR_VARIABLE = "${selection-original}";
    public static final String SELECTION_FINAL_EDITOR_VARIABLE = "${selection-final}";
    public static final String ATTACH_EDITOR_VARIABLE_DESCRIPTOR = "${attach(...)}";

    public static boolean containsContentRelatedEditorVariables(String userInput) {
        if (userInput != null) {
            return userInput.contains("${selection}") || userInput.contains(DOCUMENT_EDITOR_VARIABLE) || userInput.contains(SELECTION_FINAL_EDITOR_VARIABLE) || userInput.contains(SELECTION_ORIGINAL_EDITOR_VARIABLE);
        }
        return false;
    }

    public static String expandEditorVariables(DefaultActionInteractorProvider defaultActionProvider, String userInput) throws EditorVariablesExpandException, BadLocationException, OperationCancelledByAiIgnoreException {
        DefaultActionInteractor defaultActionInteractor = defaultActionProvider.getDefaultActionInteractor();
        if (userInput.contains("${selection}")) {
            EditorVariablesManager.checkDocumentIsOpened(defaultActionInteractor);
            String sel = defaultActionInteractor.getSelectedContent(true, true);
            if (sel == null) {
                throw new EditorVariablesExpandException(Translator.getInstance().getTranslation("No_content_selected"));
            }
            userInput = userInput.replace("${selection}", sel);
        }
        if (userInput.contains(DOCUMENT_EDITOR_VARIABLE)) {
            EditorVariablesManager.checkDocumentIsOpened(defaultActionInteractor);
            String docContent = defaultActionInteractor.getEntireDocumentContent();
            if (docContent != null) {
                userInput = userInput.replace(DOCUMENT_EDITOR_VARIABLE, docContent);
            }
        }
        if (userInput.contains(SELECTION_ORIGINAL_EDITOR_VARIABLE) || userInput.contains(SELECTION_FINAL_EDITOR_VARIABLE)) {
            EditorVariablesManager.checkDocumentIsOpened(defaultActionInteractor);
            userInput = EditorVariablesManager.expandOriginalAndFinalTrackedChangesVariables(userInput, defaultActionInteractor);
        }
        return userInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String expandOriginalAndFinalTrackedChangesVariables(String userInput, DefaultActionInteractor defaultActionInteractor) {
        Optional<EditorComponentProvider> editorComponent = EditorVariablesManager.createEditorComponent(defaultActionInteractor.getDocumentLocation(), defaultActionInteractor.createDocumentReader());
        if (editorComponent.isPresent()) {
            try {
                WSAuthorEditorPage currentPage = (WSAuthorEditorPage)editorComponent.get().getWSEditorAccess().getCurrentPage();
                AuthorDocumentController documentController = currentPage.getDocumentController();
                Position startPos = documentController.createPositionInContent(defaultActionInteractor.getSelectionStart());
                Position endPos = documentController.createPositionInContent(defaultActionInteractor.getSelectionEnd());
                AuthorReviewController reviewController = currentPage.getReviewController();
                userInput = EditorVariablesManager.expandSelectionFinal(userInput, reviewController, documentController, startPos, endPos);
                userInput = EditorVariablesManager.expandSelectionOriginal(userInput, reviewController, documentController, startPos, endPos);
            }
            catch (BadLocationException e) {
                logger.error((Object)e, (Throwable)e);
            }
            finally {
                AuthorComponentFactory.getInstance().disposeEditorComponentProvider(editorComponent.get());
            }
        }
        return userInput;
    }

    private static Optional<EditorComponentProvider> createEditorComponent(String location, Reader reader) {
        try {
            EditorComponentProvider editorComponent = AuthorComponentFactory.getInstance().createEditorComponentProvider(new String[]{"Author"}, "Author");
            editorComponent.load(new URL(location), reader);
            return Optional.of(editorComponent);
        }
        catch (MalformedURLException | AuthorComponentException e) {
            logger.error((Object)e, e);
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String expandSelectionOriginal(String userInput, AuthorReviewController authorReviewController, AuthorDocumentController documentController, Position startPos, Position endPos) {
        if (userInput.contains(SELECTION_ORIGINAL_EDITOR_VARIABLE)) {
            try {
                authorReviewController.rejectSelection(startPos.getOffset(), endPos.getOffset());
                String originalContent = EditorVariablesManager.serializeContent(documentController, startPos.getOffset(), endPos.getOffset());
                userInput = userInput.replace(SELECTION_ORIGINAL_EDITOR_VARIABLE, originalContent);
            }
            catch (BadLocationException e) {
                logger.error((Object)e, (Throwable)e);
            }
            finally {
                documentController.getUndoManager().undo();
            }
        }
        return userInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String expandSelectionFinal(String userInput, AuthorReviewController authorReviewController, AuthorDocumentController documentController, Position startPos, Position endPos) {
        if (userInput.contains(SELECTION_FINAL_EDITOR_VARIABLE)) {
            try {
                authorReviewController.acceptSelection(startPos.getOffset(), endPos.getOffset());
                String finalContent = EditorVariablesManager.serializeContent(documentController, startPos.getOffset(), endPos.getOffset());
                userInput = userInput.replace(SELECTION_FINAL_EDITOR_VARIABLE, finalContent);
            }
            catch (BadLocationException e) {
                logger.error((Object)e, (Throwable)e);
            }
            finally {
                documentController.getUndoManager().undo();
            }
        }
        return userInput;
    }

    private static String serializeContent(AuthorDocumentController docCtrl, int start, int end) throws BadLocationException {
        AuthorDocumentFragment frag = docCtrl.createDocumentFragment(start, end - 1, true);
        return docCtrl.serializeFragmentToXML(frag);
    }

    private static void checkDocumentIsOpened(DefaultActionInteractor actionInteractor) throws EditorVariablesExpandException {
        if (actionInteractor == null || !actionInteractor.isDocumentOpened()) {
            throw new EditorVariablesExpandException(Translator.getInstance().getTranslation("No_document_opened"));
        }
    }
}

