/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.attachments;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;

public class AttachmentRemoveButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private static final int SIZE = 16;
    private static final int X_BASE_OFFSET = 3;
    private boolean isHovered = false;
    private Color hoverBackgroundColor;
    private Color xSymbolColor;

    public AttachmentRemoveButton() {
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setPreferredSize(new Dimension(16, 16));
        this.setToolTipText(Translator.getInstance().getTranslation("Remove"));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                AttachmentRemoveButton.this.isHovered = true;
                AttachmentRemoveButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AttachmentRemoveButton.this.isHovered = false;
                AttachmentRemoveButton.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int centerX = this.getWidth() >> 1;
        int centerY = this.getHeight() >> 1;
        if (this.isHovered) {
            Color hoverColor = this.hoverBackgroundColor != null ? this.hoverBackgroundColor : ThemeColorProvider.getInstance().getButtonHoverBackgroundColor();
            g2d.setColor(hoverColor);
            g2d.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        }
        Color xColor = this.xSymbolColor != null ? this.xSymbolColor : this.getForeground();
        g2d.setColor(xColor);
        g2d.drawLine(centerX - 3, centerY - 3, centerX + 3, centerY + 3);
        g2d.drawLine(centerX + 3, centerY - 3, centerX - 3, centerY + 3);
        g2d.drawLine(centerX - 4, centerY - 3, centerX + 2, centerY + 3);
        g2d.drawLine(centerX + 2, centerY - 3, centerX - 4, centerY + 3);
    }

    public void setHoverBackgroundColor(Color hoverBackgroundColor) {
        this.hoverBackgroundColor = hoverBackgroundColor;
    }

    public void setXSymbolColor(Color xSymbolColor) {
        this.xSymbolColor = xSymbolColor;
    }
}

