/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.attachments;

import com.oxygenxml.positron.core.util.attach.SelectionAttachmentUtil;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentChipUtil;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentReference;
import com.oxygenxml.positron.plugin.ui.CursorUtils;
import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Highlighter;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class AttachmentHighlightManager {
    private static final Logger log = LoggerFactory.getLogger(AttachmentHighlightManager.class);
    private static final Cursor SYSTEM_DEFAULT_CURSOR = Cursor.getDefaultCursor();
    private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private static final Pattern SELECTION_ATTACHMENT_REF_PATTERN = Pattern.compile(Pattern.quote("@selection"));
    private static final Highlighter.HighlightPainter ATTACHMENT_PAINTER = new DefaultHighlighter.DefaultHighlightPainter(ThemeColorProvider.getInstance().getAttachmentHighlightColor());
    private final JTextArea textArea;
    private final Map<String, List<AttachmentReference>> attachmentPositions = new HashMap<String, List<AttachmentReference>>();

    public AttachmentHighlightManager(JTextArea textArea) {
        this.textArea = textArea;
        this.installHighlightProtectionFilter();
        this.installMouseListener();
    }

    private void installMouseListener() {
        this.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int offset;
                String attachmentPath;
                Point point;
                if (SwingUtilities.isLeftMouseButton(e) && e.getModifiersEx() == 0 && AttachmentHighlightManager.this.isWithinTextBounds(point = e.getPoint()) && AttachmentHighlightManager.isNonSelectionAttachment(attachmentPath = AttachmentHighlightManager.this.getAttachmentPathAtPosition(offset = AttachmentHighlightManager.this.textArea.viewToModel2D(point)))) {
                    PluginWorkspaceProvider.getPluginWorkspace().open(URLUtil.convertToURL((String)attachmentPath));
                    e.consume();
                }
            }
        });
        this.textArea.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (e.getModifiersEx() == 0) {
                    Point point = e.getPoint();
                    Cursor textAreaDefaultCursor = CursorUtils.getDefaultCursor(AttachmentHighlightManager.this.textArea);
                    String listenerId = "attachment";
                    if (AttachmentHighlightManager.this.isWithinTextBounds(point)) {
                        int offset = AttachmentHighlightManager.this.textArea.viewToModel2D(point);
                        String attachmentPath = AttachmentHighlightManager.this.getAttachmentPathAtPosition(offset);
                        if (attachmentPath != null) {
                            if (SelectionAttachmentUtil.isSelectionURL((String)attachmentPath)) {
                                CursorUtils.setCursorIfDifferent(AttachmentHighlightManager.this.textArea, SYSTEM_DEFAULT_CURSOR, listenerId);
                            } else {
                                CursorUtils.setCursorIfDifferent(AttachmentHighlightManager.this.textArea, HAND_CURSOR, listenerId);
                            }
                        } else {
                            CursorUtils.setCursorIfDifferent(AttachmentHighlightManager.this.textArea, textAreaDefaultCursor, listenerId);
                        }
                    } else {
                        CursorUtils.setCursorIfDifferent(AttachmentHighlightManager.this.textArea, textAreaDefaultCursor, listenerId);
                    }
                }
            }
        });
    }

    private static boolean isNonSelectionAttachment(String attachmentPath) {
        return attachmentPath != null && !attachmentPath.startsWith("selection://");
    }

    public boolean isWithinTextBounds(Point point) {
        try {
            int docLength = this.textArea.getDocument().getLength();
            Rectangle2D lastCharBounds = this.textArea.modelToView2D(docLength);
            boolean isWithinY = point.getY() <= lastCharBounds.getMaxY();
            boolean isWithinX = point.getX() <= lastCharBounds.getMaxX();
            return isWithinY && isWithinX;
        }
        catch (BadLocationException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)ex, (Throwable)ex);
            }
            return false;
        }
    }

    private void installHighlightProtectionFilter() {
        if (this.textArea.getDocument() instanceof AbstractDocument) {
            ((AbstractDocument)this.textArea.getDocument()).setDocumentFilter(new DocumentFilter(){

                @Override
                public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                    boolean removesEntireContent;
                    boolean bl = removesEntireContent = offset == 0 && length == AttachmentHighlightManager.this.textArea.getDocument().getLength();
                    if (removesEntireContent) {
                        super.remove(fb, offset, length);
                    } else {
                        List<AttachmentReference> findAttachmentReferenceInRange = AttachmentHighlightManager.this.findAttachmentReferenceInRange(offset, offset + length);
                        if (findAttachmentReferenceInRange.isEmpty()) {
                            super.remove(fb, offset, length);
                        } else {
                            for (AttachmentReference attachmentReference : findAttachmentReferenceInRange) {
                                boolean isCompleteHighlight;
                                int start = attachmentReference.start.getOffset();
                                int end = attachmentReference.end.getOffset();
                                boolean bl2 = isCompleteHighlight = offset <= start && offset + length >= end;
                                if (isCompleteHighlight) {
                                    super.remove(fb, offset, length);
                                    continue;
                                }
                                super.remove(fb, start, end - start);
                            }
                        }
                    }
                }

                @Override
                public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                    AttachmentReference attachmentReference = AttachmentHighlightManager.this.findAttachmentReference(offset);
                    if (attachmentReference == null) {
                        super.insertString(fb, offset, string, attr);
                    } else {
                        int start = attachmentReference.start.getOffset();
                        int end = attachmentReference.end.getOffset();
                        if (offset == start || offset == end) {
                            this.handleEditingNearHighlightBounds(fb, offset, 0, string, attr, attachmentReference);
                        }
                    }
                }

                @Override
                public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                    List<AttachmentReference> findAllAttachmentReferencesAtPosition = AttachmentHighlightManager.this.findAllAttachmentReferencesAtPosition(offset);
                    if (!findAllAttachmentReferencesAtPosition.isEmpty()) {
                        for (AttachmentReference attach : findAllAttachmentReferencesAtPosition) {
                            this.handleEditingNearHighlightBounds(fb, offset, length, text, attrs, attach);
                        }
                    } else {
                        boolean isRemoval;
                        boolean bl = isRemoval = length > 0;
                        if (isRemoval) {
                            AttachmentHighlightManager.this.textArea.getDocument().remove(offset, length);
                            AttachmentReference attach = AttachmentHighlightManager.this.findAttachmentReference(offset);
                            if (attach != null) {
                                this.handleEditingNearHighlightBounds(fb, offset, 0, text, attrs, attach);
                            } else {
                                AttachmentHighlightManager.this.textArea.replaceSelection(text);
                            }
                        } else {
                            super.replace(fb, offset, length, text, attrs);
                        }
                    }
                }

                private void handleEditingNearHighlightBounds(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs, AttachmentReference attach) throws BadLocationException {
                    if (attach.start.getOffset() == offset) {
                        this.handleReplaceAtStart(fb, offset, length, text, attrs, attach, text.length());
                    } else if (attach.end.getOffset() == offset) {
                        this.handleReplaceAtEnd(fb, offset, length, text, attrs, attach);
                    }
                }

                private void handleReplaceAtStart(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs, AttachmentReference attach, int insertedTextLen) throws BadLocationException {
                    String path = attach.fullPath;
                    if (AttachmentHighlightManager.this.removeAttachmentReference(attach)) {
                        int originalRefLength = attach.end.getOffset() - attach.start.getOffset();
                        super.replace(fb, offset, length, text, attrs);
                        int newStart = offset + insertedTextLen;
                        int newEnd = newStart + originalRefLength;
                        this.createAndStoreReference(newStart, newEnd, path);
                    }
                }

                private void handleReplaceAtEnd(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs, AttachmentReference attach) throws BadLocationException {
                    int refStart = attach.start.getOffset();
                    int refEnd = attach.end.getOffset();
                    String path = attach.fullPath;
                    AttachmentHighlightManager.this.removeAttachmentReference(attach);
                    super.replace(fb, offset, length, text, attrs);
                    this.createAndStoreReference(refStart, refEnd, path);
                }

                private void createAndStoreReference(int startOffset, int endOffset, String path) {
                    block2: {
                        try {
                            Position start = AttachmentHighlightManager.this.textArea.getDocument().createPosition(startOffset);
                            Position end = AttachmentHighlightManager.this.textArea.getDocument().createPosition(endOffset);
                            String refText = AttachmentHighlightManager.this.textArea.getDocument().getText(start.getOffset(), end.getOffset() - start.getOffset());
                            AttachmentHighlightManager.this.textArea.getHighlighter().addHighlight(start.getOffset(), end.getOffset(), ATTACHMENT_PAINTER);
                            AttachmentReference attachmentRef = new AttachmentReference(start, end, path);
                            List references = AttachmentHighlightManager.this.attachmentPositions.computeIfAbsent(refText, k -> new ArrayList());
                            references.add(attachmentRef);
                        }
                        catch (BadLocationException e) {
                            if (!log.isDebugEnabled()) break block2;
                            log.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    private AttachmentReference findAttachmentReference(int offset) {
        for (List<AttachmentReference> references : this.attachmentPositions.values()) {
            for (AttachmentReference ref : references) {
                int start = ref.start.getOffset();
                int end = ref.end.getOffset();
                if (offset < start || offset > end) continue;
                return ref;
            }
        }
        return null;
    }

    private boolean removeAttachmentReference(AttachmentReference reference) {
        for (Map.Entry<String, List<AttachmentReference>> entry : this.attachmentPositions.entrySet()) {
            List<AttachmentReference> references = entry.getValue();
            Iterator<AttachmentReference> iterator = references.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != reference) continue;
                iterator.remove();
                if (references.isEmpty()) {
                    this.attachmentPositions.remove(entry.getKey());
                }
                return true;
            }
        }
        return false;
    }

    public void updateHighlights() {
        Highlighter highlighter = this.textArea.getHighlighter();
        highlighter.removeAllHighlights();
        this.attachmentPositions.forEach((ref, references) -> references.forEach(reference -> {
            try {
                int start = reference.start.getOffset();
                int end = reference.end.getOffset();
                String textAtPos = this.textArea.getText(start, end - start);
                if (ref.equals(textAtPos)) {
                    highlighter.addHighlight(start, end, ATTACHMENT_PAINTER);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }));
        this.cleanupInvalidPositions();
    }

    private void cleanupInvalidPositions() {
        this.attachmentPositions.entrySet().removeIf(entry -> {
            ((List)entry.getValue()).removeIf(ref -> {
                try {
                    int start = ref.start.getOffset();
                    int end = ref.end.getOffset();
                    String textAtPos = this.textArea.getText(start, end - start);
                    return !((String)entry.getKey()).equals(textAtPos);
                }
                catch (BadLocationException e) {
                    return true;
                }
            });
            return ((List)entry.getValue()).isEmpty();
        });
    }

    public void buildAttachmentHighlightsOverPlainText(Collection<URL> attachments) {
        this.attachmentPositions.clear();
        if (!attachments.isEmpty() && this.textArea.getText() != null && !this.textArea.getText().isEmpty()) {
            for (URL attachmentURL : attachments) {
                try {
                    String ref = "@" + AttachmentChipUtil.extractFileName(attachmentURL, attachments);
                    String regex = Pattern.quote(ref);
                    Pattern pattern = Pattern.compile(regex);
                    Matcher matcher = pattern.matcher(this.textArea.getText());
                    while (matcher.find()) {
                        Position start = this.textArea.getDocument().createPosition(matcher.start());
                        Position end = this.textArea.getDocument().createPosition(matcher.end());
                        List references = this.attachmentPositions.computeIfAbsent(ref, k -> new ArrayList());
                        references.add(new AttachmentReference(start, end, attachmentURL.toExternalForm()));
                    }
                }
                catch (BadLocationException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        this.updateHighlights();
    }

    public void buildAttachmentSelectionHighlightsOverPlainText(Collection<URL> attachments) {
        this.attachmentPositions.remove("@selection");
        for (URL attachmentURL : attachments) {
            try {
                if (!SelectionAttachmentUtil.isSelectionURL((URL)attachmentURL)) continue;
                Matcher matcher = SELECTION_ATTACHMENT_REF_PATTERN.matcher(this.textArea.getText());
                while (matcher.find()) {
                    Position start = this.textArea.getDocument().createPosition(matcher.start());
                    Position end = this.textArea.getDocument().createPosition(matcher.end());
                    List references = this.attachmentPositions.computeIfAbsent("@selection", k -> new ArrayList());
                    AttachmentReference attachRef = new AttachmentReference(start, end, attachmentURL.toExternalForm());
                    references.add(attachRef);
                }
            }
            catch (BadLocationException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        this.updateHighlights();
    }

    public void removeAttachmentReferenceByResource(URL referedResource) {
        ArrayList<AttachmentReference> removedAttachments = new ArrayList<AttachmentReference>();
        String referedResourcePath = referedResource.toExternalForm();
        for (Map.Entry<String, List<AttachmentReference>> entry2 : this.attachmentPositions.entrySet()) {
            List<AttachmentReference> list = entry2.getValue();
            Iterator<AttachmentReference> iterator = list.iterator();
            while (iterator.hasNext()) {
                AttachmentReference attachmentReference = iterator.next();
                boolean isSelectionRef = SelectionAttachmentUtil.isSelectionURL((String)attachmentReference.fullPath);
                boolean isNormalAttachmentReference = attachmentReference.fullPath.equals(referedResourcePath);
                if (!isSelectionRef && !isNormalAttachmentReference) continue;
                removedAttachments.add(attachmentReference);
                iterator.remove();
            }
        }
        this.attachmentPositions.entrySet().removeIf(entry -> ((List)entry.getValue()).isEmpty());
        if (!removedAttachments.isEmpty()) {
            removedAttachments.sort((ref1, ref2) -> Integer.compare(ref2.start.getOffset(), ref1.start.getOffset()));
            for (AttachmentReference rf : removedAttachments) {
                this.textArea.select(rf.start.getOffset(), rf.end.getOffset());
                this.textArea.replaceSelection("");
            }
        }
        this.updateHighlights();
    }

    public void insertAtCaret(String fileName, String filePath, int caretPos) throws BadLocationException {
        String ref = "@" + fileName;
        this.textArea.getDocument().insertString(caretPos, ref, null);
        Position start = this.textArea.getDocument().createPosition(caretPos);
        Position end = this.textArea.getDocument().createPosition(caretPos + ref.length());
        this.textArea.getHighlighter().addHighlight(start.getOffset(), end.getOffset(), ATTACHMENT_PAINTER);
        AttachmentReference attachmentRef = new AttachmentReference(start, end, filePath);
        List references = this.attachmentPositions.computeIfAbsent(ref, k -> new ArrayList());
        references.add(attachmentRef);
    }

    public void handleArrowNavigation(KeyEvent e) {
        int caretPos = this.textArea.getCaretPosition();
        AttachmentReference target = null;
        if (e.getKeyCode() == 37 || e.getKeyCode() == 39) {
            for (List<AttachmentReference> references : this.attachmentPositions.values()) {
                for (AttachmentReference ref : references) {
                    int start = ref.start.getOffset();
                    int end = ref.end.getOffset();
                    if (start > caretPos || caretPos > end) continue;
                    target = ref;
                }
            }
        }
        if (target != null) {
            int start = target.start.getOffset();
            int end = target.end.getOffset();
            if (e.getKeyCode() == 39) {
                boolean atStartOrInsideOfAttachRef;
                boolean bl = atStartOrInsideOfAttachRef = caretPos >= start;
                if (atStartOrInsideOfAttachRef && caretPos != end) {
                    this.textArea.setCaretPosition(end);
                    e.consume();
                }
            } else if (e.getKeyCode() == 37) {
                boolean atEndOrInsideOfAttachRef;
                boolean bl = atEndOrInsideOfAttachRef = caretPos <= end;
                if (atEndOrInsideOfAttachRef && caretPos != start) {
                    this.textArea.setCaretPosition(start);
                    e.consume();
                }
            }
        }
    }

    public String getAttachmentPathAtPosition(int pos) {
        return Optional.ofNullable(this.findAttachmentReference(pos)).map(t -> t.fullPath).orElse(null);
    }

    private List<AttachmentReference> findAttachmentReferenceInRange(int startOffset, int endOffset) {
        ArrayList<AttachmentReference> referencesInRange = new ArrayList<AttachmentReference>();
        for (List<AttachmentReference> references : this.attachmentPositions.values()) {
            for (AttachmentReference ref : references) {
                int refStart = ref.start.getOffset();
                int refEnd = ref.end.getOffset();
                boolean hasOverlap = Math.max(startOffset, refStart) < Math.min(endOffset, refEnd);
                if (!hasOverlap) continue;
                referencesInRange.add(ref);
            }
        }
        return referencesInRange;
    }

    public String getFistAttachmentPathAtRange(int start, int end) {
        List<AttachmentReference> findAttachmentReferenceInRange = this.findAttachmentReferenceInRange(start, end);
        if (!findAttachmentReferenceInRange.isEmpty()) {
            return findAttachmentReferenceInRange.get((int)0).fullPath;
        }
        return null;
    }

    private List<AttachmentReference> findAllAttachmentReferencesAtPosition(int pos) {
        ArrayList<AttachmentReference> refsAtPosition = new ArrayList<AttachmentReference>();
        for (List<AttachmentReference> references : this.attachmentPositions.values()) {
            for (AttachmentReference ref : references) {
                int start = ref.start.getOffset();
                int end = ref.end.getOffset();
                if (pos != start && pos != end && (pos <= start || pos >= end)) continue;
                refsAtPosition.add(ref);
            }
        }
        refsAtPosition.sort((ref1, ref2) -> Integer.compare(ref1.start.getOffset(), ref2.start.getOffset()));
        return refsAtPosition;
    }

    public List<Highlighter.Highlight> getChipHighlights() {
        Highlighter.Highlight[] highlights;
        ArrayList<Highlighter.Highlight> arrayList = new ArrayList<Highlighter.Highlight>();
        for (Highlighter.Highlight highlight : highlights = this.textArea.getHighlighter().getHighlights()) {
            if (highlight.getPainter() != ATTACHMENT_PAINTER) continue;
            arrayList.add(highlight);
        }
        return arrayList;
    }
}

