/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.attachments;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.attach.MessageAttachmentUtils;
import com.oxygenxml.positron.core.util.attach.SelectionAttachmentUtil;
import com.oxygenxml.positron.plugin.UndoRedoSupportInstaller;
import com.oxygenxml.positron.plugin.chat.DropPasteAttachmentsTransferHandler;
import com.oxygenxml.positron.plugin.chat.UserInputTextHandler;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentChipUtil;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentHighlightManager;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentsChangedListener;
import com.oxygenxml.positron.plugin.chat.attachments.ChatChipAttachmentManager;
import com.oxygenxml.positron.plugin.chat.quickfind.QuickSearchItemDialog;
import com.oxygenxml.positron.plugin.chat.quickfind.QuickSearchItemFactory;
import com.oxygenxml.positron.plugin.chat.quickfind.URLQuickSearchItem;
import com.oxygenxml.positron.plugin.chat.utils.ScreenLocationUtil;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.undo.UndoableEdit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.PopupMenu;

public class AttachmentAwareTextHandler
implements UserInputTextHandler {
    private static final Logger log = LoggerFactory.getLogger(AttachmentAwareTextHandler.class);
    private static final String REDO_ACTION_KEY = "Redo";
    private static final String UNDO_ACTION_KEY = "Undo";
    private static final Translator TRANSLATOR = Translator.getInstance();
    private AttachmentHighlightManager highlightManager;
    private String userInputHint;
    private ChatChipAttachmentManager chatAttachmentManager;
    private QuickSearchItemDialog<URLQuickSearchItem> dialog;
    private final JTextArea textArea;

    public AttachmentAwareTextHandler(final JTextArea textArea, String userInputHint, final Runnable onCtrlSpace, final ChatChipAttachmentManager chatAttachmentManager) {
        this.textArea = textArea;
        this.userInputHint = userInputHint;
        this.chatAttachmentManager = chatAttachmentManager;
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.highlightManager = new AttachmentHighlightManager(textArea);
        chatAttachmentManager.addAttachmentsChangedListener(new AttachmentsChangedListener(){

            @Override
            public void attachmentAdded(URL attachment) {
            }

            @Override
            public void attachmentRemoved(URL attachment) {
                AttachmentAwareTextHandler.this.highlightManager.removeAttachmentReferenceByResource(attachment);
            }
        });
        UndoableEdit undoManager = UndoRedoSupportInstaller.install(textArea);
        final AbstractAction originalUndoAction = (AbstractAction)textArea.getActionMap().get(UNDO_ACTION_KEY);
        final AbstractAction originalRedoAction = (AbstractAction)textArea.getActionMap().get(REDO_ACTION_KEY);
        textArea.getActionMap().put(UNDO_ACTION_KEY, new AbstractAction(UNDO_ACTION_KEY){

            @Override
            public void actionPerformed(ActionEvent e) {
                originalUndoAction.actionPerformed(e);
                SwingUtilities.invokeLater(() -> AttachmentAwareTextHandler.this.buildAttachmentHighlightsOverPlainText());
            }
        });
        textArea.getActionMap().put(REDO_ACTION_KEY, new AbstractAction(REDO_ACTION_KEY){

            @Override
            public void actionPerformed(ActionEvent e) {
                originalRedoAction.actionPerformed(e);
                SwingUtilities.invokeLater(() -> AttachmentAwareTextHandler.this.buildAttachmentHighlightsOverPlainText());
            }
        });
        textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                boolean isCtrlPressed;
                boolean bl = isCtrlPressed = (e.getModifiersEx() & 0x80) != 0;
                if (onCtrlSpace != null) {
                    boolean isCtrlPlusSpace;
                    boolean bl2 = isCtrlPlusSpace = e.getKeyCode() == 32 && isCtrlPressed;
                    if (isCtrlPlusSpace) {
                        onCtrlSpace.run();
                    }
                }
                if (e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                    AttachmentAwareTextHandler.this.highlightManager.handleArrowNavigation(e);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '@') {
                    AttachmentAwareTextHandler.this.showAttachmentCompletion();
                }
            }
        });
        textArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                textArea.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                textArea.repaint();
            }
        });
        textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AttachmentAwareTextHandler.this.highlightManager.updateHighlights();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AttachmentAwareTextHandler.this.highlightManager.updateHighlights();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        textArea.addPropertyChangeListener("editable", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                chatAttachmentManager.setAttachmentComponentsVisible((Boolean)evt.getNewValue());
            }
        });
        chatAttachmentManager.setAttachmentComponentsVisible(textArea.isEditable());
        ToolTipManager.sharedInstance().registerComponent(textArea);
        textArea.setTransferHandler(new DropPasteAttachmentsTransferHandler(this));
        this.installContextualMenu(textArea, undoManager);
    }

    private void installContextualMenu(final JTextArea textArea, final UndoableEdit undoManager) {
        textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseReleased(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    boolean hasSelection;
                    PopupMenu contextualMenu = OxygenUIComponentsFactory.createPopupMenu();
                    AbstractAction action = null;
                    boolean editable = textArea.isEditable();
                    boolean bl = hasSelection = textArea.getSelectionStart() != textArea.getSelectionEnd();
                    if (editable) {
                        action = new AbstractAction(TRANSLATOR.getTranslation("Cut"), IconsLoader.loadIcon("/images/Cut16.png")){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                textArea.cut();
                            }
                        };
                        contextualMenu.add(action);
                        action.setEnabled(hasSelection);
                    }
                    action = new AbstractAction(TRANSLATOR.getTranslation("Edit_Copy"), IconsLoader.loadIcon("/images/Copy16.png")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            textArea.copy();
                        }
                    };
                    contextualMenu.add(action);
                    action.setEnabled(hasSelection);
                    if (editable) {
                        action = new AbstractAction(TRANSLATOR.getTranslation("Paste"), IconsLoader.loadIcon("/images/Paste16.png")){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                textArea.paste();
                            }
                        };
                        contextualMenu.add(action);
                    }
                    contextualMenu.addSeparator();
                    action = new AbstractAction(TRANSLATOR.getTranslation("Select_all")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            textArea.selectAll();
                        }
                    };
                    contextualMenu.add(action);
                    action.setEnabled(textArea.getDocument().getLength() > 0);
                    if (editable) {
                        contextualMenu.addSeparator();
                        action = new AbstractAction(TRANSLATOR.getTranslation(AttachmentAwareTextHandler.UNDO_ACTION_KEY), IconsLoader.loadIcon("/images/Undo16.png")){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                undoManager.undo();
                                SwingUtilities.invokeLater(() -> AttachmentAwareTextHandler.this.buildAttachmentHighlightsOverPlainText());
                            }
                        };
                        contextualMenu.add(action);
                        action.setEnabled(undoManager.canUndo());
                        action = new AbstractAction(TRANSLATOR.getTranslation(AttachmentAwareTextHandler.REDO_ACTION_KEY), IconsLoader.loadIcon("/images/Redo16.png")){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                undoManager.redo();
                                SwingUtilities.invokeLater(() -> AttachmentAwareTextHandler.this.buildAttachmentHighlightsOverPlainText());
                            }
                        };
                        contextualMenu.add(action);
                        action.setEnabled(undoManager.canRedo());
                    }
                    contextualMenu.show(textArea, e.getX(), e.getY());
                }
            }
        });
    }

    public void paintPlaceholder(Graphics g) {
        if (this.userInputHint != null && this.textArea.isEnabled() && !this.textArea.hasFocus() && this.textArea.getText().isEmpty()) {
            UIUtil.drawMultiLinePlaceholder(this.textArea, g, this.userInputHint);
        }
    }

    public String getToolTipText(MouseEvent e) {
        String attachmentPathAtPosition = this.highlightManager.getAttachmentPathAtPosition(this.textArea.viewToModel2D(e.getPoint()));
        return SelectionAttachmentUtil.isSelectionURL((String)attachmentPathAtPosition) ? this.chatAttachmentManager.getSelectionChipContent() : URLUtil.getDescription((String)attachmentPathAtPosition);
    }

    public void setPlaceholder(String hint) {
        this.userInputHint = hint;
        this.textArea.repaint();
    }

    public AttachmentHighlightManager getHighlightManager() {
        return this.highlightManager;
    }

    private void showAttachmentCompletion() {
        Collection<URL> attachments = this.chatAttachmentManager.getAttachments();
        this.addEditorsToChipsCCItems(attachments);
        if (!attachments.isEmpty()) {
            block3: {
                List items = attachments.stream().map(url -> QuickSearchItemFactory.getQuickSearchItem(url, this.chatAttachmentManager.getSelectionChipContent(), attachments)).collect(Collectors.toList());
                this.dialog = new QuickSearchItemDialog<URLQuickSearchItem>(() -> this.textArea, items, TRANSLATOR.getTranslation("Search_attachments"), TRANSLATOR.getTranslation("Search_attachments") + "...", selectedItem -> this.onItemSelected((URLQuickSearchItem)selectedItem), true);
                try {
                    Rectangle2D caretCoords = this.textArea.modelToView2D(this.textArea.getCaretPosition());
                    int x = (int)caretCoords.getX();
                    int y = (int)(caretCoords.getY() + caretCoords.getHeight());
                    Point screenPoint = new Point(x, y);
                    SwingUtilities.convertPointToScreen(screenPoint, this.textArea);
                    screenPoint = ScreenLocationUtil.adjustPopupLocationToFitScreen(screenPoint.x, screenPoint.y, this.textArea);
                    this.dialog.setLocation(screenPoint.x, screenPoint.y);
                }
                catch (BadLocationException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)e, (Throwable)e);
                }
            }
            this.dialog.setVisible(true);
        }
    }

    private void addEditorsToChipsCCItems(Collection<URL> attachments) {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        URL[] allEditorLocations = pluginWorkspace.getAllEditorLocations(0);
        if (allEditorLocations != null && allEditorLocations.length > 0) {
            Arrays.stream(allEditorLocations).forEach(e -> attachments.add((URL)e));
        }
    }

    private void onItemSelected(URLQuickSearchItem selectedItem) {
        block2: {
            int caretPos = this.textArea.getCaretPosition();
            try {
                this.insertAtCaret(selectedItem, caretPos);
                this.chatAttachmentManager.addAttachment(selectedItem.getURL());
            }
            catch (BadLocationException ex) {
                if (!log.isDebugEnabled()) break block2;
                log.debug(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void insertAtCaret(URLQuickSearchItem selectedItem, int caretPos) throws BadLocationException {
        if (caretPos > 0 && this.textArea.getText(caretPos - 1, 1).equals("@")) {
            this.removeText(caretPos - 1, caretPos);
            --caretPos;
        }
        this.highlightManager.insertAtCaret(AttachmentChipUtil.extractFileName(selectedItem.getURL(), this.chatAttachmentManager.getAttachments()), URLUtil.clearUserInfo((URL)selectedItem.getURL()).toExternalForm(), caretPos);
    }

    private void buildAttachmentHighlightsOverPlainText() {
        this.highlightManager.buildAttachmentHighlightsOverPlainText(this.chatAttachmentManager.getAttachments());
    }

    @Override
    public String getText() {
        return this.textArea.getText();
    }

    @Override
    public String getPlainTextContentWithAttachmentsExpanded() {
        String textToSend = "";
        Collection<URL> attachmentsFilesList = this.chatAttachmentManager.getAttachments();
        if (!attachmentsFilesList.isEmpty()) {
            StringBuilder result = new StringBuilder(this.getText());
            ArrayList<String> usedAttachmentPaths = new ArrayList<String>();
            List<Highlighter.Highlight> highlights = this.highlightManager.getChipHighlights();
            if (highlights != null && !highlights.isEmpty()) {
                this.replaceAttachmentHighlightWithFullPath(highlights, usedAttachmentPaths, result);
            }
            textToSend = result.toString().trim();
        } else {
            textToSend = this.getText().trim();
        }
        return textToSend;
    }

    @Override
    public String getUnreferencedAttachmentsWithMarkerToAddToModel() {
        ArrayList<String> usedAttachmentPaths = new ArrayList<String>();
        for (Highlighter.Highlight highlight : this.highlightManager.getChipHighlights()) {
            URL url;
            int endOffset;
            int startOffset = highlight.getStartOffset();
            String attachmentPathAtPosition = this.highlightManager.getFistAttachmentPathAtRange(startOffset, endOffset = highlight.getEndOffset());
            if (attachmentPathAtPosition == null) continue;
            try {
                url = new URL(attachmentPathAtPosition);
            }
            catch (MalformedURLException e) {
                url = URLUtil.convertToURL((String)attachmentPathAtPosition);
            }
            if (this.isSelectionURLWithoutContentQueryParam(url)) {
                attachmentPathAtPosition = SelectionAttachmentUtil.setContentQueryParam((String)this.chatAttachmentManager.getSelectionChipContent()).toExternalForm();
            }
            usedAttachmentPaths.add(attachmentPathAtPosition);
        }
        StringBuilder result = new StringBuilder();
        List<String> unreferencedAttachments = this.getUnreferencedAttachments(this.chatAttachmentManager.getAttachments(), usedAttachmentPaths);
        if (!unreferencedAttachments.isEmpty()) {
            result.append("#################attachments#################");
            for (String string : unreferencedAttachments) {
                result.append(string);
            }
        }
        return result.toString();
    }

    @Override
    public void setText(String text) {
        if (text != null && !text.trim().isEmpty()) {
            List<AttachmentMatchInfo> matches = AttachmentAwareTextHandler.findAttachmentMatches(text);
            for (AttachmentMatchInfo attachmentMatchInfo : matches) {
                this.insertURL(URLUtil.convertToURL((String)attachmentMatchInfo.getFilePath()));
            }
            StringBuilder toSet = new StringBuilder(text);
            matches.sort((a, b) -> Integer.compare(b.getStart(), a.getStart()));
            for (AttachmentMatchInfo match : matches) {
                toSet.replace(match.start, match.end, this.buildAttacRef(match));
            }
            int n = toSet.indexOf("#################attachments#################");
            if (n != -1) {
                toSet.replace(n, toSet.length(), "");
            }
            this.setTextInternal(toSet.toString());
        } else {
            this.setTextInternal(text);
        }
        this.buildAttachmentHighlightsOverPlainText();
    }

    private String buildAttacRef(AttachmentMatchInfo match) {
        URLQuickSearchItem selectedItem = QuickSearchItemFactory.getQuickSearchItem(URLUtil.convertToURL((String)match.getFilePath()), null, this.chatAttachmentManager.getAttachments());
        return "@" + AttachmentChipUtil.extractFileName(selectedItem.getURL(), this.chatAttachmentManager.getAttachments());
    }

    private void setTextInternal(String text) {
        this.textArea.select(0, this.textArea.getDocument().getLength());
        this.textArea.replaceSelection(text);
    }

    @Override
    public void insertTextAtCurrentPosition(String text) {
        this.textArea.replaceSelection(text);
        this.buildAttachmentHighlightsOverPlainText();
    }

    @Override
    public void onTextUpdate(final Runnable onTextUpdate) {
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                onTextUpdate.run();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                onTextUpdate.run();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                onTextUpdate.run();
            }
        });
    }

    @Override
    public void submitToAI() {
    }

    @Override
    public void removeText(int start, int end) {
        this.textArea.select(start, end);
        this.textArea.replaceSelection("");
    }

    public void insertAttachmentReference(String filePath, int position) {
        block2: {
            try {
                URLQuickSearchItem selectedItem = QuickSearchItemFactory.getQuickSearchItem(URLUtil.convertToURL((String)filePath), null, this.chatAttachmentManager.getAttachments());
                this.insertAtCaret(selectedItem, position);
            }
            catch (BadLocationException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void clearAll() {
        this.setTextInternal("");
        this.chatAttachmentManager.clearAttachments();
    }

    private List<String> getUnreferencedAttachments(Collection<URL> attachmentsFilesList, List<String> referencedAttachmentPaths) {
        ArrayList<String> unusedAttachments = new ArrayList<String>();
        Iterator<URL> iterator = attachmentsFilesList.iterator();
        while (iterator.hasNext()) {
            String externalForm;
            URL attachment;
            URL toAdd = attachment = iterator.next();
            if (this.isSelectionURLWithoutContentQueryParam(attachment)) {
                toAdd = SelectionAttachmentUtil.setContentQueryParam((String)this.chatAttachmentManager.getSelectionChipContent());
            }
            if (referencedAttachmentPaths.contains(externalForm = URLUtil.clearUserInfo((URL)toAdd).toExternalForm())) continue;
            unusedAttachments.add("${attach(" + toAdd + ")}");
        }
        return unusedAttachments;
    }

    private boolean isSelectionURLWithoutContentQueryParam(URL url) {
        return SelectionAttachmentUtil.isSelectionURL((URL)url) && SelectionAttachmentUtil.getContentQueryParam((URL)url) == null;
    }

    private void replaceAttachmentHighlightWithFullPath(List<Highlighter.Highlight> highlights, List<String> usedAttachmentPaths, StringBuilder stringBuilder) {
        highlights.sort((h1, h2) -> Integer.compare(h2.getStartOffset(), h1.getStartOffset()));
        for (Highlighter.Highlight highlight : highlights) {
            int endOffset;
            int startOffset = highlight.getStartOffset();
            String attachmentPathAtPosition = this.highlightManager.getFistAttachmentPathAtRange(startOffset, endOffset = highlight.getEndOffset());
            if (attachmentPathAtPosition == null) continue;
            if (SelectionAttachmentUtil.isSelectionURL((String)attachmentPathAtPosition)) {
                URL setContentQueryParam = SelectionAttachmentUtil.setContentQueryParam((String)this.chatAttachmentManager.getSelectionChipContent());
                attachmentPathAtPosition = setContentQueryParam.toExternalForm();
            }
            String editorVar = "${attach(" + attachmentPathAtPosition + ")}";
            stringBuilder.replace(startOffset, endOffset, editorVar);
            usedAttachmentPaths.add(attachmentPathAtPosition);
        }
    }

    public QuickSearchItemDialog<URLQuickSearchItem> getDialog() {
        return this.dialog;
    }

    @Override
    public boolean isEditable() {
        return this.textArea.isEditable();
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public int findUnreferencedAttachmentsMarker() {
        return this.getText().indexOf("#################attachments#################");
    }

    private static List<AttachmentMatchInfo> findAttachmentMatches(String textWithAttachEditorVariables) {
        ArrayList<AttachmentMatchInfo> matches = new ArrayList<AttachmentMatchInfo>();
        Matcher matcher = MessageAttachmentUtils.ATTACH_PATTERN.matcher(textWithAttachEditorVariables);
        while (matcher.find()) {
            matches.add(new AttachmentMatchInfo(matcher.start(), matcher.end(), matcher.group(1)));
        }
        return matches;
    }

    @Override
    public void insertURL(URL url) {
        this.chatAttachmentManager.addAttachment(url);
    }

    @Override
    public void updateReferencesWhenSelectionChanges() {
        Collection<URL> attachments = this.chatAttachmentManager.getAttachments();
        this.highlightManager.buildAttachmentSelectionHighlightsOverPlainText(attachments);
    }

    private static class AttachmentMatchInfo {
        private int start;
        private int end;
        private String filePath;

        public String toString() {
            return "AttachmentAwareTextHandler.AttachmentMatchInfo(start=" + this.getStart() + ", end=" + this.getEnd() + ", filePath=" + this.getFilePath() + ")";
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public AttachmentMatchInfo(int start, int end, String filePath) {
            this.start = start;
            this.end = end;
            this.filePath = filePath;
        }
    }
}

