/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.actions;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.chat.ChatMessageNavigationLevel;
import com.oxygenxml.positron.plugin.chat.actions.BranchNavigator;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class ChatMessageNavigationWidget
extends JPanel {
    private Supplier<BranchNavigator> branchNavigator;
    private JLabel messageIndexLabel = new JLabel("0 / 0");
    private boolean currentNextPrevButtonsEnabled;
    private static final Translator TRANSLATOR = Translator.getInstance();
    private JButton nextEditButton = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction(">", IconsLoader.loadIcon("/images/RightArrow16.png")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ChatMessageNavigationWidget.this.branchNavigator.get().right();
        }
    }, (boolean)false);
    private JButton previousEditButton = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction("<", IconsLoader.loadIcon("/images/LeftArrow16.png")){

        @Override
        public void actionPerformed(ActionEvent e) {
            ChatMessageNavigationWidget.this.branchNavigator.get().left();
        }
    }, (boolean)false);

    public ChatMessageNavigationWidget(Supplier<BranchNavigator> branchNavigator) {
        this.branchNavigator = branchNavigator;
        this.setOpaque(false);
        this.setBorder(null);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        this.previousEditButton.setBorder(null);
        this.previousEditButton.setMargin(null);
        this.previousEditButton.setToolTipText(TRANSLATOR.getTranslation("Previous"));
        this.add((Component)this.previousEditButton, gbc);
        ++gbc.gridx;
        this.add((Component)this.messageIndexLabel, gbc);
        ++gbc.gridx;
        this.nextEditButton.setBorder(null);
        this.nextEditButton.setMargin(null);
        this.nextEditButton.setToolTipText(TRANSLATOR.getTranslation("Next"));
        this.add((Component)this.nextEditButton, gbc);
    }

    public void updateUiForLevels(ChatMessageNavigationLevel navigationLevel, boolean enabled) {
        if (this.currentNextPrevButtonsEnabled != enabled) {
            this.currentNextPrevButtonsEnabled = enabled;
            int currentLevel = navigationLevel.getCurrentLevel();
            int maxLevel = navigationLevel.getMaxLevel();
            if (maxLevel == 1) {
                this.setNavigationWidgetVisible(false);
            } else {
                this.setNavigationWidgetVisible(true);
                this.messageIndexLabel.setText(String.format("%d / %d", currentLevel, maxLevel));
                if (enabled) {
                    this.previousEditButton.setEnabled(currentLevel != 1);
                    this.nextEditButton.setEnabled(currentLevel != maxLevel);
                } else {
                    this.previousEditButton.setEnabled(false);
                    this.nextEditButton.setEnabled(false);
                }
            }
        }
    }

    public void setNavigationWidgetVisible(boolean visible) {
        this.previousEditButton.setVisible(visible);
        this.messageIndexLabel.setVisible(visible);
        this.nextEditButton.setVisible(visible);
    }

    public boolean isNavigationWidgetVisible() {
        return this.previousEditButton.isVisible();
    }

    @Override
    public String toString() {
        return String.format("Previous[%s] %s Next[%s]", this.previousEditButton.isEnabled(), this.messageIndexLabel.getText(), this.nextEditButton.isEnabled());
    }
}

