/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.ToolsExecutorBase;
import com.oxygenxml.positron.mcp.MCPFunctionSignature;
import com.oxygenxml.positron.plugin.chat.DisabledToolsUtilities;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.TextField;

public class ToolsSelector {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private ToolsExecutorBase toolsExecutor;
    private JButton toolsSelectionButton;
    private Map<String, JCheckBox> toolCheckboxes = new HashMap<String, JCheckBox>();
    private Map<String, JCheckBox> categoryCheckboxes = new HashMap<String, JCheckBox>();
    private Map<String, List<String>> categoryToolsMap = new HashMap<String, List<String>>();
    private Set<String> disabledTools = new HashSet<String>();
    private String currentChatModeId;
    private Map<String, Set<ChatFunctionSignature>> toolsByCategory = new LinkedHashMap<String, Set<ChatFunctionSignature>>();
    private CompletionActionsManager completionActionsManager;

    public ToolsSelector(PluginWorkspace pluginWorkspaceAccess, ToolsExecutorBase toolsExecutor, CompletionActionsManager completionActionsManager) {
        this.toolsExecutor = toolsExecutor;
        this.completionActionsManager = completionActionsManager;
        this.currentChatModeId = pluginWorkspaceAccess.getOptionsStorage().getOption("oxygen.positron.plugin.chat.mode.action.id", "pseudoaction.chat.message.agent");
        AbstractAction showToolsAction = new AbstractAction(TRANSLATOR.getTranslation("Tools"), IconsLoader.loadIcon("/images/ToolSelection16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolsSelector.this.showToolsSelectionWindow();
            }
        };
        this.toolsSelectionButton = OxygenUIComponentsFactory.createToolbarButton((Action)showToolsAction, (boolean)false);
        this.toolsExecutor.addToolsReloadListener(this::reloadTools);
        completionActionsManager.addReloadActionListener(this::reloadTools);
        this.reloadTools();
    }

    public void setChatMode(String chatModeId) {
        if (chatModeId != null && !chatModeId.equals(this.currentChatModeId)) {
            this.currentChatModeId = chatModeId;
            this.reloadTools();
        }
    }

    private void loadToolsData() {
        this.toolsByCategory.clear();
        this.categoryToolsMap.clear();
        if (this.toolsExecutor == null) {
            this.toolsSelectionButton.setVisible(false);
            return;
        }
        Map executors = this.toolsExecutor.getFunctionExecutors();
        if (executors == null || executors.isEmpty()) {
            this.toolsSelectionButton.setVisible(false);
            return;
        }
        this.groupToolsByCategories(executors.values());
        this.toolsSelectionButton.setVisible(true);
    }

    private void groupToolsByCategories(Collection<FunctionExecutor> executors) {
        Set<String> referencedTools = DisabledToolsUtilities.getCurrentChatModeReferencedTools(this.completionActionsManager);
        HashMap<String, Set<ChatFunctionSignature>> tempToolsByCategory = new HashMap<String, Set<ChatFunctionSignature>>();
        for (FunctionExecutor executor : executors) {
            ChatFunctionSignature chatFunctionSignature = executor.getFunctionSignature();
            if (!chatFunctionSignature.isEnabled() || !(chatFunctionSignature instanceof MCPFunctionSignature) && !referencedTools.contains(chatFunctionSignature.getName())) continue;
            String category = chatFunctionSignature.getCategory();
            if (category == null) {
                category = "Generic";
            }
            Set signatures = tempToolsByCategory.computeIfAbsent(category, k -> new TreeSet<ChatFunctionSignature>(ToolsSelector.createSignaturesComparator()));
            signatures.add(chatFunctionSignature);
        }
        List<String> sortedCategories = ToolsSelector.sortCategories(tempToolsByCategory);
        for (String string : sortedCategories) {
            this.toolsByCategory.put(string, (Set)tempToolsByCategory.get(string));
        }
        for (Map.Entry entry : this.toolsByCategory.entrySet()) {
            String categoryName = (String)entry.getKey();
            Set categoryTools = (Set)entry.getValue();
            ArrayList<String> toolNames = new ArrayList<String>();
            for (ChatFunctionSignature signature : categoryTools) {
                toolNames.add(signature.getName());
            }
            this.categoryToolsMap.put(categoryName, toolNames);
        }
    }

    private static List<String> sortCategories(final Map<String, Set<ChatFunctionSignature>> tempToolsByCategory) {
        ArrayList<String> sortedCategories = new ArrayList<String>(tempToolsByCategory.keySet());
        sortedCategories.sort(new Comparator<String>(){

            @Override
            public int compare(String cat1, String cat2) {
                Set tools1 = (Set)tempToolsByCategory.get(cat1);
                Set tools2 = (Set)tempToolsByCategory.get(cat2);
                boolean cat1HasMCP = this.containsMCPFunction(tools1);
                boolean cat2HasMCP = this.containsMCPFunction(tools2);
                if (cat1HasMCP && !cat2HasMCP) {
                    return -1;
                }
                if (!cat1HasMCP && cat2HasMCP) {
                    return 1;
                }
                return cat1.compareTo(cat2);
            }

            private boolean containsMCPFunction(Set<ChatFunctionSignature> tools) {
                for (ChatFunctionSignature signature : tools) {
                    if (!(signature instanceof MCPFunctionSignature)) continue;
                    return true;
                }
                return false;
            }
        });
        return sortedCategories;
    }

    private static Comparator<ChatFunctionSignature> createSignaturesComparator() {
        return new Comparator<ChatFunctionSignature>(){

            @Override
            public int compare(ChatFunctionSignature o1, ChatFunctionSignature o2) {
                int result;
                String descr2;
                String descr1 = o1.getUIDecriptionForChatMessage();
                if (descr1 == null) {
                    descr1 = o1.getName();
                }
                if ((descr2 = o2.getUIDecriptionForChatMessage()) == null) {
                    descr2 = o2.getName();
                }
                if ((result = descr1.compareTo(descr2)) == 0) {
                    result = o1.getName().compareTo(o2.getName());
                }
                return result;
            }
        };
    }

    private void showToolsSelectionWindow() {
        Window parentWindow = SwingUtilities.getWindowAncestor(this.toolsSelectionButton);
        final JDialog dialog = new JDialog(parentWindow);
        dialog.setUndecorated(true);
        dialog.setModal(false);
        dialog.setLayout(new BorderLayout());
        AbstractAction hideAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        };
        dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), hideAction);
        dialog.getRootPane().getActionMap().put(hideAction, hideAction);
        JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
        mainPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel filterPanel = new JPanel(new BorderLayout(5, 0));
        JLabel filterLabel = new JLabel(Translator.getInstance().getTranslation("Filter") + ":");
        TextField filterField = OxygenUIComponentsFactory.createTextField();
        filterPanel.add((Component)filterLabel, "West");
        filterPanel.add((Component)filterField, "Center");
        mainPanel.add((Component)filterPanel, "North");
        JPanel toolsPanel = new JPanel();
        toolsPanel.setLayout(new BoxLayout(toolsPanel, 1));
        toolsPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.populateToolsPanel(toolsPanel, null);
        JScrollPane scrollPane = OxygenUIComponentsFactory.createScrollPane((Component)toolsPanel, (int)20, (int)30);
        scrollPane.setPreferredSize(new Dimension(350, 300));
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        mainPanel.add((Component)scrollPane, "Center");
        dialog.add(mainPanel);
        filterField.getDocument().addDocumentListener(new DocumentListener(){
            final /* synthetic */ JTextField val$filterField;
            final /* synthetic */ JPanel val$toolsPanel;
            final /* synthetic */ JDialog val$dialog;
            {
                this.val$filterField = jTextField;
                this.val$toolsPanel = jPanel;
                this.val$dialog = jDialog;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateFilter();
            }

            private void updateFilter() {
                String filterText = this.val$filterField.getText();
                ToolsSelector.this.populateToolsPanel(this.val$toolsPanel, filterText.isEmpty() ? null : filterText);
                this.val$toolsPanel.revalidate();
                this.val$toolsPanel.repaint();
                this.val$dialog.pack();
            }
        });
        dialog.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        dialog.pack();
        this.computeLocationOnScreen(dialog);
        dialog.setVisible(true);
        filterField.requestFocusInWindow();
    }

    private void computeLocationOnScreen(JDialog dialog) {
        Point buttonLocation = this.toolsSelectionButton.getLocationOnScreen();
        int dialogX = buttonLocation.x;
        int dialogY = buttonLocation.y + this.toolsSelectionButton.getHeight();
        GraphicsConfiguration gc = this.toolsSelectionButton.getGraphicsConfiguration();
        if (gc == null) {
            gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle screenBounds = gc.getBounds();
        Dimension dialogSize = dialog.getSize();
        if (dialogX + dialogSize.width > screenBounds.x + screenBounds.width) {
            dialogX = screenBounds.x + screenBounds.width - dialogSize.width;
        }
        if (dialogX < screenBounds.x) {
            dialogX = screenBounds.x;
        }
        if (dialogY + dialogSize.height > screenBounds.y + screenBounds.height && (dialogY = buttonLocation.y - dialogSize.height) < screenBounds.y) {
            dialogY = screenBounds.y + screenBounds.height - dialogSize.height;
        }
        if (dialogY < screenBounds.y) {
            dialogY = screenBounds.y;
        }
        dialog.setLocation(dialogX, dialogY);
    }

    private void populateToolsPanel(JPanel toolsPanel, String filterText) {
        toolsPanel.removeAll();
        this.toolCheckboxes.clear();
        this.categoryCheckboxes.clear();
        for (Map.Entry<String, Set<ChatFunctionSignature>> categoryEntry : this.toolsByCategory.entrySet()) {
            String categoryName = categoryEntry.getKey();
            Set<ChatFunctionSignature> categoryTools = categoryEntry.getValue();
            ArrayList<ChatFunctionSignature> filteredTools = new ArrayList<ChatFunctionSignature>();
            if (filterText != null) {
                for (ChatFunctionSignature signature : categoryTools) {
                    if (!ToolsSelector.containsFilterText(filterText, signature)) continue;
                    filteredTools.add(signature);
                }
                if (filteredTools.isEmpty()) {
                    continue;
                }
            } else {
                filteredTools.addAll(categoryTools);
            }
            JPanel categoryPanel = new JPanel();
            categoryPanel.setLayout(new BoxLayout(categoryPanel, 1));
            categoryPanel.setAlignmentX(0.0f);
            categoryPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
            final JCheckBox categoryCheckbox = new JCheckBox(categoryName);
            categoryCheckbox.setFont(categoryCheckbox.getFont().deriveFont(1));
            categoryCheckbox.setAlignmentX(0.0f);
            final List<String> toolNames = this.categoryToolsMap.get(categoryName);
            categoryCheckbox.setSelected(this.areAnyToolsEnabled(toolNames));
            this.categoryCheckboxes.put(categoryName, categoryCheckbox);
            categoryCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolsSelector.this.categoryCheckboxChanged(categoryCheckbox, toolNames);
                }
            });
            categoryPanel.add(categoryCheckbox);
            this.addToolsAsCheckboxesToCategory(categoryName, filteredTools, categoryPanel);
            Dimension prefSize = categoryPanel.getPreferredSize();
            categoryPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, prefSize.height));
            toolsPanel.add(categoryPanel);
        }
        toolsPanel.add(Box.createVerticalGlue());
    }

    private boolean areAnyToolsEnabled(List<String> toolNames) {
        boolean anyEnabled = false;
        for (String toolName : toolNames) {
            if (this.disabledTools.contains(toolName)) continue;
            anyEnabled = true;
            break;
        }
        return anyEnabled;
    }

    private void addToolsAsCheckboxesToCategory(final String categoryName, List<ChatFunctionSignature> filteredTools, JPanel categoryPanel) {
        for (ChatFunctionSignature signature : filteredTools) {
            final String toolName = signature.getName();
            boolean isEnabled = !this.disabledTools.contains(toolName);
            JPanel toolPanel = new JPanel(new FlowLayout(0, 0, 0));
            toolPanel.setAlignmentX(0.0f);
            toolPanel.add(Box.createHorizontalStrut(20));
            String uiDescription = signature.getUIDecriptionForChatMessage();
            if (signature instanceof MCPFunctionSignature) {
                uiDescription = ((MCPFunctionSignature)signature).getShortUIDescription();
            }
            final JCheckBox toolCheckbox = new JCheckBox(uiDescription){

                @Override
                public JToolTip createToolTip() {
                    return OxygenUIComponentsFactory.installMultilineTooltip((JComponent)this);
                }
            };
            toolCheckbox.setSelected(isEnabled);
            toolCheckbox.setToolTipText(signature.getDescription() + "\n\n" + signature.getName());
            toolCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolsSelector.this.toolCheckboxChanged(categoryName, toolName, toolCheckbox);
                }
            });
            this.toolCheckboxes.put(toolName, toolCheckbox);
            toolPanel.add(toolCheckbox);
            categoryPanel.add(toolPanel);
        }
    }

    static boolean containsFilterText(String filterText, ChatFunctionSignature sgn) {
        filterText = filterText.trim().toLowerCase();
        return sgn.getUIDecriptionForChatMessage() != null && sgn.getUIDecriptionForChatMessage().toLowerCase().contains(filterText) || sgn.getName().toLowerCase().contains(filterText) || sgn.getDescription() != null && sgn.getDescription().toLowerCase().contains(filterText);
    }

    private void updateCategoryCheckboxState(String categoryName) {
        List<String> toolNames;
        JCheckBox categoryCheckbox = this.categoryCheckboxes.get(categoryName);
        if (categoryCheckbox != null && (toolNames = this.categoryToolsMap.get(categoryName)) != null) {
            categoryCheckbox.setSelected(this.areAnyToolsEnabled(toolNames));
        }
    }

    private void reloadTools() {
        SwingUtilities.invokeLater(() -> {
            this.disabledTools = DisabledToolsUtilities.loadDisabledTools();
            this.loadToolsData();
        });
    }

    public boolean isToolEnabled(String toolName) {
        return !this.disabledTools.contains(toolName);
    }

    public AbstractButton getToolsSelectionButton() {
        return this.toolsSelectionButton;
    }

    @VisibleForTesting
    String dumpCheckboxStructure() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Set<ChatFunctionSignature>> categoryEntry : this.toolsByCategory.entrySet()) {
            String categoryName = categoryEntry.getKey();
            Set<ChatFunctionSignature> categoryTools = categoryEntry.getValue();
            sb.append("[Category] ").append(categoryName).append("\n");
            for (ChatFunctionSignature signature : categoryTools) {
                String uiDescription = signature.getUIDecriptionForChatMessage();
                if (signature instanceof MCPFunctionSignature) {
                    uiDescription = ((MCPFunctionSignature)signature).getShortUIDescription();
                }
                sb.append("  [Tool] ").append(uiDescription).append(" (").append(signature.getName()).append(")").append("\n");
            }
        }
        return sb.toString();
    }

    private void categoryCheckboxChanged(JCheckBox categoryCheckbox, List<String> toolNames) {
        boolean selected = categoryCheckbox.isSelected();
        for (String toolName : toolNames) {
            JCheckBox toolCheckbox;
            if (selected) {
                this.disabledTools.remove(toolName);
            } else {
                this.disabledTools.add(toolName);
            }
            if ((toolCheckbox = this.toolCheckboxes.get(toolName)) == null) continue;
            toolCheckbox.setSelected(selected);
        }
        DisabledToolsUtilities.saveDisabledTools(this.disabledTools);
    }

    private void toolCheckboxChanged(String categoryName, String toolName, JCheckBox toolCheckbox) {
        boolean selected = toolCheckbox.isSelected();
        if (selected) {
            this.disabledTools.remove(toolName);
        } else {
            this.disabledTools.add(toolName);
        }
        DisabledToolsUtilities.saveDisabledTools(this.disabledTools);
        this.updateCategoryCheckboxState(categoryName);
    }
}

