/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.engines.IEnginesManager;
import com.oxygenxml.positron.core.filter.SensitiveContentMaskingInfo;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.tools.ToolsSessionManager;
import com.oxygenxml.positron.core.tools.UnsafeFunctionInterceptor;
import com.oxygenxml.positron.core.tools.internal.ToolsDocumentsChangesManager;
import com.oxygenxml.positron.core.util.AIModelsUtil;
import com.oxygenxml.positron.functions.ToolsDocumentsChangesManagerBase;
import com.oxygenxml.positron.plugin.chat.ChatMessageNavigationLevel;
import com.oxygenxml.positron.plugin.chat.ChatScrollUpdater;
import com.oxygenxml.positron.plugin.chat.FunctionCallsAndDetailsPanel;
import com.oxygenxml.positron.plugin.chat.ResponseMessageComponent;
import com.oxygenxml.positron.plugin.chat.actions.BranchNavigator;
import com.oxygenxml.positron.plugin.chat.actions.ChatMessageNavigationWidget;
import com.oxygenxml.positron.plugin.ui.LinkLabel;
import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.utilities.AIModelUtils;
import com.oxygenxml.positron.utilities.ModelIdentifierUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class ResponseMessagePanel
extends JPanel {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private JLabel progressLabel;
    private JButton authorModeButton;
    private final ResponseMessageComponent responseComponent;
    private ChatMessageNavigationWidget chatMessageNavigationWidget;
    private BranchNavigator branchNavigator;
    private JLabel roleLabel;
    private JPanel filesChangesActionsPanel;
    private List<String> toolsIds = new ArrayList<String>();
    private GridBagConstraints gbc;
    private FunctionCallsAndDetailsPanel functionCallsPane = new FunctionCallsAndDetailsPanel();
    private FunctionCallsAndDetailsPanel filteringNotificationPane = new FunctionCallsAndDetailsPanel();
    private boolean invokedActionHasImposedModel;
    private ChatScrollUpdater scrollUpdater;

    public ResponseMessagePanel(Optional<String> optionalModelResponse, boolean isConsecutiveResponse, boolean invokedActionHasImposedModel, ChatScrollUpdater scrollUpdater) {
        this.invokedActionHasImposedModel = invokedActionHasImposedModel;
        this.scrollUpdater = scrollUpdater;
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.chatMessageNavigationWidget = new ChatMessageNavigationWidget(() -> this.branchNavigator);
        String assistentLabelText = this.getAssistantMessage(optionalModelResponse);
        this.roleLabel = new JLabel(assistentLabelText);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(0, 5, 0, 5);
        this.gbc.gridwidth = 2;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 2;
        this.add((Component)this.filteringNotificationPane, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 0.0;
        this.gbc.fill = 0;
        this.gbc.anchor = 17;
        this.add((Component)this.roleLabel, this.gbc);
        this.roleLabel.setOpaque(true);
        this.roleLabel.setBackground(ThemeColorProvider.getInstance().getMeCardBackgroundColor());
        this.roleLabel.setVisible(!isConsecutiveResponse);
        this.authorModeButton = OxygenUIComponentsFactory.createToolbarToggleButton((Action)new AbstractAction(null, IconsLoader.loadIcon("/images/AuthorVisualToggle16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResponseMessagePanel.this.switchVisualModes();
            }
        }, (boolean)false);
        this.authorModeButton.setToolTipText(TRANSLATOR.getTranslation("Render_response_author_mode_tooltip"));
        this.authorModeButton.setVisible(false);
        JPanel navigationAndVisualPanel = new JPanel(new FlowLayout(2, 0, 0));
        navigationAndVisualPanel.setOpaque(false);
        navigationAndVisualPanel.add(this.chatMessageNavigationWidget);
        navigationAndVisualPanel.add(this.authorModeButton);
        this.chatMessageNavigationWidget.setNavigationWidgetVisible(false);
        ++this.gbc.gridx;
        this.gbc.weightx = 1.0;
        this.gbc.insets.left = 2;
        this.gbc.fill = 2;
        this.add((Component)navigationAndVisualPanel, this.gbc);
        this.responseComponent = new ResponseMessageComponent();
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.gridwidth = 2;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.responseComponent, this.gbc);
        ++this.gbc.gridy;
        this.add((Component)this.functionCallsPane, this.gbc);
        JPanel progressPanel = new JPanel(new FlowLayout(2, 0, 0));
        progressPanel.setOpaque(false);
        this.progressLabel = new JLabel();
        this.progressLabel.setIcon(IconsLoader.loadAnimatedIcon("/images/AnimatedDots1-2-3.gif"));
        progressPanel.add(this.progressLabel);
        ++this.gbc.gridy;
        this.gbc.weightx = 1.0;
        this.gbc.insets.left = 2;
        this.gbc.fill = 2;
        this.add((Component)progressPanel, this.gbc);
    }

    private JPanel createChangesFilesActionsPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        final JPanel changedFilesPanel = new JPanel(new GridBagLayout());
        changedFilesPanel.setOpaque(false);
        final ToolsDocumentsChangesManagerBase toolsChangesManager = (ToolsDocumentsChangesManagerBase)ToolsSessionManager.getInstance().getToolsDocumentsChangesManager();
        LinkLabel seeChangesBtn = new LinkLabel(TRANSLATOR.getTranslation("See_changes")){

            @Override
            public void performAction() {
                toolsChangesManager.seeChanges(ResponseMessagePanel.this.toolsIds);
                changedFilesPanel.setVisible(ResponseMessagePanel.this.toolsIds.stream().anyMatch(toolsChangesManager::hasChanges));
            }
        };
        toolsChangesManager.executeOnClearChanges(() -> changedFilesPanel.setVisible(this.toolsIds.stream().anyMatch(toolsChangesManager::hasChanges)));
        constraints.fill = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.anchor = 17;
        JPanel emptyPanel = new JPanel();
        emptyPanel.setOpaque(false);
        changedFilesPanel.add((Component)emptyPanel, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        ++constraints.gridx;
        changedFilesPanel.add((Component)seeChangesBtn, constraints);
        return changedFilesPanel;
    }

    public void addOrUpdateFilesChangesActionsPanel(String toolId) {
        this.toolsIds.add(toolId);
        if (this.filesChangesActionsPanel == null && ToolsSessionManager.getInstance().isToolsDocumentsChangesSupportAvailable()) {
            JPanel panel;
            this.filesChangesActionsPanel = panel = this.createChangesFilesActionsPanel();
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
            this.gbc.insets = new Insets(0, 5, 0, 5);
            this.gbc.gridwidth = 2;
            this.add((Component)panel, this.gbc);
        }
        if (ToolsSessionManager.getInstance().isToolsDocumentsChangesSupportAvailable()) {
            ToolsDocumentsChangesManager changesManager = ToolsSessionManager.getInstance().getToolsDocumentsChangesManager();
            this.filesChangesActionsPanel.setVisible(this.toolsIds.stream().anyMatch(arg_0 -> ((ToolsDocumentsChangesManager)changesManager).hasChanges(arg_0)));
        }
        this.revalidate();
        this.repaint();
        this.scrollUpdater.componentAddedToConversationThread();
    }

    private String getAssistantMessage(Optional<String> optionalModelResponse) {
        boolean isAIModelAvailable;
        Object assistentLabelText = "";
        boolean bl = isAIModelAvailable = optionalModelResponse.isPresent() && !optionalModelResponse.get().isBlank();
        if (isAIModelAvailable) {
            boolean showEngine;
            IEnginesManager enginesManager = EnginesManagerProvider.getInstance().getEnginesManager();
            String model = optionalModelResponse.get();
            String engine = null;
            ModelDescriptor currentEngineDescriptor = enginesManager.getCurrentEngineDescriptor();
            if (currentEngineDescriptor != null) {
                engine = ModelIdentifierUtil.extractModelId((String)currentEngineDescriptor.getId());
            }
            boolean same = model.equals(engine) || engine != null && AIModelUtils.isTheSameEngineType((String)model, (String)engine);
            boolean bl2 = showEngine = this.invokedActionHasImposedModel || !same && enginesManager.isChoosingEngineAllowed();
            if (showEngine) {
                assistentLabelText = (String)assistentLabelText + AIModelsUtil.getUILabelForModelSnapshotID((String)model);
            }
        }
        return assistentLabelText;
    }

    void hideAssistantProgress() {
        this.progressLabel.setVisible(false);
    }

    public void appendChunk(String messageChunk) {
        this.responseComponent.appendChunk(messageChunk);
    }

    public void addFunctionExecutedStartedDetails(String toolId, String functionName, String params) {
        this.functionCallsPane.addFunctionExecutedStartedDetails(toolId, functionName, params);
        this.addOrUpdateFilesChangesActionsPanel(toolId);
        this.scrollUpdater.componentAddedToConversationThread();
    }

    public void addFunctionCallResultDetails(String toolId, String result) {
        this.functionCallsPane.addFunctionCallResultDetails(toolId, result);
        this.addOrUpdateFilesChangesActionsPanel(toolId);
        this.scrollUpdater.componentAddedToConversationThread();
    }

    public void addFunctionCallErrorDetails(String error) {
        this.functionCallsPane.addFunctionCallErrorDetails(error);
        this.scrollUpdater.componentAddedToConversationThread();
    }

    public void clearResponse() {
        this.responseComponent.clearCurrentResponse();
        this.scrollUpdater.componentAddedToConversationThread();
    }

    public void updateModel(String model) {
        String assistantMessage = this.getAssistantMessage(Optional.ofNullable(model));
        this.roleLabel.setText(assistantMessage);
        if (!assistantMessage.isEmpty() && !this.invokedActionHasImposedModel) {
            this.roleLabel.setVisible(true);
        }
        this.repaint();
        this.responseComponent.updateModelLabel();
    }

    public void updatePopupActions(List<AbstractAction> actions) {
        this.responseComponent.updatePopupActions(actions);
    }

    public String getSelectedText() {
        return this.responseComponent.getSelectedText();
    }

    public String getText() {
        return this.responseComponent.getText();
    }

    public void actionFinished() {
        this.responseComponent.finalizeResponse();
        if (this.responseComponent.canRenderAuthorResponse()) {
            this.authorModeButton.setVisible(true);
            if (this.responseComponent.isShowingMessageInAuthorArea()) {
                this.authorModeButton.setSelected(true);
            }
        }
    }

    private void switchVisualModes() {
        PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().setOption("oxygen.positron.plugin.prefer.visual.author.response", this.responseComponent.isPreferAuthorResponse() ? "false" : "true");
        if (this.responseComponent.isPreferAuthorResponse()) {
            this.responseComponent.loadAndPresentAuthorComponent();
        } else {
            this.responseComponent.presentTextComponent();
        }
    }

    public void setCurrentResponse(boolean currentResponse) {
        if (!currentResponse) {
            this.authorModeButton.setVisible(false);
        }
    }

    public void setBranchNavigator(BranchNavigator branchNavigator) {
        this.branchNavigator = branchNavigator;
    }

    public void updateUiForLevels(ChatMessageNavigationLevel computedNavigationLevel) {
        this.chatMessageNavigationWidget.updateUiForLevels(computedNavigationLevel, true);
    }

    public ChatMessageNavigationWidget getChatMessageNavigationWidget() {
        return this.chatMessageNavigationWidget;
    }

    protected String getFunctionCallsDetails() {
        return this.functionCallsPane.getFunctionCallsDetails();
    }

    public void updatePopupActionsEnabledState(boolean enabled) {
        this.responseComponent.updatePopupActionsEnabledState(enabled);
    }

    public void appendFunction(String description) {
        this.functionCallsPane.appendFunction(description);
        this.scrollUpdater.componentAddedToConversationThread();
    }

    public boolean hasMeaningfulContent() {
        return !this.getText().isBlank() || this.functionCallsPane.hasMeaningfulContent();
    }

    public String getFunctionCallContentForTests() {
        return this.functionCallsPane.getFunctionCallContentForTests();
    }

    public void addFunctionCallsDetails(List<String> functionCalls) {
        this.functionCallsPane.addFunctionCallsDetails(functionCalls);
        this.scrollUpdater.componentAddedToConversationThread();
    }

    public void checkExecutionAllowed(String toolId, String name, String description, String arguments, UnsafeFunctionInterceptor interceptor) {
        this.functionCallsPane.checkExecutionAllowed(toolId, name, description, arguments, interceptor);
    }

    public void showSensitiveContentMasking(SensitiveContentMaskingInfo maskingInfo) {
        this.filteringNotificationPane.showSensitiveContentMasking(maskingInfo);
        this.scrollUpdater.componentAddedToConversationThread();
    }
}

