/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.jidesoft.swing.JideSplitPane;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class PositronSplitPane
extends JideSplitPane {
    private static final int DIVIDER_SIZE = 5;
    private Color dividerBgColor;

    public PositronSplitPane(int newOrientation) {
        super(newOrientation);
        this.setDividerSize(5);
    }

    public void setDividerBackgroundColor(Color color) {
        this.dividerBgColor = color;
        SwingUtilities.invokeLater(this::applyDividerBgColor);
    }

    private void applyDividerBgColor() {
        if (this.dividerBgColor == null) {
            return;
        }
        for (Component child : this.getComponents()) {
            String className = child.getClass().getName().toLowerCase();
            if (!className.contains("divider")) continue;
            child.setBackground(this.dividerBgColor);
            if (!(child instanceof JComponent)) continue;
            ((JComponent)child).setOpaque(true);
        }
    }

    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(this::applyDividerBgColor);
    }

    public void updateUI() {
        super.updateUI();
        SwingUtilities.invokeLater(this::applyDividerBgColor);
    }
}

