/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.plugin.chat.LinkClickInstaller;
import java.awt.event.MouseListener;
import java.lang.reflect.Field;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class MessageTextAreaCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MessageTextAreaCreator.class.getName());

    private MessageTextAreaCreator() {
        throw new UnsupportedOperationException("Instantiation of this class is not allowed!");
    }

    public static JTextArea createMessageTextArea() {
        return MessageTextAreaCreator.createMessageTextArea("text/html");
    }

    public static JTextArea createMessageTextArea(String contentType) {
        JTextArea msgArea = OxygenUIComponentsFactory.createTextArea((String)contentType, (boolean)false);
        msgArea.setDropTarget(null);
        msgArea.setEditable(false);
        msgArea.setLineWrap(true);
        msgArea.setWrapStyleWord(true);
        LinkClickInstaller.addLinkClickListener(msgArea);
        return msgArea;
    }

    public static void removeBasePopupMenuListener(JTextArea messageTextArea) {
        block5: {
            try {
                MouseListener[] allListeners = messageTextArea.getMouseListeners();
                if (allListeners == null) break block5;
                for (MouseListener mouseListener : allListeners) {
                    boolean isPopup = false;
                    Class<?> clazz = mouseListener.getClass();
                    Field[] allFields = clazz.getDeclaredFields();
                    if (allFields != null) {
                        for (Field fld : allFields) {
                            fld.setAccessible(true);
                            if (!JPopupMenu.class.isAssignableFrom(fld.getType())) continue;
                            isPopup = true;
                            break;
                        }
                    }
                    if (!isPopup) continue;
                    messageTextArea.removeMouseListener(mouseListener);
                    break;
                }
            }
            catch (Throwable ex) {
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug(ex.getMessage(), ex);
            }
        }
    }
}

