/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.plugin.chat.ChatMessage;
import com.oxygenxml.positron.plugin.chat.ChatMessageResponseWithActionsPanel;
import com.oxygenxml.positron.plugin.chat.DropPasteAttachmentsTransferHandler;
import com.oxygenxml.positron.plugin.chat.EditMenuMouseListener;
import com.oxygenxml.positron.plugin.chat.MessageTextAreaCreator;
import com.oxygenxml.positron.plugin.chat.MessageUpdater;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentAwareTextHandler;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentsPanel;
import com.oxygenxml.positron.plugin.chat.utils.ChatUtil;
import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;

public class MessagePanel
extends ChatMessageResponseWithActionsPanel {
    private static final Insets MESSAGE_INSETS = new Insets(5, 5, 0, 5);
    private static final Translator I18N = Translator.getInstance();
    private ChatMessage chatMessage;
    protected MessageUpdater messageUpdater;
    private JPopupMenu chatMessageMenu;
    private AttachmentsPanel attachmentsPanel = new AttachmentsPanel();
    protected final AttachmentAwareTextHandler attachmentAwareTextHandler = new AttachmentAwareTextHandler(MessageTextAreaCreator.createMessageTextArea(), null, null, this.attachmentsPanel);

    public MessagePanel(ChatMessage chatMessage, MessageUpdater updater, String originalActionInvocationContext) {
        this.chatMessage = chatMessage;
        this.messageUpdater = updater;
        this.initPanel();
        if (originalActionInvocationContext != null) {
            this.attachmentsPanel.updateSelectionChip(originalActionInvocationContext, I18N.getTranslation("Context") + ":\n\n", "context");
        }
    }

    private void initPanel() {
        this.setOpaque(false);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setOpaque(false);
        Message message = this.chatMessage.getMessage();
        JComponent topSubcomponent = this.getTopSubcomponent();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = MESSAGE_INSETS;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        mainPanel.add((Component)topSubcomponent, gbc);
        this.getAttachmentAwareTextArea().setBounds(0, 0, 200, 20);
        String textMessage = ((MessageTextContent)message.getContent().get(0)).getText().trim();
        this.attachmentAwareTextHandler.setText(textMessage);
        this.getAttachmentAwareTextArea().addMouseListener(new EditMenuMouseListener(this.getAttachmentAwareTextArea(), () -> this.chatMessageMenu){

            @Override
            protected boolean shouldShowMenu() {
                return MessagePanel.this.getAttachmentAwareTextArea().getDocument().getLength() > 0;
            }
        });
        ++gbc.gridy;
        gbc.fill = 2;
        JPanel messageContentTextAreaPanel = new JPanel(new GridBagLayout());
        GridBagConstraints mc = new GridBagConstraints();
        mc.fill = 2;
        mc.weightx = 1.0;
        mc.anchor = 17;
        messageContentTextAreaPanel.add((Component)this.attachmentsPanel, mc);
        this.attachmentsPanel.setAttachmentComponentsVisible(false);
        ++mc.gridx;
        mc.insets = new Insets(5, 5, 5, 5);
        messageContentTextAreaPanel.add((Component)this.getAttachmentAwareTextArea(), mc);
        mainPanel.add((Component)messageContentTextAreaPanel, gbc);
        mainPanel.setOpaque(false);
        Optional<Color> backgroundColor = this.getBackgroundColor();
        if (backgroundColor.isPresent()) {
            Color bgColor = backgroundColor.get();
            this.getAttachmentAwareTextArea().setOpaque(false);
            messageContentTextAreaPanel.setOpaque(true);
            messageContentTextAreaPanel.setBackground(bgColor);
            messageContentTextAreaPanel.setBorder(BorderFactory.createLineBorder(ThemeColorProvider.getInstance().getViewTabsBorderColor(), 1));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        this.attachmentsPanel.setTransferHandler(new DropPasteAttachmentsTransferHandler(this.attachmentAwareTextHandler));
    }

    private JTextArea getAttachmentAwareTextArea() {
        return this.attachmentAwareTextHandler.getTextArea();
    }

    protected Optional<Color> getBackgroundColor() {
        return this.showRoleLabel() ? Optional.empty() : Optional.of(ThemeColorProvider.getInstance().getMeCardBackgroundColor());
    }

    protected JComponent getTopSubcomponent() {
        String labelText = this.getRoleLabel();
        JLabel roleLabel = new JLabel(labelText);
        roleLabel.setFont(roleLabel.getFont().deriveFont(1));
        roleLabel.setVisible(this.showRoleLabel());
        return roleLabel;
    }

    protected String getRoleLabel() {
        Message message = this.chatMessage.getMessage();
        if (message == null) {
            return "";
        }
        RoleType messageRole = message.getRole();
        return messageRole == RoleType.USER ? Translator.getInstance().getTranslation("Me") : "AI Positron";
    }

    @VisibleForTesting
    public JTextArea getMessageContentTextArea() {
        return this.getAttachmentAwareTextArea();
    }

    public MessageUpdater getMessageUpdater() {
        return this.messageUpdater;
    }

    @Override
    public void setAdditionalMenuActions(List<AbstractAction> actions) {
        this.chatMessageMenu = ChatUtil.createChatMessagePopup(this.getAttachmentAwareTextArea(), actions);
    }

    @Override
    public String getChatMessageContent() {
        String toReturn = null;
        toReturn = this.getAttachmentAwareTextArea().getSelectedText();
        if (TextUtils.isNullOrBlank((String)toReturn)) {
            toReturn = TextUtils.extractInsertionContentFromResponseForCurrentEditor((String)this.attachmentAwareTextHandler.getText());
        }
        return toReturn;
    }

    protected boolean showRoleLabel() {
        return false;
    }

    public void addSouthPanel(JPanel panel) {
        this.add((Component)panel, "South");
    }
}

