/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.core.filter.MaskingDetail;
import com.oxygenxml.positron.core.filter.SensitiveContentMaskingInfo;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.chat.BaseDetailsDialog;
import com.oxygenxml.positron.plugin.chat.DetailsDialogInterface;
import java.util.List;

public class MaskingDetailsDialog
extends BaseDetailsDialog
implements DetailsDialogInterface {
    private static final Translator TRANSLATOR_LOCAL = Translator.getInstance();

    public MaskingDetailsDialog() {
        super(TRANSLATOR_LOCAL.getTranslation("Sensitive_Content_Masking"));
    }

    public void showMaskingDetails(SensitiveContentMaskingInfo maskingInfo) {
        if (maskingInfo != null) {
            this.addMaskingDetails(maskingInfo);
            this.showDialog();
        }
    }

    public void addMaskingDetails(SensitiveContentMaskingInfo maskingInfo) {
        if (maskingInfo == null) {
            return;
        }
        this.setTitle(TRANSLATOR_LOCAL.getTranslation("Sensitive_Content_Masking"));
        this.append("**" + TRANSLATOR_LOCAL.getTranslation("Sensitive_Content_Total_Replacements") + ": " + maskingInfo.getTotalMaskedCount() + "**\n");
        this.append(TRANSLATOR_LOCAL.getTranslation("Masking_Details_Intro") + "\n\n");
        List details = maskingInfo.getMaskingDetails();
        if (!details.isEmpty()) {
            int index = 1;
            for (MaskingDetail detail : details) {
                String afterText;
                String originalContent = detail.getOriginalContent();
                String placeholder = detail.getPlaceholder();
                String before = detail.getContextBefore();
                String after = detail.getContextAfter();
                this.append("**" + TRANSLATOR_LOCAL.getTranslation("Masking_Replacement_Label") + " " + index + ":**\n");
                this.append("**" + TRANSLATOR_LOCAL.getTranslation("Masking_Masked_Label") + "** `" + originalContent + "` \u2192 `[" + placeholder + "]`\n");
                String beforeText = before != null && !before.isEmpty() ? before : "";
                String string = afterText = after != null && !after.isEmpty() ? after : "";
                if (!beforeText.isEmpty() || !afterText.isEmpty()) {
                    this.append("**" + TRANSLATOR_LOCAL.getTranslation("Masking_Context_Label") + "** ");
                    if (!beforeText.isEmpty()) {
                        this.append("..." + beforeText + " ");
                    }
                    this.append("`" + originalContent + "`");
                    if (!afterText.isEmpty()) {
                        this.append(" " + afterText + "...");
                    }
                    this.append("\n");
                }
                this.append("\n");
                ++index;
            }
        }
    }

    @Override
    public void addAllFunctionCalls(List<String> functionCalls) {
    }

    @Override
    public void addFunctionExecutionStarted(String functionName, String params) {
    }

    @Override
    public void addFunctionExecutionResult(String result) {
    }

    @Override
    public void addFunctionCallError(String error) {
    }

    @Override
    public String getDetailsContent() {
        return super.getDetailsContent();
    }
}

