/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import java.util.List;

public abstract class FunctionCallsDetailsEngine {
    static final Translator TRANSLATOR = Translator.getInstance();
    private int functionCallsSize = 0;
    private int currentCalledFunctionsCounter = 0;

    public void addAllFunctionCalls(List<String> functionCalls) {
        this.append("# Tool calls:\n");
        this.functionCallsSize = functionCalls.size();
        for (int i = 0; i < this.functionCallsSize; ++i) {
            if (this.functionCallsSize > 1) {
                this.append(" " + (i + 1));
                this.append(". ");
            } else {
                this.append(" - ");
            }
            this.append(functionCalls.get(i));
            this.append("()\n");
        }
    }

    public void addFunctionExecutionStarted(String functionName, String params) {
        this.append("\n## ");
        ++this.currentCalledFunctionsCounter;
        if (this.functionCallsSize > 1) {
            this.append("[" + this.currentCalledFunctionsCounter + "] ");
        }
        this.append("Calling tool: ");
        this.append(functionName);
        this.append("()\n");
        if (params != null && !params.isEmpty() && !"{}".equals(params)) {
            this.append("**Parameters:**\n");
            this.append("```json\n");
            this.append(FunctionCallsDetailsEngine.prettyPrintJsonUsingDefaultPrettyPrinter(params));
            this.append("\n```\n");
        }
    }

    public void addFunctionExecutionResult(String result) {
        this.addLabelAndTextAreaInFunctionCallsPanel("Result: ", result);
    }

    public void addFunctionCallError(String error) {
        this.addLabelAndTextAreaInFunctionCallsPanel("ERROR: ", error);
    }

    private void addLabelAndTextAreaInFunctionCallsPanel(String labelText, String textAreaContent) {
        this.append("**");
        this.append(labelText);
        this.append("**\n");
        String contentType = "";
        String trimmedContent = textAreaContent.trim();
        if (trimmedContent.startsWith("{") || trimmedContent.startsWith("[")) {
            contentType = "json";
        } else if (trimmedContent.contains("<") && trimmedContent.contains(">")) {
            contentType = "xml";
        }
        this.append("```");
        this.append(contentType);
        this.append("\n");
        this.append(FunctionCallsDetailsEngine.prettyPrintJsonUsingDefaultPrettyPrinter(textAreaContent));
        this.append("\n```\n");
    }

    private static String prettyPrintJsonUsingDefaultPrettyPrinter(String jsonContent) {
        try {
            if (jsonContent.contains("[") || jsonContent.contains("{")) {
                ObjectMapper objectMapper = AIRequestUtil.defaultObjectMapper();
                Object jsonObject = objectMapper.readValue(jsonContent, Object.class);
                return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return jsonContent;
    }

    protected abstract void append(String var1);
}

