/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.core.filter.SensitiveContentMaskingInfo;
import com.oxygenxml.positron.core.tools.UnsafeFunctionInterceptor;
import com.oxygenxml.positron.plugin.chat.BaseToolDetailsPanel;
import com.oxygenxml.positron.plugin.chat.FunctionCallsDetailsDialog;
import com.oxygenxml.positron.plugin.chat.MaskingDetailsDialog;
import com.oxygenxml.positron.plugin.ui.MultilineLabel;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class FunctionCallsAndDetailsPanel
extends BaseToolDetailsPanel {
    private static final Logger log = LoggerFactory.getLogger(FunctionCallsAndDetailsPanel.class);
    private static final Pattern URL_PATTERN = Pattern.compile("^([a-zA-Z][-a-zA-Z]*)://?[^\\s]+$");
    private JEditorPane functionCallsHTMLPane;

    @Override
    protected void initDetailsDialogIfNecessary() {
        if (this.detailsDialog == null) {
            this.infoButton.setVisible(true);
            this.detailsDialog = new FunctionCallsDetailsDialog();
        }
    }

    public void addFunctionExecutedStartedDetails(String toolId, String functionName, String params) {
        this.initDetailsDialogIfNecessary();
        this.detailsDialog.addFunctionExecutionStarted(functionName, params);
        this.updateButtonTooltip();
    }

    public void addFunctionCallResultDetails(String toolId, String result) {
        this.initDetailsDialogIfNecessary();
        this.detailsDialog.addFunctionExecutionResult(result);
        this.updateButtonTooltip();
    }

    public void addFunctionCallErrorDetails(String error) {
        this.initDetailsDialogIfNecessary();
        this.detailsDialog.addFunctionCallError(error);
        String errorMsg = "<div color='red'>ERROR: " + error + "</div>";
        this.addFunctionDetails(errorMsg);
        this.updateButtonTooltip();
    }

    public void addFunctionCallsDetails(List<String> functionCalls) {
        this.initDetailsDialogIfNecessary();
        this.detailsDialog.addAllFunctionCalls(functionCalls);
        this.updateButtonTooltip();
    }

    private void addFunctionDetails(String toolHTMLDescription) {
        if (this.functionCallsHTMLPane == null) {
            this.functionCallsHTMLPane = OxygenUIComponentsFactory.createHTMLEditorPane((String)"<html><body>", (boolean)true);
            this.functionCallsHTMLPane.setEditable(false);
            this.addHyperlinkListener();
            GridBagConstraints constr = this.getInfoButtonConstraints();
            this.add((Component)this.infoButton, constr);
            ++constr.gridx;
            constr.weightx = 1.0;
            constr.weighty = 1.0;
            constr.fill = 1;
            constr.insets = new Insets(2, 0, 0, 0);
            this.add((Component)this.functionCallsHTMLPane, constr);
            this.setVisible(true);
        }
        Document doc = this.functionCallsHTMLPane.getDocument();
        try {
            this.functionCallsHTMLPane.getEditorKit().read(new StringReader(toolHTMLDescription), doc, doc.getLength());
        }
        catch (IOException | BadLocationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void interceptUnsafeTool(String toolName, String arguments, final UnsafeFunctionInterceptor interceptor) {
        if (interceptor != null) {
            GridBagConstraints constr = new GridBagConstraints();
            constr.gridx = 0;
            constr.gridy = 1;
            constr.anchor = 12;
            ++constr.gridx;
            constr.weightx = 1.0;
            constr.weighty = 1.0;
            constr.fill = 1;
            constr.insets = new Insets(2, 0, 0, 0);
            final JPanel approvalPanel = new JPanel(new GridBagLayout());
            approvalPanel.setOpaque(false);
            approvalPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.lightGray), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            this.add((Component)approvalPanel, constr);
            GridBagConstraints approvalConstr = new GridBagConstraints();
            approvalConstr.gridx = 0;
            approvalConstr.gridy = 1;
            approvalConstr.weightx = 1.0;
            approvalConstr.weighty = 1.0;
            approvalConstr.fill = 1;
            approvalConstr.anchor = 17;
            approvalConstr.gridwidth = 2;
            approvalConstr.insets = new Insets(2, 2, 2, 2);
            String message = interceptor.getCustomMessage(arguments);
            if (message == null) {
                message = MessageFormat.format(TRANSLATOR.getTranslation("External_unsafe_tool_call_proceed"), toolName, arguments);
            }
            MultilineLabel warning = new MultilineLabel(message, false);
            approvalPanel.add((Component)warning, approvalConstr);
            approvalConstr.weightx = 0.0;
            approvalConstr.fill = 0;
            ++approvalConstr.gridy;
            approvalConstr.gridwidth = 1;
            JButton approve = OxygenUIComponentsFactory.createButton((Action)new AbstractAction(TRANSLATOR.getTranslation("Yes")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    interceptor.setAccepted(true);
                    approvalPanel.setVisible(false);
                }
            });
            JButton reject = OxygenUIComponentsFactory.createButton((Action)new AbstractAction(TRANSLATOR.getTranslation("No")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    interceptor.setAccepted(false);
                    approvalPanel.setVisible(false);
                }
            });
            approvalPanel.add((Component)(PlatformDetector.isMacOS() ? reject : approve), approvalConstr);
            ++approvalConstr.gridx;
            approvalPanel.add((Component)(PlatformDetector.isMacOS() ? approve : reject), approvalConstr);
        }
    }

    private void addHyperlinkListener() {
        HyperlinkListener[] listeners = this.functionCallsHTMLPane.getHyperlinkListeners();
        if (listeners != null) {
            for (HyperlinkListener hyperlinkListener : listeners) {
                this.functionCallsHTMLPane.removeHyperlinkListener(hyperlinkListener);
            }
        }
        this.functionCallsHTMLPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                URL url;
                final PluginWorkspace pwp = PluginWorkspaceProvider.getPluginWorkspace();
                if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && (url = e.getURL()) != null) {
                    if (pwp.getUtilAccess().isUnhandledBinaryResourceURL(url)) {
                        pwp.openInExternalApplication(url, true);
                    } else {
                        final URL urlTOOpen = url;
                        new Thread("Open Link"){

                            @Override
                            public void run() {
                                File file = URLUtil.getCanonicalFileFromFileUrl((URL)urlTOOpen);
                                if (file != null && file.isDirectory()) {
                                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE_FILE_DIR)) {
                                        Desktop.getDesktop().browseFileDirectory(file);
                                    }
                                } else {
                                    pwp.open(urlTOOpen);
                                }
                            }
                        }.start();
                    }
                }
                if (HyperlinkEvent.EventType.ENTERED.equals(e.getEventType())) {
                    FunctionCallsAndDetailsPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                }
                if (HyperlinkEvent.EventType.EXITED.equals(e.getEventType())) {
                    FunctionCallsAndDetailsPanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
    }

    public String getFunctionCallContentForTests() {
        if (this.functionCallsHTMLPane != null) {
            String normalized = this.functionCallsHTMLPane.getText().replaceAll("\\n", "").replaceAll("(\\s+)", " ").replace("</div>", "\n").replaceAll("<(.*?)>", "").trim();
            return normalized;
        }
        return "";
    }

    private static String wrapBracketPatternInGray(String escapedText) {
        return escapedText.replaceAll("\\[([^\\]]+)\\]", "<span style='color: gray;'>[$1]</span>");
    }

    static String processHTMLLinks(String text) {
        int startLinkIndex = ((String)text).indexOf(40);
        int endLinkIndex = ((String)text).lastIndexOf(41);
        StringBuilder sb = new StringBuilder();
        if (startLinkIndex != -1 && endLinkIndex > startLinkIndex) {
            Object fileName;
            sb.append("<span>");
            String textBeforeParenthesis = ((String)text).substring(0, startLinkIndex);
            textBeforeParenthesis = BasicXmlUtil.escape((String)textBeforeParenthesis);
            sb.append(textBeforeParenthesis);
            String paramContent = ((String)text).substring(startLinkIndex + 1, endLinkIndex).trim();
            File possibleFile = FunctionCallsAndDetailsPanel.extractLocalFile(paramContent);
            if (possibleFile != null) {
                fileName = possibleFile.getName();
                if (possibleFile.isDirectory()) {
                    fileName = (String)fileName + "/";
                }
                sb.append("(<a href=\"").append(URLUtil.convertToURL((String)paramContent)).append("\">").append(BasicXmlUtil.escape((String)URLUtil.uncorrect((String)fileName))).append("</a>)");
            } else if (URL_PATTERN.matcher(paramContent).matches()) {
                fileName = null;
                if (!paramContent.startsWith("http")) {
                    fileName = URLUtil.extractFileName((String)paramContent);
                }
                if (fileName == null || ((String)fileName).isEmpty()) {
                    fileName = URLUtil.filterPasswords((String)paramContent);
                }
                sb.append("(<a href=\"").append(URLUtil.convertToURL((String)paramContent)).append("\">").append(BasicXmlUtil.escape((String)URLUtil.uncorrect((String)fileName))).append("</a>)");
            } else {
                sb.append("(<b>").append(BasicXmlUtil.escape((String)paramContent)).append("</b>)");
            }
        } else {
            text = BasicXmlUtil.escape((String)text);
            if (((String)(text = FunctionCallsAndDetailsPanel.wrapBracketPatternInGray((String)text))).contains("\n")) {
                text = "<span>" + ((String)text).replace("\n", "<br>") + "</span>";
            }
            return text;
        }
        String textAfterParenthesis = BasicXmlUtil.escape((String)((String)text).substring(endLinkIndex + 1)).replace("\n", "<br>");
        textAfterParenthesis = FunctionCallsAndDetailsPanel.wrapBracketPatternInGray(textAfterParenthesis);
        sb.append(textAfterParenthesis);
        sb.append("</span>");
        return sb.toString();
    }

    private static File extractLocalFile(String param) {
        block2: {
            try {
                new URL(URLUtil.correct((String)param, (boolean)false));
            }
            catch (MalformedURLException ex) {
                File file = new File(param);
                if (!file.isAbsolute()) break block2;
                return file;
            }
        }
        return null;
    }

    public boolean hasMeaningfulContent() {
        return this.functionCallsHTMLPane != null;
    }

    public void appendFunction(String description) {
        String newCall = "<div>" + FunctionCallsAndDetailsPanel.processHTMLLinks(description) + "</div>";
        this.addFunctionDetails(newCall);
    }

    protected String getFunctionCallsDetails() {
        return this.detailsDialog.getDetailsContent();
    }

    public void checkExecutionAllowed(String toolId, String name, String description, String arguments, UnsafeFunctionInterceptor interceptor) {
        this.interceptUnsafeTool(name, arguments, interceptor);
    }

    public void showSensitiveContentMasking(SensitiveContentMaskingInfo maskingInfo) {
        if (maskingInfo == null || !maskingInfo.hasMasking()) {
            return;
        }
        if (this.detailsDialog == null) {
            this.detailsDialog = new MaskingDetailsDialog();
        }
        String message = TRANSLATOR.getTranslation("Sensitive_Content_Notification");
        String htmlMessage = "<div>" + BasicXmlUtil.escape((String)message) + "</div>";
        this.addFunctionDetailsAtBeginning(htmlMessage);
        if (this.detailsDialog instanceof MaskingDetailsDialog) {
            ((MaskingDetailsDialog)this.detailsDialog).addMaskingDetails(maskingInfo);
        }
        if (this.infoButton != null) {
            this.infoButton.setIcon(IconsLoader.loadIcon("/images/HideSecretContent16.png"));
            this.infoButton.setToolTipText(TRANSLATOR.getTranslation("Sensitive_content_masking_alt_text"));
        }
    }

    private void addFunctionDetailsAtBeginning(String toolHTMLDescription) {
        if (this.functionCallsHTMLPane == null) {
            this.addFunctionDetails(toolHTMLDescription);
            return;
        }
        Document doc = this.functionCallsHTMLPane.getDocument();
        try {
            this.functionCallsHTMLPane.getEditorKit().read(new StringReader(toolHTMLDescription), doc, 0);
        }
        catch (IOException | BadLocationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

