/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.chat.ChatMessageNavigationLevel;
import com.oxygenxml.positron.plugin.chat.EditableMessagePanel;
import com.oxygenxml.positron.plugin.chat.MessageUpdater;
import com.oxygenxml.positron.plugin.chat.actions.BranchNavigator;
import com.oxygenxml.positron.plugin.chat.actions.ChatMessageNavigationWidget;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentAwareTextHandler;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.KeyboardUtilities;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class EditableMessageTopSubPanel
extends JPanel {
    private MessageUpdater messageUpdater;
    private EditableMessagePanel parentComponent;
    private JButton editMessageButton;
    private AttachmentAwareTextHandler attachmentAwareTextHandler;
    private JButton submitEditButton;
    private JButton cancelEditButton;
    private final Action submitEditAction = this.createSubmitEditAction();
    private final Action cancelEditAction = this.createCancelEditAction();
    private JPanel submitAndCancelEditPanel = this.createSubmitAndCancelEditPanel();
    private String messageBeforeStartingEdit;
    private boolean isMessageBeingEdited;
    private ChatMessageNavigationWidget chatMessageNavigationWidget;

    public EditableMessageTopSubPanel(final EditableMessagePanel parent, final MessageUpdater messageUpdater, AttachmentAwareTextHandler attachmentAwareTextHandler, String roleLabelText, boolean showRoleLabel) {
        this.parentComponent = parent;
        this.messageUpdater = messageUpdater;
        this.attachmentAwareTextHandler = attachmentAwareTextHandler;
        this.setOpaque(false);
        this.setBorder(null);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        JLabel roleLabel = new JLabel(roleLabelText);
        roleLabel.setFont(roleLabel.getFont().deriveFont(1));
        roleLabel.setBorder(null);
        roleLabel.setVisible(showRoleLabel);
        this.add((Component)roleLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        JPanel fillerPanel = new JPanel();
        fillerPanel.setOpaque(false);
        fillerPanel.setBorder(null);
        this.add((Component)fillerPanel, gbc);
        gbc.weightx = 0.0;
        gbc.fill = 0;
        ++gbc.gridx;
        this.chatMessageNavigationWidget = new ChatMessageNavigationWidget(new Supplier<BranchNavigator>(){

            @Override
            public BranchNavigator get() {
                return new BranchNavigator(){

                    @Override
                    public void right() {
                        messageUpdater.selectSiblingMessage(parent, true);
                    }

                    @Override
                    public void left() {
                        messageUpdater.selectSiblingMessage(parent, false);
                    }
                };
            }
        });
        this.add((Component)this.chatMessageNavigationWidget, gbc);
        this.setVisible(false);
        this.editMessageButton = OxygenUIComponentsFactory.createToolbarButton((Action)this.createEditMessageAction(), (boolean)false);
        this.editMessageButton.setMargin(null);
        this.editMessageButton.setOpaque(false);
        KeyboardUtilities.setSubmitAndNewlineShortcuts(attachmentAwareTextHandler.getTextArea(), this.submitEditAction);
        this.addFloatingEditButtonSupport();
    }

    private void addFloatingEditButtonSupport() {
        this.editMessageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableMessageTopSubPanel.this.hideEditButton();
            }
        });
        this.getDecoratedTextArea().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                EditableMessageTopSubPanel.this.showHideEditButton();
            }
        });
        this.getDecoratedTextArea().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                EditableMessageTopSubPanel.this.hideEditButton();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                EditableMessageTopSubPanel.this.hideEditButton();
            }
        });
        this.getDecoratedTextArea().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (!new Rectangle(0, 0, EditableMessageTopSubPanel.this.getDecoratedTextArea().getBounds().width, EditableMessageTopSubPanel.this.getDecoratedTextArea().getBounds().height).contains(e.getPoint())) {
                    EditableMessageTopSubPanel.this.hideEditButton();
                }
            }
        });
        this.editMessageButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                EditableMessageTopSubPanel.this.hideEditButton();
            }
        });
        this.getDecoratedTextArea().addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (e.getDot() != e.getMark()) {
                    EditableMessageTopSubPanel.this.hideEditButton();
                }
            }
        });
    }

    public void addEditButtonToRootPane() {
        JRootPane rootPane = UIUtil.getRootPane(this.getDecoratedTextArea());
        if (rootPane != null) {
            JLayeredPane layeredPane = rootPane.getLayeredPane();
            Point textAreaLocation = this.getDecoratedTextArea().getLocationOnScreen();
            Point rpLocation = rootPane.getLocationOnScreen();
            if (textAreaLocation != null && rpLocation != null) {
                Dimension preferredSize = this.editMessageButton.getPreferredSize();
                this.editMessageButton.setBounds(textAreaLocation.x - rpLocation.x + this.getDecoratedTextArea().getSize().width - preferredSize.width, textAreaLocation.y - rpLocation.y - 3, preferredSize.width, preferredSize.height);
                layeredPane.add(this.editMessageButton, JLayeredPane.POPUP_LAYER, 0);
            }
        }
    }

    private JTextArea getDecoratedTextArea() {
        return this.attachmentAwareTextHandler.getTextArea();
    }

    public void updateUiForLevels(ChatMessageNavigationLevel navigationLevel, boolean enabled) {
        this.chatMessageNavigationWidget.updateUiForLevels(navigationLevel, enabled);
        this.editMessageButton.setEnabled(enabled);
        this.setVisible(this.chatMessageNavigationWidget.isNavigationWidgetVisible());
    }

    private JPanel createSubmitAndCancelEditPanel() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout());
        buttonsPanel.setOpaque(false);
        this.submitEditButton = OxygenUIComponentsFactory.createButton((Action)this.submitEditAction);
        this.cancelEditButton = OxygenUIComponentsFactory.createButton((Action)this.cancelEditAction);
        buttonsPanel.add(this.submitEditButton);
        buttonsPanel.add(this.cancelEditButton);
        return buttonsPanel;
    }

    private AbstractAction createEditMessageAction() {
        return new AbstractAction(Translator.getInstance().getTranslation("Edit"), IconsLoader.loadIcon("/images/EditChat16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Optional<EditableMessagePanel> messageThatWasBeingEdited = EditableMessageTopSubPanel.this.getMessageThatWasBeingEdited();
                if (messageThatWasBeingEdited.isPresent()) {
                    messageThatWasBeingEdited.get().cancelEdit();
                }
                EditableMessageTopSubPanel.this.isMessageBeingEdited = true;
                EditableMessageTopSubPanel.this.messageBeforeStartingEdit = EditableMessageTopSubPanel.this.attachmentAwareTextHandler.getPlainTextContentWithAttachmentsExpanded();
                EditableMessageTopSubPanel.this.parentComponent.addSouthPanel(EditableMessageTopSubPanel.this.submitAndCancelEditPanel);
                EditableMessageTopSubPanel.this.getDecoratedTextArea().setBorder(BorderFactory.createCompoundBorder(new LineBorder(Color.GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
                EditableMessageTopSubPanel.this.getDecoratedTextArea().setEditable(true);
                EditableMessageTopSubPanel.this.getDecoratedTextArea().setOpaque(true);
                SwingUtilities.invokeLater(() -> {
                    EditableMessageTopSubPanel.this.refreshGUI();
                    EditableMessageTopSubPanel.this.getDecoratedTextArea().requestFocusInWindow();
                });
            }
        };
    }

    private Action createSubmitEditAction() {
        return new AbstractAction(Translator.getInstance().getTranslation("Submit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                String plainTextContentWithAttachmentsExpanded = EditableMessageTopSubPanel.this.attachmentAwareTextHandler.getPlainTextContentWithAttachmentsExpanded().trim();
                String unreferencedAttachmentsWithMarkerToAddToModel = EditableMessageTopSubPanel.this.attachmentAwareTextHandler.getUnreferencedAttachmentsWithMarkerToAddToModel();
                EditableMessageTopSubPanel.this.messageUpdater.submitEditedMessage(EditableMessageTopSubPanel.this.parentComponent, plainTextContentWithAttachmentsExpanded + unreferencedAttachmentsWithMarkerToAddToModel);
                EditableMessageTopSubPanel.this.refreshGUI();
                EditableMessageTopSubPanel.this.isMessageBeingEdited = false;
            }
        };
    }

    private Action createCancelEditAction() {
        return new AbstractAction(Translator.getInstance().getTranslation("Cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableMessageTopSubPanel.this.cancelEditing();
                EditableMessageTopSubPanel.this.isMessageBeingEdited = false;
            }
        };
    }

    public void cancelEditing() {
        this.attachmentAwareTextHandler.setText(this.messageBeforeStartingEdit);
        this.getDecoratedTextArea().setEditable(false);
        this.getDecoratedTextArea().setOpaque(false);
        this.getDecoratedTextArea().setBorder(null);
        this.parentComponent.remove(this.submitAndCancelEditPanel);
        this.refreshGUI();
    }

    @Override
    public String toString() {
        return this.chatMessageNavigationWidget.toString();
    }

    public JButton getEditButton() {
        return this.editMessageButton;
    }

    public JButton getCancelButton() {
        return this.cancelEditButton;
    }

    public JButton getSubmitButton() {
        return this.submitEditButton;
    }

    public boolean isMessageBeingEdited() {
        return this.isMessageBeingEdited;
    }

    private Optional<EditableMessagePanel> getMessageThatWasBeingEdited() {
        Component[] components;
        Optional<EditableMessagePanel> toReturn = Optional.empty();
        for (Component component : components = this.parentComponent.getParent().getComponents()) {
            EditableMessagePanel editableMessagePanel;
            if (!(component instanceof EditableMessagePanel) || !(editableMessagePanel = (EditableMessagePanel)component).isMessageBeingEdited()) continue;
            toReturn = Optional.of(editableMessagePanel);
            break;
        }
        return toReturn;
    }

    private void refreshGUI() {
        this.revalidate();
        this.repaint();
    }

    private void hideEditButton() {
        this.editMessageButton.setVisible(false);
        if (this.editMessageButton.getParent() != null) {
            this.editMessageButton.getParent().remove(this.editMessageButton);
        }
    }

    private void showHideEditButton() {
        boolean show = !this.attachmentAwareTextHandler.isEditable() && this.editMessageButton.isEnabled() && this.getDecoratedTextArea().getSelectionStart() == this.getDecoratedTextArea().getSelectionEnd();
        this.editMessageButton.setVisible(show);
        if (show) {
            if (this.editMessageButton.getParent() == null) {
                this.editMessageButton.setVisible(true);
                this.addEditButtonToRootPane();
            }
        } else {
            this.hideEditButton();
        }
    }
}

