/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

abstract class EditMenuMouseListener
extends MouseAdapter {
    private final JComponent component;
    private final Supplier<JPopupMenu> menuSupplier;

    public EditMenuMouseListener(JComponent component, Supplier<JPopupMenu> menuSupplier) {
        this.menuSupplier = menuSupplier;
        this.component = component;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseReleased(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        JPopupMenu menu;
        if (e.isPopupTrigger() && this.shouldShowMenu() && (menu = this.menuSupplier.get()) != null && menu.getParent() == null) {
            e.consume();
            this.component.add(menu);
            menu.show(this.component, e.getX(), e.getY());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditMenuMouseListener.this.component.remove(menu);
                }
            });
        }
    }

    protected abstract boolean shouldShowMenu();
}

