/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.plugin.chat.UserInputTextHandler;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.util.URLUtil;

public class DropPasteAttachmentsTransferHandler
extends TransferHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DropPasteAttachmentsTransferHandler.class.getName());
    private UserInputTextHandler userInputTextHandler;

    public DropPasteAttachmentsTransferHandler(UserInputTextHandler userInputTextHandler) {
        this.userInputTextHandler = userInputTextHandler;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return this.userInputTextHandler.isEditable() && (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || support.isDataFlavorSupported(DataFlavor.stringFlavor) || support.isDataFlavorSupported(DataFlavor.imageFlavor));
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clipboard, int action) throws IllegalStateException {
        int p1;
        JTextComponent text;
        int p0;
        if (comp instanceof JTextComponent && (p0 = (text = (JTextComponent)comp).getSelectionStart()) != (p1 = text.getSelectionEnd())) {
            try {
                Document doc = text.getDocument();
                String srcData = doc.getText(p0, p1 - p0);
                StringSelection contents = new StringSelection(srcData);
                clipboard.setContents(contents, null);
                if (action == 2) {
                    this.userInputTextHandler.removeText(p0, p1);
                }
            }
            catch (BadLocationException ble) {
                LOGGER.error(ble.getMessage(), (Throwable)ble);
            }
        }
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        boolean imported = false;
        try {
            if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List files = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                for (Object file : files) {
                    this.userInputTextHandler.insertURL(URLUtil.correct((File)((File)file)));
                }
                imported = true;
            } else if (support.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String data = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
                this.userInputTextHandler.insertTextAtCurrentPosition(data);
                imported = true;
            } else if (support.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                this.handleScreenshotPaste(support.getTransferable());
                imported = true;
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return imported;
    }

    private void handleScreenshotPaste(Transferable transferable) throws Exception {
        Image image = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
        if (image != null) {
            BufferedImage bufferedImage = DropPasteAttachmentsTransferHandler.convertToBufferedImage(image);
            File screenshotFile = DropPasteAttachmentsTransferHandler.saveScreenshotToFile(bufferedImage);
            this.userInputTextHandler.insertURL(URLUtil.correct((File)screenshotFile));
        }
    }

    private static BufferedImage convertToBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        bufferedImage.getGraphics().drawImage(image, 0, 0, null);
        bufferedImage.getGraphics().dispose();
        return bufferedImage;
    }

    private static File saveScreenshotToFile(BufferedImage bufferedImage) throws IOException {
        String timestamp = new SimpleDateFormat("yyyy-MM-dd 'at' HH.mm.ss").format(new Date());
        String baseFilename = "Screenshot " + timestamp + ".png";
        File tempDir = FileSystemUtil.getOxygenTempDirectory();
        File screenshotFile = new File(tempDir, baseFilename);
        if (screenshotFile.exists()) {
            String uniqueId = UUID.randomUUID().toString().substring(0, 8);
            String uniqueFilename = "Screenshot " + timestamp + " " + uniqueId + ".png";
            screenshotFile = new File(tempDir, uniqueFilename);
        }
        ImageIO.write((RenderedImage)bufferedImage, "PNG", screenshotFile);
        screenshotFile.deleteOnExit();
        return screenshotFile;
    }
}

