/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ChatFunctionRef;
import com.oxygenxml.positron.utilities.json.Parameters;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

class DisabledToolsUtilities {
    private static final String DISABLED_TOOLS_SEPARATOR = "--==--";

    DisabledToolsUtilities() {
    }

    public static boolean isToolDisabled(String toolName) {
        String[] toolNames;
        PluginWorkspace pluginWorkspaceAccess = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWorkspaceAccess == null || toolName == null) {
            return false;
        }
        WSOptionsStorage optionsStorage = pluginWorkspaceAccess.getOptionsStorage();
        if (optionsStorage == null) {
            return false;
        }
        String currentChatModeId = pluginWorkspaceAccess.getOptionsStorage().getOption("oxygen.positron.plugin.chat.mode.action.id", "pseudoaction.chat.message.agent");
        if (currentChatModeId == null) {
            return false;
        }
        String preferenceKey = DisabledToolsUtilities.getDisabledToolsKey(currentChatModeId);
        String disabledToolsOption = optionsStorage.getOption(preferenceKey, "");
        if (disabledToolsOption == null || disabledToolsOption.isEmpty()) {
            return false;
        }
        for (String disabledToolName : toolNames = disabledToolsOption.split(DISABLED_TOOLS_SEPARATOR)) {
            if (!toolName.equals(disabledToolName.trim())) continue;
            return true;
        }
        return false;
    }

    private static String getDisabledToolsKey(String chatModeId) {
        return "oxygen.positron.plugin.disabled.tools." + chatModeId;
    }

    public static Set<String> loadDisabledTools() {
        String disabledToolsOption;
        HashSet<String> disabledTools = new HashSet<String>();
        PluginWorkspace pluginWorkspaceAccess = PluginWorkspaceProvider.getPluginWorkspace();
        String currentChatModeId = pluginWorkspaceAccess.getOptionsStorage().getOption("oxygen.positron.plugin.chat.mode.action.id", "pseudoaction.chat.message.agent");
        if (pluginWorkspaceAccess != null && currentChatModeId != null && (disabledToolsOption = pluginWorkspaceAccess.getOptionsStorage().getOption(DisabledToolsUtilities.getDisabledToolsKey(currentChatModeId), "")) != null && !disabledToolsOption.isEmpty()) {
            String[] toolNames;
            for (String toolName : toolNames = disabledToolsOption.split(DISABLED_TOOLS_SEPARATOR)) {
                if ((toolName = toolName.trim()).isEmpty()) continue;
                disabledTools.add(toolName);
            }
        }
        return disabledTools;
    }

    public static void saveDisabledTools(Set<String> disabledTools) {
        PluginWorkspace pluginWorkspaceAccess = PluginWorkspaceProvider.getPluginWorkspace();
        String currentChatModeId = pluginWorkspaceAccess.getOptionsStorage().getOption("oxygen.positron.plugin.chat.mode.action.id", "pseudoaction.chat.message.agent");
        if (pluginWorkspaceAccess != null && currentChatModeId != null) {
            StringBuilder sb = new StringBuilder();
            for (String toolName : disabledTools) {
                if (sb.length() > 0) {
                    sb.append(DISABLED_TOOLS_SEPARATOR);
                }
                sb.append(toolName);
            }
            pluginWorkspaceAccess.getOptionsStorage().setOption(DisabledToolsUtilities.getDisabledToolsKey(currentChatModeId), sb.toString());
        }
    }

    public static Set<String> getCurrentChatModeReferencedTools(CompletionActionsManager completionActionsManager) {
        HashSet<String> refTools = new HashSet<String>();
        PluginWorkspace pluginWorkspaceAccess = PluginWorkspaceProvider.getPluginWorkspace();
        String currentChatModeId = pluginWorkspaceAccess.getOptionsStorage().getOption("oxygen.positron.plugin.chat.mode.action.id", "pseudoaction.chat.message.agent");
        List<PositronAIActionBase> allPseudos = completionActionsManager.getPseudoActions();
        if (currentChatModeId != null && allPseudos != null) {
            for (PositronAIActionBase action : allPseudos) {
                AIActionDetails actionDetails = action.getActionDetails();
                if (!currentChatModeId.equals(actionDetails.getId())) continue;
                Parameters params = actionDetails.getParameters();
                if (params == null || params.getFunctionRefs() == null) break;
                List functionRefs = params.getFunctionRefs();
                for (ChatFunctionRef functionRef : functionRefs) {
                    refTools.add(functionRef.getRef());
                }
            }
        }
        return refTools;
    }
}

