/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.chat.ChatModesListener;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.utilities.json.ActionType;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.SplitMenuButton;

public class ChatStartAndModesInteractor {
    private static final String ACTION_ID = "action.id";
    private PluginWorkspace pluginWorkspaceAccess;
    private CompletionActionsManager completionActionsManager;
    private AbstractButton chatStartButton;
    private SplitMenuButton chatModesSwitchButton;
    private boolean actionThreadInProgress;
    private ChatModesListener chatModeChangeListener;

    public ChatStartAndModesInteractor(PluginWorkspace pluginWorkspaceAccess, CompletionActionsManager completionActionsManager, final Runnable clearChatRunnable) {
        this.pluginWorkspaceAccess = pluginWorkspaceAccess;
        this.completionActionsManager = completionActionsManager;
        AbstractAction chatAction = new AbstractAction(Translator.getInstance().getTranslation("New_chat"), IconsLoader.loadIcon("/images/NewChat16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(() -> clearChatRunnable.run());
            }
        };
        this.chatStartButton = OxygenUIComponentsFactory.createToolbarButton((Action)chatAction, (boolean)false);
        this.chatModesSwitchButton = OxygenUIComponentsFactory.createSplitMenuButton((String)"", null, (boolean)true, (boolean)false, (boolean)true, (boolean)true);
        this.actionsReloaded();
    }

    private void createModesButton() {
        final ArrayList<AbstractAction> allChatActions = new ArrayList<AbstractAction>();
        List<PositronAIActionBase> allPseudos = this.completionActionsManager.getPseudoActions();
        if (allPseudos != null) {
            for (final PositronAIActionBase action : allPseudos) {
                if (action.getActionDetails() == null || action.getActionDetails().getComputedType() != ActionType.CHAT_MODE || !action.getActionDetails().isVisibleInUI()) continue;
                AbstractAction chatAction = new AbstractAction(action.getActionDetails().getTitle()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ChatStartAndModesInteractor.this.pluginWorkspaceAccess != null) {
                            ChatStartAndModesInteractor.this.pluginWorkspaceAccess.getOptionsStorage().setOption("oxygen.positron.plugin.chat.mode.action.id", action.getActionDetails().getId());
                        }
                        ChatStartAndModesInteractor.this.reconfigureSelectedAction(allChatActions);
                        if (ChatStartAndModesInteractor.this.chatModeChangeListener != null) {
                            ChatStartAndModesInteractor.this.chatModeChangeListener.onModeChange();
                        }
                    }
                };
                if (action.getActionDetails().getDescription() != null) {
                    chatAction.putValue("ShortDescription", Translator.getInstance().getTranslation("Chat_mode") + ": " + action.getActionDetails().getTitle() + "\n" + action.getActionDetails().getDescription());
                }
                chatAction.putValue(ACTION_ID, action.getActionDetails().getId());
                allChatActions.add(chatAction);
            }
        }
        this.chatModesSwitchButton.removeAll();
        if (allChatActions.size() > 1) {
            this.chatModesSwitchButton.setVisible(true);
            String currentChatAction = this.pluginWorkspaceAccess.getOptionsStorage().getOption("oxygen.positron.plugin.chat.mode.action.id", "pseudoaction.chat.message.agent");
            AbstractAction baseChatAction = null;
            boolean foundCurrentAction = false;
            for (AbstractAction action : allChatActions) {
                if ("pseudoaction.chat.message.agent".equals(action.getValue(ACTION_ID))) {
                    baseChatAction = action;
                }
                this.chatModesSwitchButton.addAction((Action)action, true);
                if (!currentChatAction.equals(action.getValue(ACTION_ID))) continue;
                foundCurrentAction = true;
                this.chatModesSwitchButton.setAction((Action)action);
            }
            if (!foundCurrentAction && baseChatAction != null) {
                this.chatModesSwitchButton.setAction(baseChatAction);
            }
            this.reconfigureSelectedAction(allChatActions);
        } else {
            this.chatModesSwitchButton.setVisible(false);
        }
    }

    private void reconfigureSelectedAction(List<AbstractAction> allChatActions) {
        if (allChatActions != null) {
            String currentChatAction = this.pluginWorkspaceAccess.getOptionsStorage().getOption("oxygen.positron.plugin.chat.mode.action.id", "pseudoaction.chat.message.agent");
            if (allChatActions.size() > 1) {
                AbstractAction baseChatAction = null;
                boolean foundCurrentAction = false;
                for (AbstractAction chatAction : allChatActions) {
                    if ("pseudoaction.chat.message.agent".equals(chatAction.getValue(ACTION_ID))) {
                        baseChatAction = chatAction;
                    }
                    if (currentChatAction.equals(chatAction.getValue(ACTION_ID))) {
                        chatAction.putValue("SmallIcon", IconsLoader.loadIcon("/images/menu_checkbox_vsnet.png"));
                        foundCurrentAction = true;
                        continue;
                    }
                    chatAction.putValue("SmallIcon", null);
                }
                if (!foundCurrentAction && baseChatAction != null) {
                    baseChatAction.putValue("SmallIcon", IconsLoader.loadIcon("/images/menu_checkbox_vsnet.png"));
                }
            }
        }
    }

    public void actionsReloaded() {
        this.createModesButton();
    }

    public void setSelectedChatMode(PositronAIActionBase chatMode) {
        SwingUtilities.invokeLater(() -> {
            this.chatModesSwitchButton.setAction((Action)chatMode);
            if (this.pluginWorkspaceAccess != null) {
                this.pluginWorkspaceAccess.getOptionsStorage().setOption("oxygen.positron.plugin.chat.mode.action.id", chatMode.getActionDetails().getId());
            }
        });
    }

    public AbstractButton getChatStartButton() {
        return this.chatStartButton;
    }

    public AbstractButton getChatModesSwitchButton() {
        return this.chatModesSwitchButton;
    }

    public void setChatButtonsEnabled(boolean enabled) {
        this.chatStartButton.setEnabled(enabled);
        this.chatModesSwitchButton.setEnabled(!this.actionThreadInProgress && enabled);
    }

    public void setNewChatEnabled(boolean enabled) {
        this.chatStartButton.setEnabled(enabled);
    }

    public void setChatModeChangeListener(ChatModesListener listener) {
        this.chatModeChangeListener = listener;
    }

    public void setActionThreadInProgress(boolean actionThreadInProgress) {
        this.actionThreadInProgress = actionThreadInProgress;
        this.chatModesSwitchButton.setEnabled(!actionThreadInProgress);
    }
}

