/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.chat.ChatSplitPanelProportionsUpdater;
import com.oxygenxml.positron.plugin.chat.UserInputTextHandler;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentHighlightAwareTextArea;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentsPanel;
import com.oxygenxml.positron.plugin.chat.quickfind.QuickSearchItemDialog;
import com.oxygenxml.positron.plugin.chat.quickfind.URLQuickSearchItem;
import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import com.oxygenxml.positron.plugin.util.KeyboardUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.Objects;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.View;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class ChatPanelUserInputComponentWithAutoHeight
implements UserInputTextHandler {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private static final int USER_INPUT_MIN_NO_OF_LINES = 3;
    private static final int SCROLL_PANES_MIN_WIDTH = 200;
    private int oldNumberOfTextLinesFromUserInputTextArea = 1;
    private AttachmentHighlightAwareTextArea textArea;
    private JScrollPane inputTextAreaScrollPane;
    private static final double MIN_PROPORTION_OF_TOP_PANEL = 0.4;
    private ChatSplitPanelProportionsUpdater proportionsUpdater;
    private AbstractAction submitAction;
    private int previousAttachmentsHeight = 0;

    public ChatPanelUserInputComponentWithAutoHeight(Runnable onCtrlSpace, final ChatSplitPanelProportionsUpdater proportionsUpdater, final AttachmentsPanel attachmentsPanel) {
        this.proportionsUpdater = Objects.requireNonNull(proportionsUpdater);
        Objects.requireNonNull(attachmentsPanel);
        this.textArea = new AttachmentHighlightAwareTextArea(TRANSLATOR.getTranslation("User_input_area_with_action_quickfind_placeholder"), onCtrlSpace, attachmentsPanel);
        AccessibleContext accessibleContext = this.textArea.getAccessibleContext();
        accessibleContext.setAccessibleName("User input");
        accessibleContext.setAccessibleDescription("Use this input text area to send requests to the Positron artificial-intelligence-based platform.");
        this.inputTextAreaScrollPane = OxygenUIComponentsFactory.createScrollPane((Component)this.textArea, (int)20, (int)31);
        this.inputTextAreaScrollPane.setBorder(new BorderUIResource.MatteBorderUIResource(0, 0, 1, 0, ThemeColorProvider.getInstance().getViewTabsBorderColor()));
        int fontHeight = this.textArea.getFontMetrics(this.textArea.getFont()).getHeight();
        this.inputTextAreaScrollPane.setMinimumSize(new Dimension(200, 3 * fontHeight));
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                boolean isFromPaste = e.getType() == DocumentEvent.EventType.INSERT && e.getLength() > 1;
                SwingUtilities.invokeLater(() -> ChatPanelUserInputComponentWithAutoHeight.this.increaseTextAreaHeight(isFromPaste));
            }
        });
        attachmentsPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SwingUtilities.invokeLater(() -> {
                    double topPanelCurrentProportion;
                    double[] proportions = proportionsUpdater.getProportions();
                    if (proportions != null && proportions.length > 0 && (topPanelCurrentProportion = ChatPanelUserInputComponentWithAutoHeight.with2Decimals(proportions[0])) > 0.4) {
                        int currentHeight = attachmentsPanel.getHeight();
                        if (ChatPanelUserInputComponentWithAutoHeight.this.previousAttachmentsHeight != 0 && currentHeight > ChatPanelUserInputComponentWithAutoHeight.this.previousAttachmentsHeight) {
                            int heightDifference = currentHeight - ChatPanelUserInputComponentWithAutoHeight.this.previousAttachmentsHeight;
                            int totalHeight = proportionsUpdater.getSplitPanelHeight();
                            double heightDiffProportion = (double)heightDifference / (double)(totalHeight + heightDifference);
                            double newTopPanelProportion = Math.max(topPanelCurrentProportion - heightDiffProportion, 0.4);
                            proportionsUpdater.setProportions(new double[]{newTopPanelProportion});
                        }
                        ChatPanelUserInputComponentWithAutoHeight.this.previousAttachmentsHeight = currentHeight;
                    }
                });
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ChatPanelUserInputComponentWithAutoHeight.this.previousAttachmentsHeight = 0;
            }
        });
    }

    private void increaseTextAreaHeight(boolean isFromPaste) {
        int textAreaNeededLines;
        boolean textAreaWasDecreasedManually;
        double[] proportions = this.proportionsUpdater.getProportions();
        boolean bl = textAreaWasDecreasedManually = proportions != null && proportions[0] > 0.7;
        if (!(textAreaWasDecreasedManually || this.inputTextAreaScrollPane.getVerticalScrollBar().isVisible() && !isFromPaste || (textAreaNeededLines = this.calculateInstructionsTextAreaLines(this.textArea)) == this.oldNumberOfTextLinesFromUserInputTextArea)) {
            int width = this.inputTextAreaScrollPane.getViewport().getWidth();
            int height = this.inputTextAreaScrollPane.getViewport().getHeight();
            this.textArea.setSize(new Dimension(width, height));
            Dimension preferred = this.textArea.getPreferredSize();
            int delta = this.proportionsUpdater.getBottomPanelHeight() - this.textArea.getHeight();
            int neededHeight = preferred.height + 4 + delta;
            int totalHeight = this.proportionsUpdater.getSplitPanelHeight();
            int maxBottomHeight = (int)((double)totalHeight * 0.6);
            if (neededHeight < maxBottomHeight) {
                double topPanelCurrentProportion = ChatPanelUserInputComponentWithAutoHeight.with2Decimals(this.proportionsUpdater.getProportions()[0]);
                if (topPanelCurrentProportion > 0.4) {
                    this.inputTextAreaScrollPane.setPreferredSize(new Dimension(width, neededHeight));
                    double bottomProp = (double)neededHeight / (double)totalHeight;
                    double topProp = 1.0 - bottomProp;
                    double min = Math.min(topProp, this.proportionsUpdater.getProportions()[0]);
                    this.proportionsUpdater.setProportions(new double[]{min});
                }
            } else {
                this.inputTextAreaScrollPane.setPreferredSize(new Dimension(width, maxBottomHeight));
                double[] props = this.proportionsUpdater.getProportions();
                double min = Math.min(props != null ? props[0] : 0.0, 0.4);
                this.proportionsUpdater.setProportions(new double[]{min});
            }
            this.oldNumberOfTextLinesFromUserInputTextArea = textAreaNeededLines;
        }
    }

    private static double with2Decimals(double value) {
        try {
            return BigDecimal.valueOf(value).setScale(2, RoundingMode.HALF_UP).doubleValue();
        }
        catch (ArithmeticException | NumberFormatException e) {
            return value;
        }
    }

    @Override
    public void insertTextAtCurrentPosition(String text) {
        this.textArea.insertTextAtCurrentPosition(text);
    }

    public void addAttachmentToConversation(String attachmentPath) {
        this.textArea.insertURL(URLUtil.convertToURL((String)attachmentPath));
    }

    public void setPlaceholder(String hint) {
        this.textArea.setPlaceholder(hint);
    }

    private int calculateInstructionsTextAreaLines(JTextArea textArea) {
        View view = textArea.getUI().getRootView(textArea);
        float preferredHeight = view.getPreferredSpan(1);
        int lineHeight = textArea.getFontMetrics(textArea.getFont()).getHeight();
        return (int)Math.ceil(preferredHeight / (float)lineHeight);
    }

    @Override
    public void onTextUpdate(Runnable onTextUpdate) {
        this.textArea.onTextUpdate(onTextUpdate);
    }

    public void registerSubmitAction(AbstractAction submitAction) {
        this.submitAction = submitAction;
        KeyboardUtilities.setSubmitAndNewlineShortcuts(this.textArea, submitAction);
    }

    public JScrollPane getScrollPane() {
        return this.inputTextAreaScrollPane;
    }

    public void focusNow() {
        this.textArea.requestFocusInWindow();
    }

    @Override
    public String getText() {
        return this.textArea.getText();
    }

    @Override
    public String getPlainTextContentWithAttachmentsExpanded() {
        return this.textArea.getPlainTextContentWithAttachmentsExpanded();
    }

    @Override
    public String getUnreferencedAttachmentsWithMarkerToAddToModel() {
        return this.textArea.getUnreferencedAttachmentsWithMarkerToAddToModel();
    }

    @Override
    public void setText(String text) {
        this.textArea.setText(text);
    }

    public boolean canUserType() {
        return this.textArea.isEditable();
    }

    public void setEnableUserArea(boolean enableStatus) {
        this.textArea.setEnabled(enableStatus);
    }

    @Override
    public void submitToAI() {
        if (this.submitAction != null) {
            this.submitAction.actionPerformed(null);
        }
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public QuickSearchItemDialog<URLQuickSearchItem> getDialog() {
        return this.textArea.getDialog();
    }

    public void insertAtCaret(URLQuickSearchItem fileQuickSearchItem, int length) throws BadLocationException {
        this.textArea.insertAtCaret(fileQuickSearchItem, length);
    }

    @Override
    public void removeText(int start, int end) {
        this.textArea.removeText(start, end);
    }

    @Override
    public void clearAll() {
        this.textArea.clearAll();
    }

    @Override
    public boolean isEditable() {
        return this.textArea.isEditable();
    }

    @Override
    public void insertURL(URL file) {
        this.textArea.insertURL(file);
    }

    @Override
    public void updateReferencesWhenSelectionChanges() {
        this.textArea.updateReferencesWhenSelectionChanges();
    }
}

