/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.api.connector.dto.ToolCallResponseMessage;
import com.oxygenxml.positron.core.tools.ChatToolsEnhancer;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.plugin.chat.GenericTranslationChatStartMessage;
import com.oxygenxml.positron.plugin.chat.attachments.MessageDescriptionUtil;
import com.oxygenxml.positron.plugin.chat.history.CorrectionMessageNode;
import com.oxygenxml.positron.plugin.chat.history.MaskingNotificationMessageNode;
import com.oxygenxml.positron.plugin.chat.history.MessageNode;
import com.oxygenxml.positron.plugin.chat.history.MessageTreeConversation;
import com.oxygenxml.positron.plugin.chat.history.MessageTreeModel;
import com.oxygenxml.positron.plugin.chat.history.ValidationErrorMessageNode;
import com.oxygenxml.positron.plugin.chat.utils.ChatCommonUtil;
import com.oxygenxml.positron.plugin.ui.history.StoredObject;
import com.oxygenxml.positron.utilities.action.ActionsUtil;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ActionType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true, allowGetters=false, allowSetters=false)
public class ChatModel
implements StoredObject {
    @JsonIgnore
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM HH:mm");
    @JsonProperty(value="actionDetails")
    private AIActionDetails actionDetails;
    @JsonProperty(value="actionParameters")
    private Map<String, String> actionParameters;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="initialMessages")
    private List<Message> initialMessages = new ArrayList<Message>();
    @JsonProperty(value="tree")
    private MessageTreeModel messagesTree = new MessageTreeModel();
    @JsonProperty(value="index")
    private List<Integer> messagesIndexPath = new ArrayList<Integer>();

    public ChatModel() {
    }

    public ChatModel(AIActionDetails actionDetails, Map<String, String> actionParameters) {
        this.resetActionDetails(actionDetails, actionParameters);
    }

    public void resetActionDetails(AIActionDetails actionDetails, Map<String, String> actionParameters) {
        this.actionDetails = actionDetails;
        this.actionParameters = actionParameters != null ? actionParameters : new HashMap();
    }

    public void addToolCallsMessage(Message msg, String engineModelResponse) {
        this.messagesTree.addToolCallMessage(msg, this.messagesIndexPath, engineModelResponse);
    }

    public void addToolCallDescription(String description) {
        this.messagesTree.addToolCallDescriptionOnToolMessage(this.messagesIndexPath, description);
    }

    public void addToolCallError(String error) {
        this.messagesTree.addToolCallError(this.messagesIndexPath, error);
    }

    public void addToolCallsResponseMessage(ToolCallResponseMessage msg) {
        this.messagesTree.addToolResponseOnToolMessage(this.messagesIndexPath, msg);
    }

    public void addMessage(Message msg, String engineModelResponse) {
        this.messagesTree.addMessage(msg, this.messagesIndexPath, engineModelResponse);
        if (this.name == null) {
            if (this.isUserInitiative()) {
                MessageNode messageNode = this.messagesTree.getMessagesPath(this.messagesIndexPath).get(0);
                Message msgContent = messageNode.getMessage();
                if (msgContent != null && msgContent.getContent() != null && !msgContent.getContent().isEmpty()) {
                    List content = msgContent.getContent();
                    this.description = ((MessageTextContent)content.get(0)).getText().trim();
                    this.description = MessageDescriptionUtil.computeHumanReadableDescription(this.description);
                    this.name = TextUtils.filterMessageStatusText((String)this.description);
                }
            } else {
                String actionShortDesc = this.actionDetails.getShortDescription();
                String actionLongDesc = this.actionDetails.getDescription();
                String date = " - " + this.dateFormat.format(new Date());
                if ("action.translate.to.lang".equals(this.actionDetails.getId())) {
                    Optional<GenericTranslationChatStartMessage> genericTranslationMsg = ChatCommonUtil.getGenericTranslationChatStartMessage(this.actionDetails);
                    if (genericTranslationMsg.isPresent()) {
                        GenericTranslationChatStartMessage startMsgDetails = genericTranslationMsg.get();
                        actionShortDesc = startMsgDetails.getShortDescription();
                        actionLongDesc = startMsgDetails.getLongDescription();
                    }
                } else if (ActionsUtil.isNewFileWithAIPseudoaction((String)this.actionDetails.getId())) {
                    String imposedFirstMessage = ((MessageTextContent)msg.getContent().get(0)).getText().trim();
                    this.name = TextUtils.filterMessageStatusText((String)imposedFirstMessage) + date;
                    this.description = MessageDescriptionUtil.computeHumanReadableDescription(imposedFirstMessage);
                }
                if (this.name == null) {
                    this.name = TextUtils.filterMessageStatusText((String)(actionShortDesc + date));
                    this.description = actionLongDesc;
                }
            }
        }
    }

    public void editMessage(List<Integer> pathToNode, Message editedMessage, String engineModelResponse) {
        this.messagesIndexPath = this.messagesTree.editNode(pathToNode, editedMessage, engineModelResponse);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    public boolean isUserInitiative() {
        return this.actionDetails.getComputedType() == ActionType.CHAT_MODE;
    }

    @JsonIgnore
    public boolean shouldEnhanceWithChatTools() {
        ArrayList<Message> plainMessages = new ArrayList<Message>();
        for (MessageNode node : this.getChatMessages()) {
            plainMessages.add(node.getMessage());
        }
        return ChatToolsEnhancer.shouldEnhanceWithChatTools((AIActionDetails)this.actionDetails, plainMessages);
    }

    @JsonIgnore
    public AIActionDetails getActionDetailsWithChatModeEnhancement(AIActionDetails chatActionDetails) {
        if (chatActionDetails == null) {
            return this.actionDetails;
        }
        return ChatToolsEnhancer.enhanceActionWithChatTools((AIActionDetails)this.actionDetails, (AIActionDetails)chatActionDetails);
    }

    @JsonIgnore
    public List<MessageNode> getChatMessages() {
        return new ArrayList<MessageNode>(this.messagesTree.getMessagesPath(this.messagesIndexPath));
    }

    @JsonIgnore
    public List<MessageNode> getChatMessages(List<Integer> conversationIndexPath) {
        return new ArrayList<MessageNode>(this.messagesTree.getMessagesPath(conversationIndexPath));
    }

    public List<Message> getInitialMessages() {
        return new ArrayList<Message>(this.initialMessages);
    }

    public void addInitialMessages(List<Message> initialMessages) {
        this.initialMessages.addAll(initialMessages);
    }

    public AIActionDetails getActionDetails() {
        return this.actionDetails;
    }

    public List<Integer> getMessagesIndexPath() {
        return new ArrayList<Integer>(this.messagesIndexPath);
    }

    public Map<String, String> getActionParameters() {
        return Optional.ofNullable(this.actionParameters).map(HashMap::new).orElse(new HashMap());
    }

    public void setActionParameters(Map<String, String> actionParameters) {
        this.actionParameters = actionParameters != null ? actionParameters : new HashMap();
    }

    public boolean isSameInteraction(ChatModel otherModel) {
        return this.messagesTree.getConversationId() == otherModel.messagesTree.getConversationId();
    }

    @JsonIgnore
    public boolean isConversationAvailableFor(List<Integer> path) {
        return this.messagesTree.isConversationAvailableFor(path);
    }

    @JsonIgnore
    public List<MessageNode> findRightMostConversationFor(List<Integer> startPath) {
        MessageTreeConversation conversation = this.messagesTree.findNewestConversation(startPath);
        this.messagesIndexPath = conversation.getMessagesIndexPath();
        return conversation.getMessages();
    }

    public int getMaxLevelIndex(List<Integer> conversationIndexPath) {
        return this.messagesTree.getMaxLevelIndex(conversationIndexPath);
    }

    public void addValidationErrorMessage(ValidationErrorMessageNode validationErrorNode) {
        this.messagesIndexPath = this.messagesTree.addValidationErrorNode(this.messagesIndexPath, validationErrorNode);
    }

    public void addCorrectionMessage(CorrectionMessageNode correctionNode) {
        this.messagesIndexPath = this.messagesTree.addCorrectionNode(this.messagesIndexPath, correctionNode);
    }

    public void addMaskingNotificationMessage(MaskingNotificationMessageNode maskingNode) {
        this.messagesIndexPath = this.messagesTree.addMaskingNotificationNode(this.messagesIndexPath, maskingNode);
    }

    @JsonIgnore
    public List<MessageNode> filterValidationRelatedMessages(List<MessageNode> messages) {
        ArrayList<MessageNode> filteredMessages = new ArrayList<MessageNode>();
        for (int idx = messages.size() - 1; idx >= 0; --idx) {
            boolean isNextAssistant;
            MessageNode msg = messages.get(idx);
            filteredMessages.add(msg);
            if (!(msg instanceof CorrectionMessageNode)) continue;
            int validationMessageIDX = idx - 1;
            int assistantMessageIDX = idx - 2;
            boolean isNextValidation = validationMessageIDX >= 0 && messages.get(validationMessageIDX) instanceof ValidationErrorMessageNode;
            boolean bl = isNextAssistant = assistantMessageIDX >= 0 && messages.get(assistantMessageIDX).getMessage() != null && messages.get(assistantMessageIDX).getMessage().getRole().equals((Object)RoleType.ASSISTANT);
            if (isNextValidation && isNextAssistant) {
                idx = assistantMessageIDX;
                continue;
            }
            if (!isNextValidation) continue;
            idx = validationMessageIDX;
        }
        Collections.reverse(filteredMessages);
        return filteredMessages;
    }

    @JsonIgnore
    public MessageNode getLastMessageNodeInPath(List<Integer> pathToNode) {
        return this.messagesTree.getLastMessageInPath(pathToNode);
    }

    public String toString() {
        return "ChatModel(dateFormat=" + this.dateFormat + ", actionDetails=" + this.getActionDetails() + ", actionParameters=" + this.getActionParameters() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", initialMessages=" + this.getInitialMessages() + ", messagesTree=" + this.messagesTree + ", messagesIndexPath=" + this.getMessagesIndexPath() + ")";
    }
}

