/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.plugin.chat.ButtonsPanel;
import com.oxygenxml.positron.plugin.chat.ChatModeInfoPanel;
import com.oxygenxml.positron.plugin.chat.ChatModesUtil;
import com.oxygenxml.positron.plugin.chat.ChatPanelMessagesVisibilityListener;
import com.oxygenxml.positron.plugin.chat.ChatStartAndModesInteractor;
import com.oxygenxml.positron.plugin.chat.UserInputTextHandler;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.ui.PositronCardLayout;
import com.oxygenxml.positron.plugin.util.UIUtil;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.awt.Component;
import java.util.concurrent.ExecutionException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class ChatActionsAndConversationCardsComponent
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(ChatActionsAndConversationCardsComponent.class);
    private static final long serialVersionUID = 1L;
    private final PositronCardLayout cardPanelLayout = new PositronCardLayout();
    private static final String BUTTONS_PANEL_ID = "buttonsPanelID";
    private static final String CHAT_MODE_INFO_PANEL_ID = "chatModeInfoPanelID";
    private static final String CONVERSATION_PANEL_ID = "conversationPanelID";
    private ButtonsPanel buttonsPanel;
    private ChatModeInfoPanel chatModeInfoPanel;
    private ChatPanelMessagesVisibilityListener chatPanelMessagesVisibilityListener;
    private CompletionActionsManager completionActionsManager;

    public ChatActionsAndConversationCardsComponent(JPanel conversationPanel, CompletionActionsManager completionActionsManager, ChatStartAndModesInteractor chatStartAndModesProvider, UserInputTextHandler userInputTextHandler) {
        this.completionActionsManager = completionActionsManager;
        this.setLayout(this.cardPanelLayout);
        this.buttonsPanel = new ButtonsPanel(this, completionActionsManager, userInputTextHandler);
        this.chatModeInfoPanel = new ChatModeInfoPanel(completionActionsManager, chatStartAndModesProvider, this::switchToButtonsPanel, userInputTextHandler);
        this.add((Component)this.buttonsPanel, BUTTONS_PANEL_ID);
        this.add((Component)this.chatModeInfoPanel, CHAT_MODE_INFO_PANEL_ID);
        this.add((Component)conversationPanel, CONVERSATION_PANEL_ID);
        this.showStartingChatPanel();
    }

    void showStartingChatPanel() {
        this.displayActionsOrHintsPanelInternal();
        this.notifyMessagesVisibilityListener(false);
    }

    void showConversationPanel() {
        this.cardPanelLayout.show(this, CONVERSATION_PANEL_ID);
        this.notifyMessagesVisibilityListener(true);
    }

    private void notifyMessagesVisibilityListener(boolean areMessagesVisible) {
        if (this.chatPanelMessagesVisibilityListener != null) {
            this.chatPanelMessagesVisibilityListener.messagesVisibilityChanged(areMessagesVisible);
        }
    }

    @VisibleForTesting
    JScrollPane getActionsPanel() {
        return this.buttonsPanel.getScrollPane();
    }

    void updateViewModeIfNecessary() {
        if (!CONVERSATION_PANEL_ID.equals(this.cardPanelLayout.getCurrentVisibleCardId())) {
            this.displayActionsOrHintsPanelInternal();
        }
    }

    private void displayActionsOrHintsPanelInternal() {
        if (this.isShowingActionsAsButtonsChatView()) {
            this.switchToButtonsPanel();
        } else {
            this.switchToChatInfoPanel();
        }
    }

    private void switchToChatInfoPanel() {
        AIActionDetails chatActionDetails;
        block2: {
            chatActionDetails = null;
            try {
                chatActionDetails = ChatModesUtil.obtainChatActionDetails(this.completionActionsManager);
            }
            catch (ExecutionException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)e, (Throwable)e);
            }
        }
        this.chatModeInfoPanel.updateChatMode(chatActionDetails);
        UIUtil.runNowOrLaterOnAWT(() -> this.cardPanelLayout.show(this, CHAT_MODE_INFO_PANEL_ID));
    }

    private void switchToButtonsPanel() {
        this.buttonsPanel.populateButtons();
        UIUtil.runNowOrLaterOnAWT(() -> {
            this.cardPanelLayout.show(this, BUTTONS_PANEL_ID);
            this.buttonsPanel.computeColumns();
        });
    }

    private boolean isShowingActionsAsButtonsChatView() {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWorkspace != null && pluginWorkspace.getOptionsStorage() != null) {
            WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
            return Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.show.actions.as.buttons.chat", String.valueOf(Boolean.FALSE)));
        }
        return false;
    }

    public void setChatPanelMessagesVisibilityListener(ChatPanelMessagesVisibilityListener chatPanelMessagesVisibilityListener) {
        this.chatPanelMessagesVisibilityListener = chatPanelMessagesVisibilityListener;
    }
}

