/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.chat.BaseDetailsDialog;
import com.oxygenxml.positron.plugin.chat.DetailsDialogInterface;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.ToolbarButton;

public abstract class BaseToolDetailsPanel
extends JPanel {
    protected static final Translator TRANSLATOR = Translator.getInstance();
    protected JButton infoButton;
    protected DetailsDialogInterface detailsDialog;

    public BaseToolDetailsPanel() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
        this.createInfoButton();
    }

    protected void createInfoButton() {
        this.infoButton = new ToolbarButton(new AbstractAction(this.getInfoButtonTooltip(), IconsLoader.loadIcon("/images/ToolsInspect.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BaseToolDetailsPanel.this.detailsDialog != null) {
                    BaseToolDetailsPanel.this.showDetailsDialog();
                }
            }
        }, false){

            public JToolTip createToolTip() {
                return OxygenUIComponentsFactory.installMultilineTooltip((JComponent)BaseToolDetailsPanel.this.infoButton);
            }
        };
    }

    protected String getInfoButtonTooltip() {
        return TRANSLATOR.getTranslation("Ai_Function_Calls_Details");
    }

    protected abstract void initDetailsDialogIfNecessary();

    protected void showDetailsDialog() {
        if (this.detailsDialog instanceof BaseDetailsDialog) {
            ((BaseDetailsDialog)((Object)this.detailsDialog)).showDialog();
        }
    }

    protected void updateButtonTooltip() {
        if (this.detailsDialog != null && this.infoButton != null) {
            this.infoButton.setToolTipText(this.getInfoButtonTooltip() + "\n\n" + this.detailsDialog.getDetailsContent());
        }
    }

    protected JButton getInfoButton() {
        return this.infoButton;
    }

    protected DetailsDialogInterface getDetailsDialog() {
        return this.detailsDialog;
    }

    protected GridBagConstraints getInfoButtonConstraints() {
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.weightx = 0.0;
        constr.weighty = 0.0;
        constr.fill = 0;
        constr.anchor = 12;
        return constr;
    }
}

