/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.assist;

import com.oxygenxml.positron.core.actions.types.PositronResolveCommentsAction;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.plugin.EditorChangeListenerBase;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorReviewController;
import ro.sync.ecss.extensions.api.callouts.CalloutActionsProvider;
import ro.sync.ecss.extensions.api.highlights.AuthorPersistentHighlight;
import ro.sync.ecss.extensions.api.review.ReviewActionsProvider;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;

public class ReviewCommentsResolverInstallerListener
extends EditorChangeListenerBase {
    private static final String REMOVE_COMMENTS_ACTION_NAME = "Review_remove_comment";
    private CalloutActionsProvider calloutActProvider;
    private ReviewActionsProvider reviewActProvider;
    private WSAuthorEditorPage lastPage;
    private boolean isEnabled = PositronOptionsUtil.isPositronEnabled();
    private final CompletionActionsManager completionActionsManager;

    public ReviewCommentsResolverInstallerListener(StandalonePluginWorkspace pluginWS, CompletionActionsManager completionActionsManager) {
        super((PluginWorkspace)pluginWS);
        this.completionActionsManager = completionActionsManager;
        completionActionsManager.addReloadActionListener(() -> {
            if (this.isEnabled && this.lastPage != null) {
                this.uninstall(this.lastPage);
                this.install(this.lastPage);
            }
        });
    }

    private void install(WSAuthorEditorPage authorPage) {
        Optional<PositronResolveCommentsAction> resolveCommentsActionOpt = this.completionActionsManager.getHiddenFromSideViewResolveCommentsAction();
        if (resolveCommentsActionOpt.isPresent()) {
            AuthorReviewController reviewController = authorPage.getAuthorAccess().getReviewController();
            this.calloutActProvider = this.createCalloutProvider(authorPage, resolveCommentsActionOpt.get());
            reviewController.getAuthorCalloutsController().addCalloutActionsProvider(this.calloutActProvider);
            this.reviewActProvider = this.createReviewActionsProvider(resolveCommentsActionOpt.get());
            reviewController.getAuthorReviewViewController().addReviewActionsProvider(this.reviewActProvider);
        }
    }

    private ReviewActionsProvider createReviewActionsProvider(final PositronResolveCommentsAction resolveCommentsAction) {
        return new ReviewActionsProvider(){

            public void customizeContextualMenuActions(AuthorAccess authorAccess, final AuthorPersistentHighlight[] selectedHighlights, Object popupMenu) {
                if (popupMenu instanceof JPopupMenu) {
                    JPopupMenu actionsMenu = (JPopupMenu)popupMenu;
                    AbstractAction newAction = new AbstractAction(Translator.getInstance().getTranslation(selectedHighlights.length > 1 ? "AI_Resolve_Comments_Action_Name" : "AI_Resolve_Comment_Action_Name")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            StringBuilder comments = new StringBuilder();
                            for (AuthorPersistentHighlight comm : selectedHighlights) {
                                comments.append(ReviewCommentsResolverInstallerListener.mapToString(comm)).append('\n');
                            }
                            resolveCommentsAction.setCommentsToBeResolved(comments.toString());
                            resolveCommentsAction.actionPerformed(e);
                        }
                    };
                    newAction.putValue("SmallIcon", IconsLoader.loadIcon("/images/DockableFramePositron16.png"));
                    newAction.putValue("ShortDescription", resolveCommentsAction.getActionDetails().getDescription());
                    ReviewCommentsResolverInstallerListener.insertActionAfter(actionsMenu, Translator.getInstance().getTranslation(ReviewCommentsResolverInstallerListener.REMOVE_COMMENTS_ACTION_NAME), newAction);
                }
            }
        };
    }

    private CalloutActionsProvider createCalloutProvider(final WSAuthorEditorPage authorPage, final PositronResolveCommentsAction resolveCommentsAction) {
        return new CalloutActionsProvider(){

            public List<AbstractAction> getActions(AuthorAccess authorAccess, final AuthorPersistentHighlight highlight, List<AbstractAction> defaultActionsList) {
                ArrayList<AbstractAction> menuActions = new ArrayList<AbstractAction>();
                AbstractAction newAction = new AbstractAction(Translator.getInstance().getTranslation("AI_Resolve_Comment_Action_Name")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean isContentFromCommentUnselected;
                        boolean bl = isContentFromCommentUnselected = authorPage.getSelectionStart() > highlight.getStartOffset() || authorPage.getSelectionEnd() < highlight.getEndOffset() + 1;
                        if (isContentFromCommentUnselected) {
                            authorPage.select(highlight.getStartOffset(), highlight.getEndOffset() + 1);
                        }
                        StringBuilder comments = new StringBuilder();
                        comments.append(ReviewCommentsResolverInstallerListener.mapToString(highlight));
                        resolveCommentsAction.setCommentsToBeResolved(comments.toString());
                        resolveCommentsAction.actionPerformed(e);
                    }
                };
                newAction.putValue("SmallIcon", IconsLoader.loadIcon("/images/DockableFramePositron16.png"));
                newAction.putValue("ShortDescription", resolveCommentsAction.getActionDetails().getDescription());
                int position = this.getPositronToInsertAction(defaultActionsList);
                menuActions.addAll(defaultActionsList);
                if (position != -1) {
                    menuActions.add(position, newAction);
                } else {
                    menuActions.add(null);
                    menuActions.add(newAction);
                }
                return menuActions;
            }

            private int getPositronToInsertAction(List<AbstractAction> defaultActionsList) {
                int position = -1;
                for (int i = 0; i < defaultActionsList.size(); ++i) {
                    AbstractAction currentAction = defaultActionsList.get(i);
                    if (currentAction == null || !Objects.equals(Translator.getInstance().getTranslation(ReviewCommentsResolverInstallerListener.REMOVE_COMMENTS_ACTION_NAME), currentAction.getValue("Name"))) continue;
                    position = i + 1;
                    break;
                }
                return position;
            }
        };
    }

    private void uninstall(WSAuthorEditorPage authorPage) {
        AuthorReviewController reviewController = authorPage.getAuthorAccess().getReviewController();
        if (this.reviewActProvider != null) {
            reviewController.getAuthorReviewViewController().removeReviewActionsProvider(this.reviewActProvider);
            this.reviewActProvider = null;
        }
        if (this.calloutActProvider != null) {
            reviewController.getAuthorCalloutsController().removeCalloutActionsProvider(this.calloutActProvider);
            this.calloutActProvider = null;
        }
    }

    private static String mapToString(AuthorPersistentHighlight highlight) {
        StringBuilder ret = new StringBuilder();
        if (highlight.getType() != AuthorPersistentHighlight.PersistentHighlightType.CUSTOM_HIGHLIGHT) {
            String authorComment = highlight.getProperty("comment");
            if (authorComment != null && authorComment.length() > 0) {
                ret.append("Comment:").append(authorComment).append("\n");
            }
        } else {
            ret.append(highlight);
        }
        return ret.toString();
    }

    private static void insertActionAfter(JPopupMenu popupMenu, String actionName, AbstractAction newAction) {
        int indexToInsert = -1;
        for (int i = 0; i < popupMenu.getComponentCount(); ++i) {
            JMenuItem menuItem;
            if (!(popupMenu.getComponent(i) instanceof JMenuItem) || !actionName.equals((menuItem = (JMenuItem)popupMenu.getComponent(i)).getActionCommand())) continue;
            indexToInsert = i + 1;
            break;
        }
        if (indexToInsert != -1) {
            popupMenu.insert(new JMenuItem(newAction), indexToInsert);
        } else {
            popupMenu.addSeparator();
            popupMenu.add(newAction);
        }
    }

    @Override
    protected void doHook(WSAuthorEditorPage authorPage) {
        this.lastPage = authorPage;
        if (this.isEnabled) {
            this.install(authorPage);
        }
    }

    @Override
    protected void doHook(WSTextEditorPage hookedPage) {
    }

    @Override
    protected void doUnhook(WSAuthorEditorPage authorPage) {
        this.lastPage = null;
        if (this.isEnabled) {
            this.uninstall(authorPage);
        }
    }

    @Override
    protected void doUnhook(WSTextEditorPage hookedPage) {
    }

    public void disableInstaller() {
        this.isEnabled = false;
        if (this.lastPage != null) {
            this.uninstall(this.lastPage);
        }
    }

    public void enableInstaller() {
        this.isEnabled = true;
        if (this.lastPage != null) {
            this.install(this.lastPage);
        }
    }
}

