/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.assist;

import com.oxygenxml.positron.core.AICompletionDetailsProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.chat.UserInputTextHandler;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.KeyboardUtilities;
import com.oxygenxml.positron.plugin.util.RecordButtonUtil;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.util.ColorTheme;

public class InplacePromptDialog
extends JDialog {
    private static final int INSTRUCTIONS_AREA_MAX_ROWS_BEFORE_SCROLL_APPEARS = 10;
    private static final int INSTRUCTIONS_SCROLL_PANE_PREF_WIDTH = 400;
    private static final String FOCUS_OWNER_PROP_NAME = "focusOwner";
    public static final int RESULT_CANCEL = 0;
    public static final int RESULT_OK = 1;
    private int result = 0;
    private JTextArea instructionsTextArea;
    private WSTextBasedEditorPage editorPage;
    private JScrollPane instructionsScrollPane;
    private AICompletionDetailsProvider aiCompletionProvider;
    private JButton recordMicButton;
    private PropertyChangeListener focusComponentListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() instanceof Component) {
                Component focusedComp = (Component)evt.getNewValue();
                if (InplacePromptDialog.this.isVisible() && !UIUtil.isDescendingFromRootPane(InplacePromptDialog.this.getRootPane(), focusedComp)) {
                    InplacePromptDialog.this.doCancel();
                }
            }
        }
    };
    private ComponentListener dialogComponentListener = new ComponentAdapter(){

        @Override
        public void componentShown(ComponentEvent e) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(InplacePromptDialog.FOCUS_OWNER_PROP_NAME, InplacePromptDialog.this.focusComponentListener);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(InplacePromptDialog.FOCUS_OWNER_PROP_NAME, InplacePromptDialog.this.focusComponentListener);
        }
    };

    public InplacePromptDialog(WSTextBasedEditorPage editorPage, AICompletionDetailsProvider aiCompletionProvider) {
        super((JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame(), Translator.getInstance().getTranslation("Rewrite_content"), false);
        this.editorPage = editorPage;
        this.aiCompletionProvider = aiCompletionProvider;
        this.registerEscForCanceling();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                InplacePromptDialog.this.doCancel();
            }
        });
        ColorTheme colorTheme = PluginWorkspaceProvider.getPluginWorkspace().getColorTheme();
        Color borderColor = Color.BLACK;
        if (colorTheme.isDarkTheme()) {
            borderColor = new JTextField().getSelectionColor();
        }
        this.getRootPane().setBorder(BorderFactory.createLineBorder(borderColor, 1));
        this.setUndecorated(true);
        this.createAndAddMainPanel();
        this.pack();
    }

    private void registerEscForCanceling() {
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InplacePromptDialog.this.doCancel();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), cancelAction);
        this.getRootPane().getActionMap().put(cancelAction, cancelAction);
    }

    private void createAndAddMainPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.instructionsTextArea = OxygenUIComponentsFactory.createTextArea(null);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setWrapStyleWord(true);
        this.instructionsTextArea.getAccessibleContext().setAccessibleDescription("Provide instructions for the AI in regards to the selected text in the editor.");
        KeyboardUtilities.enableTabAndShiftTabFocusTraversal(this.instructionsTextArea);
        this.instructionsTextArea.setPreferredSize(new Dimension(400, this.instructionsTextArea.getPreferredSize().height));
        this.instructionsScrollPane = UIUtil.createScrollPane(this.instructionsTextArea, 20, 31);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 16;
        mainPanel.add((Component)this.instructionsScrollPane, gbc);
        this.recordMicButton = RecordButtonUtil.createRecordMicButton(this.createUserInputTextHandler(), () -> this.aiCompletionProvider);
        RecordButtonUtil.reconfigureRecordMicButtonVisibility(this.recordMicButton, () -> this.aiCompletionProvider);
        ++gbc.gridx;
        gbc.fill = 0;
        gbc.anchor = 14;
        gbc.insets.left = 5;
        mainPanel.add((Component)this.recordMicButton, gbc);
        AbstractAction sendAction = new AbstractAction(Translator.getInstance().getTranslation("Send"), IconsLoader.loadIcon("/images/Send16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                InplacePromptDialog.this.result = 1;
                InplacePromptDialog.this.dispose();
            }
        };
        final JButton sendButton = OxygenUIComponentsFactory.createToolbarButton((Action)sendAction, (boolean)false);
        sendButton.setEnabled(false);
        KeyboardUtilities.setSubmitAndNewlineShortcuts(this.instructionsTextArea, sendAction);
        this.getRootPane().setDefaultButton(sendButton);
        ++gbc.gridx;
        gbc.fill = 0;
        gbc.anchor = 14;
        gbc.insets.left = 5;
        mainPanel.add((Component)sendButton, gbc);
        this.instructionsTextArea.getDocument().addDocumentListener(new DocumentListener(){

            private void updateUI() {
                SwingUtilities.invokeLater(() -> {
                    sendButton.setEnabled(!InplacePromptDialog.this.getUserInstructions().isBlank());
                    InplacePromptDialog.this.adjustTextAreaHeight();
                });
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateUI();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateUI();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    private UserInputTextHandler createUserInputTextHandler() {
        return new UserInputTextHandler(){

            @Override
            public void setText(String text) {
                InplacePromptDialog.this.instructionsTextArea.setText(text);
            }

            @Override
            public void onTextUpdate(Runnable onTextUpdate) {
            }

            @Override
            public void insertTextAtCurrentPosition(String text) {
                InplacePromptDialog.this.instructionsTextArea.replaceSelection(text);
            }

            @Override
            public String getText() {
                return InplacePromptDialog.this.instructionsTextArea.getText();
            }

            @Override
            public void submitToAI() {
            }

            @Override
            public String getPlainTextContentWithAttachmentsExpanded() {
                return this.getText();
            }

            @Override
            public void removeText(int start, int end) {
                try {
                    InplacePromptDialog.this.instructionsTextArea.getDocument().remove(start, end - start);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void clearAll() {
                this.setText("");
            }

            @Override
            public boolean isEditable() {
                return InplacePromptDialog.this.instructionsTextArea.isEditable();
            }

            @Override
            public void insertURL(URL file) {
                this.insertTextAtCurrentPosition("${attach(" + file + ")}");
            }

            @Override
            public String getUnreferencedAttachmentsWithMarkerToAddToModel() {
                return null;
            }

            @Override
            public void updateReferencesWhenSelectionChanges() {
            }
        };
    }

    private void adjustTextAreaHeight() {
        int textAreaNeededLines = this.calculateInstructionsTextAreaLines();
        int lineHeight = this.instructionsTextArea.getFontMetrics(this.instructionsTextArea.getFont()).getHeight();
        if (textAreaNeededLines < 10) {
            this.setInstructionsAreaPreferredHeightForNumberOfLines(textAreaNeededLines, lineHeight);
        } else {
            int textAreaHeightInRows = this.instructionsTextArea.getRows();
            if (textAreaHeightInRows < 10) {
                this.setInstructionAreaScrollPanePreferredHeight(lineHeight);
            }
            this.instructionsTextArea.setRows(textAreaNeededLines);
        }
        this.instructionsTextArea.revalidate();
    }

    private int calculateInstructionsTextAreaLines() {
        View view = this.instructionsTextArea.getUI().getRootView(this.instructionsTextArea);
        float preferredHeight = view.getPreferredSpan(1);
        int lineHeight = this.instructionsTextArea.getFontMetrics(this.instructionsTextArea.getFont()).getHeight();
        return (int)Math.ceil(preferredHeight / (float)lineHeight);
    }

    private void setInstructionsAreaPreferredHeightForNumberOfLines(int lines, int lineHeight) {
        int preferredHeight = lineHeight * lines;
        Dimension preferredSize = new Dimension(this.instructionsTextArea.getWidth(), preferredHeight);
        this.instructionsTextArea.setRows(lines);
        this.instructionsTextArea.setPreferredSize(preferredSize);
        this.pack();
    }

    private void setInstructionAreaScrollPanePreferredHeight(int lineHeight) {
        int preferredHeight = lineHeight * 10;
        Dimension preferredSize = new Dimension(this.instructionsScrollPane.getWidth(), preferredHeight);
        this.instructionsScrollPane.setPreferredSize(preferredSize);
        this.pack();
    }

    private void doCancel() {
        this.result = 0;
        this.dispose();
    }

    public int getResult() {
        return this.result;
    }

    public String getUserInstructions() {
        return this.instructionsTextArea.getText().trim();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.addComponentListener(this.dialogComponentListener);
            if (this.editorPage instanceof WSAuthorEditorPage) {
                this.handleAuthorPageVisibility((WSAuthorEditorPage)this.editorPage);
            } else if (this.editorPage instanceof WSTextEditorPage) {
                this.handleTextPageVisibility((WSTextEditorPage)this.editorPage);
            }
        } else {
            this.removeComponentListener(this.dialogComponentListener);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(FOCUS_OWNER_PROP_NAME, this.focusComponentListener);
        }
        super.setVisible(visible);
    }

    private void handleAuthorPageVisibility(WSAuthorEditorPage authorPage) {
        JComponent authComp = (JComponent)authorPage.getAuthorComponent();
        boolean isEntireContentSelected = authorPage.hasSelection() && authorPage.getSelectionStart() == 1 && authorPage.getSelectionEnd() == authorPage.getDocumentController().getAuthorDocumentNode().getLength() - 1;
        int caretOffset = authorPage.getCaretOffset();
        if (isEntireContentSelected || caretOffset == -1) {
            this.setDialogLocationInPageVisibleRect(authComp);
        } else {
            ro.sync.exml.view.graphics.Rectangle caretRect = authorPage.modelToViewRectangle(caretOffset);
            authorPage.scrollToRectangle(caretRect);
            this.setDialogLocationRelativeToCaret(authComp, caretRect);
        }
    }

    private void handleTextPageVisibility(WSTextEditorPage textPage) {
        JTextComponent textComponent = (JTextComponent)textPage.getTextComponent();
        textPage.scrollCaretToVisible();
        int caretOffset = textPage.getCaretOffset();
        if (caretOffset == -1) {
            this.setDialogLocationInPageVisibleRect(textComponent);
        } else {
            this.setDialogLocationRelativeToCaret(textComponent, textPage.modelToViewRectangle(caretOffset));
        }
    }

    private void setDialogLocationInPageVisibleRect(JComponent comp) {
        Rectangle visibleRect = comp.getVisibleRect();
        Point location = new Point(visibleRect.x + visibleRect.width / 3, visibleRect.y + visibleRect.height / 3);
        SwingUtilities.convertPointToScreen(location, comp);
        this.setLocation(location);
    }

    private void setDialogLocationRelativeToCaret(JComponent comp, ro.sync.exml.view.graphics.Rectangle caretRect) {
        Point dialogLocation = new Point(caretRect.x, caretRect.y + caretRect.height);
        SwingUtilities.convertPointToScreen(dialogLocation, comp);
        int dialogWidth = this.getWidth();
        int dialogRightEdge = dialogLocation.x + dialogWidth;
        Point dialogScreenLocation = new Point(comp.getX(), comp.getY());
        SwingUtilities.convertPointToScreen(dialogScreenLocation, comp);
        int compRightEdge = dialogScreenLocation.x + comp.getWidth();
        if (dialogRightEdge > compRightEdge) {
            dialogLocation.x = compRightEdge - dialogWidth;
        }
        this.setLocation(dialogLocation);
    }
}

