/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.assist;

import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.InputContext;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;

public class AuthorSelectionUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)AuthorSelectionUtil.class.getName());

    private AuthorSelectionUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static void prepareSelection(WSTextBasedEditorPage editorPage, PositronAIActionBase positronAction) {
        AIActionDetails actionDetails = positronAction.getActionDetails();
        if ("action.expand.topic.draft".equals(actionDetails.getId())) {
            WSAuthorEditorPage authorPage = (WSAuthorEditorPage)editorPage;
            AuthorElement rootElement = authorPage.getDocumentController().getAuthorDocumentNode().getRootElement();
            authorPage.select(rootElement.getStartOffset(), rootElement.getEndOffset() + 1);
        } else {
            InputContext context = actionDetails.getInputContext();
            if (context == InputContext.AUTO_SELECTION_DOCUMENT || "pseudoaction.copilot.rewrite.content.based.on.instructions".equals(actionDetails.getId())) {
                try {
                    AuthorSelectionUtil.selectRelevantContent(editorPage);
                }
                catch (BadLocationException e1) {
                    logger.error((Object)e1, (Throwable)e1);
                }
            }
        }
    }

    public static void selectRelevantContent(WSTextBasedEditorPage editorPage) throws BadLocationException {
        if (!editorPage.hasSelection() && editorPage instanceof WSAuthorEditorPage) {
            AuthorNode currentNode;
            WSAuthorEditorPage authorPage = (WSAuthorEditorPage)editorPage;
            for (currentNode = authorPage.getDocumentController().getNodeAtOffset(authorPage.getCaretOffset()); currentNode != null && authorPage.getStyles(currentNode).isInline(); currentNode = currentNode.getParent()) {
            }
            if (currentNode != null) {
                editorPage.select(currentNode.getStartOffset(), currentNode.getEndOffset() + 1);
            }
        }
    }
}

