/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.PlatformDetector;

public class UndoRedoSupportInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)UndoRedoSupportInstaller.class.getName());

    private UndoRedoSupportInstaller() {
    }

    public static UndoableEdit install(JTextComponent comp) {
        final UndoRedoManager undoRedoManager = new UndoRedoManager();
        Document doc = comp.getDocument();
        doc.addUndoableEditListener(undoRedoManager);
        comp.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (undoRedoManager.canUndo()) {
                    undoRedoManager.undo();
                }
            }
        });
        int modifier = PlatformDetector.isMacOS() ? 256 : 128;
        comp.getInputMap().put(KeyStroke.getKeyStroke(90, modifier), "Undo");
        comp.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (undoRedoManager.canRedo()) {
                    undoRedoManager.redo();
                }
            }
        });
        modifier = PlatformDetector.isMacOS() ? 320 : 128;
        comp.getInputMap().put(KeyStroke.getKeyStroke(PlatformDetector.isMacOS() ? 90 : 89, modifier), "Redo");
        return undoRedoManager;
    }

    private static final class UndoRedoManager
    extends AbstractUndoableEdit
    implements UndoableEditListener {
        String lastEditName = null;
        int lastOffset = -1;
        private ArrayList<UndoableRedoableCompoundEdit> edits = new ArrayList();
        UndoableRedoableCompoundEdit current;
        int pointer = -1;

        private UndoRedoManager() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            block7: {
                UndoableEdit edit = e.getEdit();
                if (edit instanceof AbstractDocument.DefaultDocumentEvent) {
                    try {
                        AbstractDocument.DefaultDocumentEvent event = (AbstractDocument.DefaultDocumentEvent)edit;
                        int start = event.getOffset();
                        int len = event.getLength();
                        String text = "";
                        if ("addition".equals(edit.getPresentationName())) {
                            text = event.getDocument().getText(start, len);
                        }
                        boolean isNeedStart = false;
                        if (this.current == null || this.lastEditName == null || !this.lastEditName.equals(edit.getPresentationName()) || text.contains("\n") && !"deletion".equals(edit.getPresentationName()) || Math.abs(this.lastOffset - start) > 1) {
                            isNeedStart = true;
                        }
                        while (this.pointer < this.edits.size() - 1) {
                            this.edits.remove(this.edits.size() - 1);
                            isNeedStart = true;
                        }
                        if (isNeedStart) {
                            this.createCompoundEdit();
                        }
                        this.current.addEdit(edit);
                        this.lastEditName = edit.getPresentationName();
                        this.lastOffset = start;
                    }
                    catch (BadLocationException e1) {
                        if (!LOGGER.isDebugEnabled()) break block7;
                        LOGGER.debug(e1.getMessage(), (Throwable)e1);
                    }
                }
            }
        }

        public void createCompoundEdit() {
            if (this.current == null || this.current.getLength() > 0) {
                this.current = new UndoableRedoableCompoundEdit();
            }
            this.edits.add(this.current);
            ++this.pointer;
        }

        @Override
        public void undo() {
            if (!this.canUndo()) {
                throw new CannotUndoException();
            }
            UndoableRedoableCompoundEdit u = this.edits.get(this.pointer);
            u.undo();
            --this.pointer;
        }

        @Override
        public void redo() {
            if (!this.canRedo()) {
                throw new CannotUndoException();
            }
            ++this.pointer;
            UndoableRedoableCompoundEdit u = this.edits.get(this.pointer);
            u.redo();
        }

        @Override
        public boolean canUndo() {
            return this.pointer >= 0;
        }

        @Override
        public boolean canRedo() {
            return !this.edits.isEmpty() && this.pointer < this.edits.size() - 1;
        }
    }

    private static final class UndoableRedoableCompoundEdit
    extends CompoundEdit {
        boolean isUnDone = false;

        private UndoableRedoableCompoundEdit() {
        }

        public int getLength() {
            return this.edits.size();
        }

        @Override
        public void undo() {
            super.undo();
            this.isUnDone = true;
        }

        @Override
        public void redo() {
            super.redo();
            this.isUnDone = false;
        }

        @Override
        public boolean canUndo() {
            return !this.edits.isEmpty() && !this.isUnDone;
        }

        @Override
        public boolean canRedo() {
            return !this.edits.isEmpty() && this.isUnDone;
        }
    }
}

