/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.ai.positron.license.exception.InvalidLicenseException;
import com.oxygenxml.positron.core.auth.BrowserOpener;
import com.oxygenxml.positron.core.auth.ConnectionRequestInteractor;
import com.oxygenxml.positron.core.auth.DisconnectionRequestListener;
import com.oxygenxml.positron.core.auth.ReconnectionRequestListener;
import com.oxygenxml.positron.core.auth.ServerAuthenticationManager;
import com.oxygenxml.positron.core.auth.ServerAuthenticationManagerImpl;
import com.oxygenxml.positron.core.auth.exceptions.ServerRequestException;
import com.oxygenxml.positron.core.auth.requests.AuthenticationInfoManager;
import com.oxygenxml.positron.core.auth.requests.RefreshTokenChangedListener;
import com.oxygenxml.positron.core.auth.requests.ServerRequestListener;
import com.oxygenxml.positron.core.auth.requests.ServerUrlChangedListener;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.plugin.AIPositronInfo;
import com.oxygenxml.positron.plugin.AIServerInfoProvider;
import com.oxygenxml.positron.plugin.CustomActionsLoader;
import com.oxygenxml.positron.plugin.EnablePositronController;
import com.oxygenxml.positron.plugin.MenusActionsManager;
import com.oxygenxml.positron.plugin.PositronAssistantPanel;
import com.oxygenxml.positron.plugin.chat.ChatUserInputInteractor;
import com.oxygenxml.positron.plugin.completion.AICompletionProvidersManager;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.license.DirectConnectionLicenseManager;
import com.oxygenxml.positron.plugin.ui.SwingTimer;
import com.oxygenxml.positron.plugin.util.DirectConnectionConfigurationHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.project.ProjectChangeListener;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;
import ro.sync.exml.workspace.api.standalone.ui.Menu;

public class PositronAssistantPanelController
implements CustomActionsLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PositronAssistantPanelController.class.getName());
    private static final Translator TRANSLATOR = Translator.getInstance();
    private final ServerAuthenticationManager authenticationManager;
    private final CompletionActionsManager aiActionsManager;
    private PositronAssistantPanel positronAssistantPanel;
    private AbstractAction disconnectAction;
    private AbstractAction connectAction;
    private AbstractAction cancelConnectionAction;
    private AbstractAction registerAction;
    private AbstractAction myAccountAction;
    private AuthenticationInfoManager authenticationInfoManager;
    private SwingTimer reloadLocalActionsTimer;
    private final DirectConnectionLicenseManager licenseManager = DirectConnectionLicenseManager.getInstance();
    private ProjectChangeListener projectChangeListener;
    private Menu aiActionsMenu;
    private final EnablePositronController enablePositronController;
    private AICompletionProvidersManager aiCompletionProvidersManager;
    private ChatUserInputInteractor chatInteractor;

    public PositronAssistantPanelController(StandalonePluginWorkspace pluginWS, ProxyDetailsProvider proxyProvider, final PositronAssistantPanel positronAssistantPanel, AuthenticationInfoManager authenticationInfoManager, AICompletionProvidersManager aiCompletionProvidersManager, CompletionActionsManager aiActionsManager, final EnablePositronController enablePositronController, ChatUserInputInteractor chatInteractor) {
        this.positronAssistantPanel = positronAssistantPanel;
        this.authenticationInfoManager = authenticationInfoManager;
        this.aiActionsManager = aiActionsManager;
        this.enablePositronController = enablePositronController;
        this.aiCompletionProvidersManager = aiCompletionProvidersManager;
        this.chatInteractor = chatInteractor;
        this.authenticationManager = new ServerAuthenticationManagerImpl(authenticationInfoManager, new BrowserOpener(), proxyProvider);
        authenticationInfoManager.setRefreshTokenListener(new RefreshTokenChangedListener(){

            public void refreshTokenChanged() {
                positronAssistantPanel.updateComponentsStatus();
            }
        });
        this.createReloadCustomActionsTimer();
        authenticationInfoManager.addServerUrlChangedListener(new ServerUrlChangedListener(){

            public void serverUrlChanged() {
                positronAssistantPanel.updateMessageStatus("");
                positronAssistantPanel.updateComponentsStatus();
            }
        });
        this.licenseManager.addDirectConnectionLicenseListener(() -> {
            positronAssistantPanel.updateMessageStatus("");
            positronAssistantPanel.updateComponentsStatus();
            AIServerInfoProvider.getInstance().getModelsManager().loadModels();
            this.loadAiActions(false);
        });
        AIServerInfoProvider.getInstance().getModelsManager().addModelsChangedListener(() -> SwingUtilities.invokeLater(() -> {
            LOGGER.debug("Models changed, updating UI");
            positronAssistantPanel.updateComponentsStatus();
        }));
        pluginWS.getOptionsStorage().addOptionListener(new WSOptionListener("oxygen.positron.plugin.actions.folder"){

            public void optionValueChanged(WSOptionChangedEvent arg0) {
                PositronAssistantPanelController.this.reloadLocalActionsTimer.restart();
            }
        });
        pluginWS.getOptionsStorage().addOptionListener(new WSOptionListener("oxygen.positron.plugin.load.default.actions"){

            public void optionValueChanged(WSOptionChangedEvent arg0) {
                PositronAssistantPanelController.this.reloadLocalActionsTimer.stop();
                PositronAssistantPanelController.this.loadAiActions(false);
            }
        });
        pluginWS.getOptionsStorage().addOptionListener(new WSOptionListener("oxygen.positron.plugin.ignore.actions"){

            public void optionValueChanged(WSOptionChangedEvent arg0) {
                PositronAssistantPanelController.this.reloadLocalActionsTimer.stop();
                PositronAssistantPanelController.this.loadAiActions(false);
            }
        });
        pluginWS.getOptionsStorage().addOptionListener(new WSOptionListener("oxygen.positron.plugin.enable.positron"){

            public void optionValueChanged(WSOptionChangedEvent event) {
                enablePositronController.reconfigurePositronUIComponents();
            }
        });
        pluginWS.getProjectManager().addProjectChangeListener(this.getProjectChangeListener());
    }

    public AbstractAction getDisconnectAction() {
        if (this.disconnectAction == null) {
            this.disconnectAction = new AbstractAction(TRANSLATOR.getTranslation("Disconnect")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PositronAssistantPanelController.this.authenticationManager.disconnect(new DisconnectionRequestListener(){

                        public void requestFailed(ServerRequestException ex) {
                            try {
                                SwingUtilities.invokeAndWait(() -> PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus(TRANSLATOR.getTranslation("Disconnection_failed") + " " + ex.getMessage()));
                            }
                            catch (InterruptedException | InvocationTargetException e) {
                                LOGGER.debug(e.getMessage(), (Throwable)e);
                                Thread.currentThread().interrupt();
                            }
                        }

                        public void requestEnded() {
                            PositronAssistantPanelController.this.connectOrDisconnectRequestEnded();
                        }

                        public void beforeRequestStarted() {
                            try {
                                SwingUtilities.invokeAndWait(() -> PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus(MessageFormat.format(TRANSLATOR.getTranslation("Disconnecting_from"), "Oxygen AI Positron")));
                            }
                            catch (InterruptedException | InvocationTargetException e) {
                                LOGGER.debug(e.getMessage(), (Throwable)e);
                                Thread.currentThread().interrupt();
                                Thread.currentThread().interrupt();
                            }
                        }

                        public void disconnected() {
                            AIServerInfoProvider.getInstance().getModelsManager().loadModels();
                            try {
                                SwingUtilities.invokeAndWait(() -> PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus(MessageFormat.format(TRANSLATOR.getTranslation("Disconnected_from"), "Oxygen AI Positron")));
                            }
                            catch (InterruptedException | InvocationTargetException e) {
                                LOGGER.debug(e.getMessage(), (Throwable)e);
                                Thread.currentThread().interrupt();
                            }
                        }
                    });
                }
            };
        }
        return this.disconnectAction;
    }

    public AbstractAction getConnectAction() {
        if (this.connectAction == null) {
            this.connectAction = new AbstractAction(TRANSLATOR.getTranslation("Connect") + "..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PositronAssistantPanelController.this.authenticationManager.connect(new ConnectionRequestInteractor(){

                        public void requestFailed(ServerRequestException ex) {
                            try {
                                SwingUtilities.invokeAndWait(() -> PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus(TRANSLATOR.getTranslation("Connection_failed") + ": " + ex.getMessage()));
                                if (ex.isBlockerError()) {
                                    PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus(ex.getMessage(), true);
                                }
                            }
                            catch (InterruptedException | InvocationTargetException e) {
                                LOGGER.debug(e.getMessage(), (Throwable)e);
                                Thread.currentThread().interrupt();
                            }
                        }

                        public void requestEnded() {
                            PositronAssistantPanelController.this.connectOrDisconnectRequestEnded();
                        }

                        public void beforeRequestStarted() {
                            try {
                                SwingUtilities.invokeAndWait(() -> {
                                    PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus(MessageFormat.format(TRANSLATOR.getTranslation("Connecting_to"), "Oxygen AI Positron"));
                                    PositronAssistantPanelController.this.positronAssistantPanel.updateConnectionInProgressStatus();
                                });
                            }
                            catch (InterruptedException | InvocationTargetException e) {
                                LOGGER.debug(e.getMessage(), (Throwable)e);
                                Thread.currentThread().interrupt();
                            }
                        }

                        public void connected(String user) {
                            try {
                                SwingUtilities.invokeAndWait(() -> PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus(MessageFormat.format(TRANSLATOR.getTranslation("Connected_to"), "Oxygen AI Positron")));
                            }
                            catch (InterruptedException | InvocationTargetException e) {
                                LOGGER.debug(e.getMessage(), (Throwable)e);
                                Thread.currentThread().interrupt();
                            }
                            AIServerInfoProvider.getInstance().getModelsManager().loadModels();
                            PositronAssistantPanelController.this.loadAiActions(false);
                        }

                        public void showUserCode(String userCode) {
                            PositronAssistantPanelController.this.positronAssistantPanel.updateConnectionInProgressStatus(userCode);
                        }
                    });
                }
            };
        }
        return this.connectAction;
    }

    public AbstractAction getRegisterDirectConnectionLicenseAction() {
        if (this.registerAction == null) {
            String actionName = TRANSLATOR.getTranslation(DirectConnectionConfigurationHelper.isLicenseForDirectConnectionValid() ? "Update_License_Key" : "Configure_License_Key") + "...";
            this.registerAction = new AbstractAction(actionName){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PositronAssistantPanelController.this.licenseManager.askForLicense();
                }
            };
            this.licenseManager.addDirectConnectionLicenseListener(() -> {
                String newActionName = TRANSLATOR.getTranslation(DirectConnectionConfigurationHelper.isLicenseForDirectConnectionValid() ? "Update_License_Key" : "Configure_License_Key") + "...";
                this.registerAction.putValue("Name", newActionName);
            });
        }
        return this.registerAction;
    }

    private void connectOrDisconnectRequestEnded() {
        try {
            SwingUtilities.invokeAndWait(() -> {
                this.positronAssistantPanel.clearUserCode();
                this.positronAssistantPanel.getChatPanel().clearChat();
                this.positronAssistantPanel.updateComponentsStatus();
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public AbstractAction getCancelConnectionAction() {
        if (this.cancelConnectionAction == null) {
            this.cancelConnectionAction = new AbstractAction(TRANSLATOR.getTranslation("Cancel")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean canceled;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Cancel connecting to server.");
                    }
                    if (canceled = PositronAssistantPanelController.this.authenticationManager.cancelConnection()) {
                        PositronAssistantPanelController.this.positronAssistantPanel.updateComponentsStatus();
                        PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus(TRANSLATOR.getTranslation("Connection_cancelled"));
                    }
                }
            };
        }
        return this.cancelConnectionAction;
    }

    public void refreshConnection() {
        this.authenticationManager.refreshConnectionIfPossible(new ReconnectionRequestListener(){

            public void requestFailed(ServerRequestException ex) {
                try {
                    SwingUtilities.invokeAndWait(() -> PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus(ex.getMessage()));
                }
                catch (InterruptedException | InvocationTargetException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }

            public void requestEnded() {
                PositronAssistantPanelController.this.positronAssistantPanel.setRefreshConnectionInProgressIcon(false);
            }

            public void beforeRequestStarted() {
                PositronAssistantPanelController.this.positronAssistantPanel.setRefreshConnectionInProgressIcon(true);
            }

            public void reconnected(String user) {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        PositronAssistantPanelController.this.positronAssistantPanel.updateComponentsStatus();
                        PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus("");
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                AIServerInfoProvider.getInstance().getModelsManager().loadModels();
                PositronAssistantPanelController.this.loadAiActions(false);
            }

            public void reconnectTokenExpired() {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus(MessageFormat.format(TRANSLATOR.getTranslation("exception_connection_data_not_valid"), "Oxygen AI Positron", AIPositronInfo.PRODUCT_NAME));
                        PositronAssistantPanelController.this.positronAssistantPanel.updateComponentsStatus();
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }

            public void reconnectTokenNotAvailable() {
            }
        }, 2000);
    }

    @VisibleForTesting
    void loadAiActions(boolean shouldRequestOnlyCustomAction) {
        try {
            if (DirectConnectionConfigurationHelper.isDirectConnection()) {
                this.checkDirectConnectionLicense();
            }
            this.loadAiActionsInternal(shouldRequestOnlyCustomAction);
        }
        catch (InvalidLicenseException ex) {
            MenusActionsManager.populateAiMenu(this.aiActionsMenu, Collections.emptyMap(), this.aiCompletionProvidersManager, this.aiActionsManager, this.chatInteractor);
            LOGGER.debug(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void loadAiActionsInternal(boolean shouldRequestOnlyCustomAction) {
        this.aiActionsManager.loadAiActions(new ServerRequestListener(){
            ServerRequestException ex = null;

            public void beforeRequestStarted() {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        PositronAssistantPanelController.this.positronAssistantPanel.setRefreshConnectionInProgressIcon(true);
                        PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus(TRANSLATOR.getTranslation("Loading_ai_actions"));
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }

            public void requestFailed(ServerRequestException ex) {
                this.ex = ex;
            }

            public void requestEnded() {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        PositronAssistantPanelController.this.positronAssistantPanel.setRefreshConnectionInProgressIcon(false);
                        if (this.ex != null) {
                            LOGGER.debug(this.ex.getMessage(), (Throwable)this.ex);
                            String message = MessageFormat.format(TRANSLATOR.getTranslation("Cannot_load_actions_from_ai_service"), "Oxygen AI Positron");
                            PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus(message);
                            if (this.ex.isBlockerError()) {
                                PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus(message + " " + this.ex.getMessage(), true);
                            }
                        } else {
                            PositronAssistantPanelController.this.positronAssistantPanel.updateMessageStatus("");
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }, shouldRequestOnlyCustomAction);
    }

    public void resendVerificationEmail() {
        try {
            this.authenticationManager.resendVerificationEmail();
            this.positronAssistantPanel.updateMessageStatus(TRANSLATOR.getTranslation("Email_sent"));
        }
        catch (ServerRequestException e) {
            this.positronAssistantPanel.updateMessageStatus(e.getMessage());
        }
    }

    public AbstractAction getMyAccountAction() {
        if (this.myAccountAction == null) {
            this.myAccountAction = new AbstractAction(TRANSLATOR.getTranslation("My_account")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new BrowserOpener().openWebpage(PositronAssistantPanelController.this.authenticationInfoManager.getServerUrl() + "/subscriptions");
                }
            };
            this.myAccountAction.putValue("ShortDescription", TRANSLATOR.getTranslation("My_account"));
        }
        return this.myAccountAction;
    }

    public void localFileSaved(URL fileURL) {
        try {
            if (this.aiActionsManager.isAdditionalActionsFile(URLUtil.getAbsoluteFileFromFileUrl((URL)fileURL))) {
                this.reloadLocalActionsTimer.restart();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
    }

    @VisibleForTesting
    ProjectChangeListener getProjectChangeListener() {
        if (this.projectChangeListener == null) {
            this.projectChangeListener = (oldProjURL, newProjURL) -> {
                if (PositronOptionsUtil.isPositronEnabled()) {
                    String actionsFolder = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption("oxygen.positron.plugin.actions.folder", "${pd}/positron-ai-actions");
                    if (actionsFolder.contains("${pd}") && !Equaler.verifyEquals((Object)oldProjURL, (Object)newProjURL)) {
                        this.reloadLocalActionsTimer.restart();
                    }
                    String msg = TRANSLATOR.getTranslation("Review_changes_due_to_project_switch");
                    SwingUtilities.invokeLater(() -> this.positronAssistantPanel.getChatPanel().clearChat(msg));
                }
                this.enablePositronController.reconfigurePositronUIComponents();
            };
        }
        return this.projectChangeListener;
    }

    @VisibleForTesting
    void createReloadCustomActionsTimer() {
        this.reloadLocalActionsTimer = new SwingTimer(400);
        this.reloadLocalActionsTimer.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PositronAssistantPanelController.this.loadAiActions(true);
            }
        });
    }

    public void checkDirectConnectionLicense() throws InvalidLicenseException {
        this.licenseManager.checkDirectConnectionLicense();
    }

    @Override
    public void loadCustomActions() {
        this.loadAiActions(true);
    }

    public void forceLoadAllAiActions() {
        this.loadAiActions(false);
    }

    public void setAiActionsMenuBar(Menu aiActionsMenu) {
        this.aiActionsMenu = aiActionsMenu;
    }

    public void addDisabledPositronPluginToolMenu() {
        MenusActionsManager.populateDisabledPositronMenu(this.aiActionsMenu);
    }

    public boolean isPositronServiceUserConnected() {
        return this.authenticationInfoManager.isConnected();
    }
}

