/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin;

import com.oxygenxml.ai.positron.license.exception.InvalidLicenseException;
import com.oxygenxml.positron.actions.AIActionsPanel;
import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.connection.ui.ChoosePositronDistributionPanel;
import com.oxygenxml.positron.connection.ui.EmailNotVerifiedPanel;
import com.oxygenxml.positron.connection.ui.WaitingForConfirmationPanel;
import com.oxygenxml.positron.connector.AIConnectorConfigsManager;
import com.oxygenxml.positron.connector.AIConnectorConfiguration;
import com.oxygenxml.positron.connector.ConnectorConfigurationsPO;
import com.oxygenxml.positron.core.actions.MessagePresenter;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.auth.data.Auth0User;
import com.oxygenxml.positron.core.auth.requests.AuthenticationInfoManager;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.engines.IEnginesManager;
import com.oxygenxml.positron.core.interactions.ContentInserter;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.interactions.DocumentDetailsProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.plugin.EnablePositronController;
import com.oxygenxml.positron.plugin.ModelsUIUtil;
import com.oxygenxml.positron.plugin.OperationProgressPresenterImpl;
import com.oxygenxml.positron.plugin.PositronAssistantPanelController;
import com.oxygenxml.positron.plugin.SAMessagePresenter;
import com.oxygenxml.positron.plugin.chat.ChatConnectionPanelListener;
import com.oxygenxml.positron.plugin.chat.ChatModel;
import com.oxygenxml.positron.plugin.chat.ChatPanel;
import com.oxygenxml.positron.plugin.completion.AICompletionProvidersManager;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.completion.CompletionImplementationProvider;
import com.oxygenxml.positron.plugin.license.DirectConnectionLicenseManager;
import com.oxygenxml.positron.plugin.preferences.OpenPreferencesPageAction;
import com.oxygenxml.positron.plugin.recordexamples.InstructionsSaver;
import com.oxygenxml.positron.plugin.ui.MultilineLabel;
import com.oxygenxml.positron.plugin.ui.PositronScrollPane;
import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import com.oxygenxml.positron.plugin.ui.history.HistoryComponent;
import com.oxygenxml.positron.plugin.util.AiPositronServiceAccess;
import com.oxygenxml.positron.plugin.util.AiPositronServiceConnectionInfoHelper;
import com.oxygenxml.positron.plugin.util.Colors;
import com.oxygenxml.positron.plugin.util.DirectConnectionConfigurationHelper;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.exml.workspace.api.options.ExternalPersistentObject;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;
import ro.sync.exml.workspace.api.standalone.ui.Menu;
import ro.sync.exml.workspace.api.standalone.ui.SplitMenuButton;

public class PositronAssistantPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(PositronAssistantPanel.class);
    private static final Translator TRANSLATOR = Translator.getInstance();
    private final OperationProgressPresenterImpl operationsStatusPresenter;
    protected AIActionsPanel openAIActionsPanel;
    private AuthenticationInfoManager authenticationInfoManager;
    private SplitMenuButton userDropDownButton;
    private SplitMenuButton aiModelsBtn;
    private final JLabel refreshConnectionInProgressIcon = new JLabel(IconsLoader.loadAnimatedIcon("/images/Spinner.gif"));
    private static final String AI_ACTIONS_PANEL_ID = "aiActionsPanelID";
    private static final String CONNECTION_INFO_PANEL_ID = "connectionInfoPanelID";
    private static final String DIRECT_CONNECTION_INFO_PANEL_ID = "directConnectionInfoPanelID";
    private static final String CONNECTION_IN_PROGRESS_PANEL_ID = "connectionInProgressPanelID";
    private static final String EMAIL_NOT_VERIFIED_PANEL_ID = "emailNotVerifiedPanelID";
    private EmailNotVerifiedPanel emailNotValidatedPanel;
    private final CardLayout cardPanelLayout = new CardLayout();
    private JPanel cardPanel = new JPanel(this.cardPanelLayout);
    private WaitingForConfirmationPanel connectionInProgress;
    protected PositronAssistantPanelController controller;
    private final CompletionActionsManager completionActionsManager;
    private ChatPanel chatPanel;
    private final MessagePresenter statusPresenter;
    private List<Component> actionToolbarComponents = new ArrayList<Component>();

    public PositronAssistantPanel(StandalonePluginWorkspace pluginWS, AuthenticationInfoManager authenticationInfoManager, ProxyDetailsProvider proxyProvider, CompletionActionsManager actionsManager, OperationProgressPresenterImpl operationsStatusPresenter, ChatPanel chatPanel, EnablePositronController enablePositronController, AICompletionProvidersManager aiCompletionProviderManager) {
        this.authenticationInfoManager = authenticationInfoManager;
        this.operationsStatusPresenter = operationsStatusPresenter;
        this.statusPresenter = new SAMessagePresenter(operationsStatusPresenter);
        this.completionActionsManager = actionsManager;
        InstructionsSaver instructionsSaver = new InstructionsSaver(this::getAssistantController, chatPanel.getFavoritesManager(), () -> chatPanel);
        this.controller = new PositronAssistantPanelController(pluginWS, proxyProvider, this, authenticationInfoManager, aiCompletionProviderManager, this.completionActionsManager, enablePositronController, chatPanel);
        AiPositronServiceConnectionInfoHelper.getInstance().setController(this.controller);
        this.chatPanel = chatPanel;
        this.chatPanel.initializeUI(actionsManager);
        this.chatPanel.setOnChatClearedListener(() -> this.updateMessageStatus(""));
        this.openAIActionsPanel = new AIActionsPanel(this.completionActionsManager, pluginWS, instructionsSaver, chatPanel, aiCompletionProviderManager, chatPanel);
        pluginWS.getOptionsStorage().addOptionListener(new WSOptionListener("oxygen.positron.plugin.enable.positron"){

            public void optionValueChanged(WSOptionChangedEvent event) {
                PositronAssistantPanel.this.reconfigureLayout();
            }
        });
        this.reconfigureLayout();
        if (AiPositronServiceAccess.getInstance().hasAccessToAiPositronService() && AiPositronServiceAccess.getInstance().isAiPositronServiceConnectionEnabledFromAiServicePreferences()) {
            this.controller.refreshConnection();
        }
        this.setFocusable(false);
        this.addListenersToUpdateEngine(pluginWS);
        this.chatPanel.setChatConnectionPanelListener(new ChatConnectionPanelListener(){

            @Override
            public void switchToConnectToPositronServicePanel() {
                PositronAssistantPanel.this.updateComponentsStatus();
            }
        });
        final WSOptionsStorage optionsStorage = pluginWS.getOptionsStorage();
        optionsStorage.addOptionListener(new WSOptionListener("oxygen.positron.plugin.enable.positron.service"){

            public void optionValueChanged(WSOptionChangedEvent event) {
                List configurations;
                AIConnectorConfiguration currentConfiguration;
                Object val = event.getNewValueObject();
                boolean positronServiceEnabled = Boolean.parseBoolean((String)val);
                if (!positronServiceEnabled && (currentConfiguration = AIConnectorConfigsManager.getInstance().getCurrentConfiguration()) == null && !(configurations = AIConnectorConfigsManager.getInstance().getConfigurations()).isEmpty()) {
                    AIConnectorConfiguration configuration = (AIConnectorConfiguration)configurations.get(0);
                    ConnectorConfigurationsPO connectorConfigurations = (ConnectorConfigurationsPO)optionsStorage.getPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)new ConnectorConfigurationsPO());
                    connectorConfigurations.setCurrentConfigurationId(configuration.getConfigurationId());
                    optionsStorage.setPersistentObjectOption("oxygen.positron.plugin.connector.configurations", (ExternalPersistentObject)connectorConfigurations);
                }
                PositronAssistantPanel.this.updateComponentsStatus();
            }
        });
        this.cardPanel.setBackground(ThemeColorProvider.getInstance().getBackgroundColor());
    }

    private void reconfigureLayout() {
        this.removeAll();
        if (PositronOptionsUtil.isPositronEnabled()) {
            this.layoutPositronUI();
        } else {
            this.addPositronDeactivationExplanation();
        }
        this.revalidate();
        this.repaint();
    }

    private void addPositronDeactivationExplanation() {
        this.setLayout(new GridBagLayout());
        this.setBackground(ThemeColorProvider.getInstance().getBackgroundColor());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 5, 0, 3);
        constraints.fill = 2;
        constraints.anchor = 18;
        this.add((Component)new MultilineLabel(Translator.getInstance().getTranslation("Positron_Disabled_Explanation"), false), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.weightx = 0.0;
        JPanel filler = new JPanel();
        filler.setBackground(ThemeColorProvider.getInstance().getBackgroundColor());
        this.add((Component)filler, constraints);
    }

    private void layoutPositronUI() {
        this.setLayout(new GridBagLayout());
        this.setBackground(null);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.anchor = 18;
        this.add((Component)this.createToolBarPanel(), constraints);
        ++constraints.gridy;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)this.createMainPanel(), constraints);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        String warning = TRANSLATOR.getTranslation("AI_may_provide_innacurate_info");
        JLabel disclaimerLabel = new JLabel(PositronAssistantPanel.trimWarning(warning));
        disclaimerLabel.setToolTipText(warning);
        disclaimerLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Colors.INFO_PANEL_TOP_BORDER), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        disclaimerLabel.setEnabled(false);
        this.add((Component)disclaimerLabel, constraints);
        this.updateComponentsStatus();
    }

    private static String trimWarning(String warning) {
        return warning.length() > 40 ? warning.substring(0, 40) + "..." : warning;
    }

    private void addListenersToUpdateEngine(StandalonePluginWorkspace pluginWS) {
        ArrayList<String> optionTagsToListenTo = new ArrayList<String>();
        optionTagsToListenTo.add("oxygen.positron.plugin.connector.configurations");
        optionTagsToListenTo.add("default.engine.model");
        optionTagsToListenTo.forEach(optionTag -> pluginWS.getOptionsStorage().addOptionListener(new WSOptionListener((String)optionTag){

            public void optionValueChanged(WSOptionChangedEvent arg0) {
                PositronAssistantPanel.this.updateComponentsStatus();
                PositronAssistantPanel.this.controller.loadAiActions(false);
            }
        }));
    }

    protected JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.insets.left = 0;
        constraints.insets.right = 0;
        this.createCardPanels();
        mainPanel.add((Component)this.cardPanel, constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.anchor = 15;
        constraints.fill = 2;
        constraints.insets = UIUtil.getSpacingInsets();
        mainPanel.add((Component)this.operationsStatusPresenter.getTextPresenter(), constraints);
        return mainPanel;
    }

    protected void createCardPanels() {
        this.cardPanel.add((Component)this.createScrollPane(new ChoosePositronDistributionPanel(true)), CONNECTION_INFO_PANEL_ID);
        this.cardPanel.add((Component)this.createScrollPane(new ChoosePositronDistributionPanel(false)), DIRECT_CONNECTION_INFO_PANEL_ID);
        this.connectionInProgress = new WaitingForConfirmationPanel(this.controller);
        this.cardPanel.add((Component)this.createScrollPane(this.connectionInProgress), CONNECTION_IN_PROGRESS_PANEL_ID);
        this.cardPanel.add((Component)this.chatPanel, AI_ACTIONS_PANEL_ID);
        this.emailNotValidatedPanel = new EmailNotVerifiedPanel(this.controller::refreshConnection, this.controller::resendVerificationEmail);
        this.cardPanel.add((Component)this.emailNotValidatedPanel, EMAIL_NOT_VERIFIED_PANEL_ID);
    }

    private JScrollPane createScrollPane(JPanel view) {
        PositronScrollPane sp = new PositronScrollPane(view);
        sp.setBorder(BorderFactory.createEmptyBorder());
        sp.getScrollPane().setOpaque(false);
        sp.getScrollPane().getViewport().setOpaque(false);
        return sp.getScrollPane();
    }

    private JPanel createToolBarPanel() {
        HistoryComponent<ChatModel> historyComponent;
        JPanel toolbarPanel = new JPanel(new GridBagLayout());
        toolbarPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.fill = 0;
        gc.anchor = 17;
        gc.insets = PlatformDetector.isMacOS() ? UIUtil.getSlimInsetsTop() : UIUtil.getNoInsets();
        AbstractButton newChatButton = this.chatPanel.getNewChatButton();
        if (newChatButton != null) {
            toolbarPanel.add((Component)newChatButton, gc);
            this.actionToolbarComponents.add(newChatButton);
            ++gc.gridx;
        }
        if ((historyComponent = this.chatPanel.getHistoryComponent()) != null) {
            toolbarPanel.add((Component)((Object)historyComponent), gc);
            this.actionToolbarComponents.add((Component)((Object)historyComponent));
            ++gc.gridx;
        }
        toolbarPanel.add((Component)this.openAIActionsPanel, gc);
        this.actionToolbarComponents.add(this.openAIActionsPanel);
        JPanel filler = new JPanel();
        ++gc.gridx;
        gc.weightx = 1.0;
        gc.fill = 2;
        toolbarPanel.add((Component)filler, gc);
        gc.weightx = 0.0;
        gc.fill = 0;
        ++gc.gridx;
        this.setRefreshConnectionInProgressIcon(false);
        toolbarPanel.add((Component)this.refreshConnectionInProgressIcon, gc);
        this.aiModelsBtn = new SplitMenuButton("Engine", null, true, true, true, false);
        ++gc.gridx;
        gc.anchor = 13;
        toolbarPanel.add((Component)this.aiModelsBtn, gc);
        this.userDropDownButton = new SplitMenuButton(null, (Icon)IconsLoader.loadIcon("/images/UserPositronOff16.png"), false, true, true, false);
        ++gc.gridx;
        gc.anchor = 13;
        toolbarPanel.add((Component)this.userDropDownButton, gc);
        toolbarPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Colors.INFO_PANEL_TOP_BORDER), toolbarPanel.getBorder()));
        return toolbarPanel;
    }

    public void updateMessageStatus(String message) {
        this.statusPresenter.showStatusMessage(message);
    }

    public void setCompletionImplementationProvider(CompletionImplementationProvider implementationProvider) {
        if (implementationProvider != null) {
            ContentInserter inserter = implementationProvider.getCompletionInserter();
            DocumentContentInteractor prefixExtractor = implementationProvider.getPrefixExtractor();
            this.openAIActionsPanel.setCompletionImplementation(inserter, prefixExtractor);
            this.chatPanel.editorContextChanged((DocumentDetailsProvider)implementationProvider.getCompletionInserter());
        } else {
            this.openAIActionsPanel.setCompletionImplementation(null, null);
            this.chatPanel.editorContextChanged(null);
        }
    }

    public void updateMessageStatus(String message, boolean modal) {
        this.statusPresenter.showStatusMessage(message, modal);
    }

    public Map<String, List<PositronAIActionBase>> getCompletionActions() {
        Map<String, List<PositronAIActionBase>> actions = Collections.emptyMap();
        if (DirectConnectionConfigurationHelper.isDirectConnection()) {
            try {
                this.controller.checkDirectConnectionLicense();
                actions = this.openAIActionsPanel.getCompletionActions();
            }
            catch (InvalidLicenseException invalidLicenseException) {}
        } else if (this.authenticationInfoManager.isConnected()) {
            actions = this.openAIActionsPanel.getCompletionActions();
        }
        return actions;
    }

    public void displayUserInformationInPanel(Auth0User user) {
        ImageIcon icon = IconsLoader.loadIcon("/images/UserPositronOff16.png");
        String tooltipText = null;
        if (DirectConnectionConfigurationHelper.isDirectConnection()) {
            icon = IconsLoader.loadIcon("/images/SettingsToolbar16.png");
        } else if (user != null) {
            icon = IconsLoader.loadIcon("/images/UserPositronOn16.png");
            tooltipText = user.getDisplayName();
        }
        this.userDropDownButton.setIcon((Icon)icon);
        this.userDropDownButton.setToolTipText(tooltipText);
    }

    public void updateComponentsStatus() {
        if (PositronOptionsUtil.isPositronEnabled()) {
            block10: {
                this.userDropDownButton.setEnabled(true);
                this.operationsStatusPresenter.setVisible(true);
                this.showToolbarComponents(false);
                if (DirectConnectionConfigurationHelper.isDirectConnection()) {
                    try {
                        this.controller.checkDirectConnectionLicense();
                        if (AIConnectorConfigsManager.getInstance().getConfigurations().isEmpty()) {
                            this.showConnectToOtherAiServicePanel();
                            break block10;
                        }
                        this.showActionsAndChat();
                    }
                    catch (InvalidLicenseException e) {
                        this.showConnectToOtherAiServicePanel();
                    }
                } else {
                    boolean isConnected = this.authenticationInfoManager.isConnected();
                    if (isConnected) {
                        if (!this.authenticationInfoManager.isAccountVerified()) {
                            Auth0User auth0User = this.authenticationInfoManager.getUser();
                            this.emailNotValidatedPanel.updateUser(auth0User.getEmail());
                            this.cardPanelLayout.show(this.cardPanel, EMAIL_NOT_VERIFIED_PANEL_ID);
                        } else {
                            this.showActionsAndChat();
                        }
                    } else {
                        this.cardPanelLayout.show(this.cardPanel, CONNECTION_INFO_PANEL_ID);
                    }
                }
            }
            this.displayUserInformationInPanel(this.authenticationInfoManager.getUser());
            this.updateConnectionActionsInDropdown();
            this.updateEngine();
        }
    }

    private void showConnectToOtherAiServicePanel() {
        this.cardPanelLayout.show(this.cardPanel, DIRECT_CONNECTION_INFO_PANEL_ID);
    }

    private void updateEngine() {
        this.aiModelsBtn.removeAll();
        JPopupMenu modelsPopup = this.aiModelsBtn.getPopupMenu();
        final IEnginesManager enginesManager = EnginesManagerProvider.getInstance().getEnginesManager();
        boolean isEnginesManagerAvailable = enginesManager.isChoosingEngineAllowed();
        this.aiModelsBtn.setVisible(isEnginesManagerAvailable);
        if (isEnginesManagerAvailable) {
            Map availableEngines = enginesManager.getAvailableEngines();
            ModelDescriptor currentEngineDescriptor = enginesManager.getCurrentEngineDescriptor();
            if (currentEngineDescriptor != null) {
                this.aiModelsBtn.setText(currentEngineDescriptor.getUiLabel());
                StringBuilder tooltip = new StringBuilder();
                String comboTooltip = enginesManager.getModelsComboTooltip();
                if (comboTooltip != null) {
                    tooltip.append(comboTooltip);
                    tooltip.append("\n\n");
                }
                tooltip.append(MessageFormat.format(Translator.getInstance().getTranslation("Current_AI_Model"), ModelsUIUtil.getUiLabelWithConfigurationForModel(currentEngineDescriptor)));
                if (currentEngineDescriptor.getDescription() != null) {
                    tooltip.append("\n");
                    tooltip.append(currentEngineDescriptor.getDescription());
                }
                tooltip.append("\n\n");
                tooltip.append("ID: ");
                tooltip.append(currentEngineDescriptor.getId());
                this.aiModelsBtn.setToolTipText(tooltip.toString());
            }
            ModelsUIUtil.addModelsToPopup(modelsPopup, availableEngines, descriptor -> {
                final String engineName = descriptor.getUiLabel();
                final String modelId = descriptor.getId();
                AbstractAction changeEngineAction = new AbstractAction(engineName){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String textToSet = engineName;
                        if (textToSet.startsWith("AI Positron Service / ")) {
                            textToSet = textToSet.substring("AI Positron Service / ".length()).trim();
                        }
                        PositronAssistantPanel.this.aiModelsBtn.setText(textToSet);
                        enginesManager.saveEngine(modelId);
                    }
                };
                StringBuilder tooltip = new StringBuilder();
                if (descriptor.getDescription() != null) {
                    tooltip.append(descriptor.getDescription());
                    tooltip.append("\n\n");
                }
                tooltip.append("ID: ");
                tooltip.append(descriptor.getId());
                changeEngineAction.putValue("ShortDescription", tooltip.toString());
                return changeEngineAction;
            });
        }
    }

    private void showActionsAndChat() {
        this.cardPanelLayout.show(this.cardPanel, AI_ACTIONS_PANEL_ID);
        this.setRefreshConnectionInProgressIcon(false);
        this.operationsStatusPresenter.setVisible(false);
        this.showToolbarComponents(true);
    }

    public void showToolbarComponents(boolean show) {
        int toolbarCompsCnt = this.actionToolbarComponents.size();
        for (int i = 0; i < toolbarCompsCnt; ++i) {
            this.actionToolbarComponents.get(i).setVisible(show);
        }
    }

    public void updateConnectionInProgressStatus() {
        this.cardPanelLayout.show(this.cardPanel, CONNECTION_IN_PROGRESS_PANEL_ID);
        this.userDropDownButton.setEnabled(false);
    }

    public void updateConnectionInProgressStatus(String userCode) {
        this.cardPanelLayout.show(this.cardPanel, CONNECTION_IN_PROGRESS_PANEL_ID);
        this.userDropDownButton.setEnabled(false);
        this.connectionInProgress.setUserCode(userCode);
    }

    public void clearUserCode() {
        this.connectionInProgress.setUserCode("");
    }

    private void updateConnectionActionsInDropdown() {
        this.userDropDownButton.removeAll();
        if (DirectConnectionConfigurationHelper.isDirectConnection()) {
            if (!DirectConnectionLicenseManager.getInstance().isCoveredByOxygenEnterpriseLicense()) {
                this.userDropDownButton.add((Action)this.controller.getRegisterDirectConnectionLicenseAction());
                this.userDropDownButton.addSeparator();
            }
        } else {
            if (this.authenticationInfoManager.isConnected()) {
                this.userDropDownButton.add((Action)this.controller.getMyAccountAction());
                this.userDropDownButton.add((Action)this.controller.getDisconnectAction());
            } else {
                this.userDropDownButton.add((Action)this.controller.getConnectAction());
            }
            this.userDropDownButton.addSeparator();
        }
        this.userDropDownButton.add((Action)new OpenPreferencesPageAction());
    }

    public void setRefreshConnectionInProgressIcon(boolean visible) {
        this.refreshConnectionInProgressIcon.setVisible(visible);
    }

    public void setAiActionsMenuBar(Menu aiActionsMenu) {
        this.openAIActionsPanel.setAiActionsMenuBar(aiActionsMenu);
        this.controller.setAiActionsMenuBar(aiActionsMenu);
    }

    public CompletionActionsManager getCompletionActionsManager() {
        return this.completionActionsManager;
    }

    public PositronAssistantPanelController getAssistantController() {
        return this.controller;
    }

    public ChatPanel getChatPanel() {
        return this.chatPanel;
    }

    public void selectionChanged(boolean hasSelection) {
        this.chatPanel.updateInputAreaHintBasedOnSelection(hasSelection);
        this.chatPanel.updateSelectionChip(Translator.getInstance().getTranslation("Current_document_selection") + ":\n");
    }
}

