/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin;

import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.connector.AIConnectorConfigsManager;
import com.oxygenxml.positron.connector.AIConnectorConfiguration;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.engines.IEnginesManager;
import com.oxygenxml.positron.core.util.AIModelsUtil;
import com.oxygenxml.positron.plugin.ui.ComboBoxItem;
import com.oxygenxml.positron.plugin.ui.GroupComboBoxRenderer;
import com.oxygenxml.positron.plugin.ui.GroupedComboBoxModel;
import com.oxygenxml.positron.plugin.util.DirectConnectionConfigurationHelper;
import com.oxygenxml.positron.utilities.ModelIdentifierUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import ro.sync.exml.workspace.api.standalone.ui.Menu;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class ModelsUIUtil {
    private static final String AI_POSITRON_SERVICE_PREFIX = "AI Positron Service / ";
    private static final String AI_POSITRON_SERVICE_SUFFIX = " [AI Positron Service]";

    public static void addModelsToPopup(JPopupMenu modelsPopup, Map<String, List<ModelDescriptor>> groupedModels, Function<ModelDescriptor, AbstractAction> actionCreator) {
        LinkedHashMap<String, List<ModelDescriptor>> aiPositronServiceModels = new LinkedHashMap<String, List<ModelDescriptor>>();
        LinkedHashMap<String, List<ModelDescriptor>> externalAiSericeModels = new LinkedHashMap<String, List<ModelDescriptor>>();
        for (Map.Entry<String, List<ModelDescriptor>> entry : groupedModels.entrySet()) {
            String key = entry.getKey();
            List<ModelDescriptor> modelDescriptors = entry.getValue();
            for (ModelDescriptor modelDescriptor : modelDescriptors) {
                if (modelDescriptor.getId().startsWith("aips")) {
                    if (key.startsWith(AI_POSITRON_SERVICE_PREFIX)) {
                        key = key.substring(AI_POSITRON_SERVICE_PREFIX.length()).trim();
                    }
                    aiPositronServiceModels.put(key, modelDescriptors);
                    continue;
                }
                externalAiSericeModels.put(key, modelDescriptors);
            }
        }
        ModelsUIUtil.addAiPositronServiceEntriesToMenu(modelsPopup, actionCreator, aiPositronServiceModels, externalAiSericeModels);
        ModelsUIUtil.addExternalAiServiceEntriesToMenu(modelsPopup, actionCreator, aiPositronServiceModels, externalAiSericeModels);
    }

    private static void addExternalAiServiceEntriesToMenu(JPopupMenu modelsPopup, Function<ModelDescriptor, AbstractAction> actionCreator, Map<String, List<ModelDescriptor>> aiPositronServiceModels, Map<String, List<ModelDescriptor>> externalAiSericeModels) {
        block8: {
            if (externalAiSericeModels.containsKey("<Default>")) {
                List<ModelDescriptor> defaults = externalAiSericeModels.get("<Default>");
                if (defaults != null && !defaults.isEmpty()) {
                    modelsPopup.add(OxygenUIComponentsFactory.createMenuItem((Action)actionCreator.apply(defaults.get(0))));
                }
                externalAiSericeModels = new LinkedHashMap<String, List<ModelDescriptor>>(externalAiSericeModels);
                externalAiSericeModels.remove("<Default>");
            }
            if (externalAiSericeModels.isEmpty()) break block8;
            if (externalAiSericeModels.size() == 1 && aiPositronServiceModels.isEmpty()) {
                List<ModelDescriptor> models = externalAiSericeModels.values().iterator().next();
                for (ModelDescriptor model : models) {
                    modelsPopup.add(OxygenUIComponentsFactory.createMenuItem((Action)actionCreator.apply(model)));
                }
            } else {
                for (String category : externalAiSericeModels.keySet()) {
                    List<ModelDescriptor> modelList = externalAiSericeModels.get(category);
                    if (modelList.size() == 1 && modelList.get(0).getUiLabel().equals(category)) {
                        modelsPopup.add(OxygenUIComponentsFactory.createMenuItem((Action)actionCreator.apply(modelList.get(0))));
                        continue;
                    }
                    Menu categoryMenu = OxygenUIComponentsFactory.createMenu((String)category);
                    modelsPopup.add((JMenuItem)categoryMenu);
                    for (ModelDescriptor model : modelList) {
                        categoryMenu.add(OxygenUIComponentsFactory.createMenuItem((Action)actionCreator.apply(model)));
                    }
                }
            }
        }
    }

    private static void addAiPositronServiceEntriesToMenu(JPopupMenu modelsPopup, Function<ModelDescriptor, AbstractAction> actionCreator, Map<String, List<ModelDescriptor>> aiPositronServiceModels, Map<String, List<ModelDescriptor>> externalAiServiceModels) {
        if (!aiPositronServiceModels.isEmpty()) {
            boolean hasExternalAIConnections = !externalAiServiceModels.isEmpty();
            for (Map.Entry<String, List<ModelDescriptor>> entry : aiPositronServiceModels.entrySet()) {
                Object key = entry.getKey();
                List<ModelDescriptor> value = entry.getValue();
                if (value.size() == 1) {
                    ModelDescriptor model = value.get(0);
                    if (hasExternalAIConnections) {
                        model = new ModelDescriptor(model.getId(), AI_POSITRON_SERVICE_PREFIX + model.getUiLabel(), model.getDescription(), model.getContextWindow(), model.getMaxOutputTokens(), model.isReasoningModel());
                    }
                    modelsPopup.add(OxygenUIComponentsFactory.createMenuItem((Action)actionCreator.apply(model)));
                    continue;
                }
                if (hasExternalAIConnections) {
                    key = AI_POSITRON_SERVICE_PREFIX + (String)key;
                }
                Menu categoryMenu = OxygenUIComponentsFactory.createMenu((String)key);
                modelsPopup.add((JMenuItem)categoryMenu);
                for (ModelDescriptor model : value) {
                    categoryMenu.add(OxygenUIComponentsFactory.createMenuItem((Action)actionCreator.apply(model)));
                }
            }
        }
    }

    public static JComboBox<ComboBoxItem> createGroupedModelsComboBox(Map<String, List<ModelDescriptor>> groupedModels) {
        return ModelsUIUtil.createGroupedModelsComboBox(groupedModels, true);
    }

    public static JComboBox<ComboBoxItem> createGroupedModelsComboBox(Map<String, List<ModelDescriptor>> groupedModels, boolean keepPositronServicePrefix) {
        GroupedComboBoxModel model = ModelsUIUtil.createGroupedModelsComboBoxModel(groupedModels, keepPositronServicePrefix);
        JComboBox comboBox = OxygenUIComponentsFactory.createComboBox((ComboBoxModel)model);
        GroupComboBoxRenderer renderer = new GroupComboBoxRenderer();
        comboBox.setRenderer(renderer);
        return comboBox;
    }

    public static GroupedComboBoxModel createGroupedModelsComboBoxModel(Map<String, List<ModelDescriptor>> groupedModels, boolean keepPositronServicePrefix) {
        GroupedComboBoxModel model;
        block8: {
            model = new GroupedComboBoxModel();
            if (groupedModels.containsKey("<Default>") || groupedModels.containsKey("AI Positron Service / <Default>")) {
                List<ModelDescriptor> defaultModels = groupedModels.get("<Default>");
                if (defaultModels != null && !defaultModels.isEmpty()) {
                    model.addElement(new ComboBoxItem(null, defaultModels.get(0)));
                }
                groupedModels = new LinkedHashMap<String, List<ModelDescriptor>>(groupedModels);
                groupedModels.remove("<Default>");
            }
            if (groupedModels.isEmpty()) break block8;
            if (groupedModels.size() == 1) {
                List<ModelDescriptor> models = groupedModels.values().iterator().next();
                for (ModelDescriptor descriptor : models) {
                    model.addElement(new ComboBoxItem(null, descriptor));
                }
            } else {
                for (Map.Entry<String, List<ModelDescriptor>> entry : groupedModels.entrySet()) {
                    String categoryName = entry.getKey();
                    if (!keepPositronServicePrefix && categoryName.startsWith(AI_POSITRON_SERVICE_PREFIX)) {
                        categoryName = ModelIdentifierUtil.extractModelId((String)categoryName).trim();
                    }
                    List<ModelDescriptor> models = entry.getValue();
                    model.addElement(new ComboBoxItem(categoryName, null));
                    for (ModelDescriptor descriptor : models) {
                        model.addElement(new ComboBoxItem(categoryName, descriptor));
                    }
                }
            }
        }
        return model;
    }

    public static String getUITooltipForModelID(String modelId) {
        return AIModelsUtil.getModelExplanation((String)modelId, (!DirectConnectionConfigurationHelper.isDirectConnection() ? 1 : 0) != 0);
    }

    public static String getUiLabelWithConfigurationForModel(ModelDescriptor modelDecriptor) {
        StringBuilder sb = new StringBuilder();
        sb.append(modelDecriptor.getUiLabel());
        if (modelDecriptor.getId().startsWith("aips")) {
            sb.append(AI_POSITRON_SERVICE_SUFFIX);
        } else {
            String[] splitModelIdentifier = ModelIdentifierUtil.splitModelIdentifier((String)modelDecriptor.getId());
            if (splitModelIdentifier[0] != null && splitModelIdentifier[1] != null && !splitModelIdentifier[1].trim().isEmpty()) {
                sb.append(" [");
                AIConnectorConfiguration configuration = AIConnectorConfigsManager.getInstance().getConfigurationById(splitModelIdentifier[0]);
                if (configuration != null) {
                    sb.append(configuration.getName());
                } else {
                    sb.append(splitModelIdentifier[0]);
                }
                sb.append("]");
            }
        }
        return sb.toString();
    }

    public static Map<String, List<ModelDescriptor>> collectPositronServiceModels() {
        LinkedHashMap<String, List<ModelDescriptor>> aiPositronServiceModels = new LinkedHashMap<String, List<ModelDescriptor>>();
        IEnginesManager enginesManager = EnginesManagerProvider.getInstance().getEnginesManager();
        Map availableEngines = enginesManager.getAvailableEngines();
        for (Map.Entry entry : availableEngines.entrySet()) {
            String key = (String)entry.getKey();
            List modelDescriptors = (List)entry.getValue();
            for (ModelDescriptor modelDescriptor : modelDescriptors) {
                if (!modelDescriptor.getId().startsWith("aips")) continue;
                aiPositronServiceModels.put(key, modelDescriptors);
            }
        }
        return aiPositronServiceModels;
    }
}

