/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin;

import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManager;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManagerProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.plugin.ActionsUtil;
import com.oxygenxml.positron.plugin.chat.ChatUserInputInteractor;
import com.oxygenxml.positron.plugin.completion.AICompletionProvidersManager;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.preferences.OpenPreferencesPageAction;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.ui.Menu;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class MenusActionsManager {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private static List<String> registeredShortcutIDs = new ArrayList<String>();

    private static void registerShortcuts(StandalonePluginWorkspace pluginWorkspaceAccess, Map<String, List<PositronAIActionBase>> categActions, AICompletionProvidersManager aiCompletionProviderManager, CompletionActionsManager completionActionsManager, ChatUserInputInteractor userInteractor) {
        if (!registeredShortcutIDs.isEmpty()) {
            for (String id : registeredShortcutIDs) {
                pluginWorkspaceAccess.getActionsProvider().unregisterAction(id);
            }
            registeredShortcutIDs.clear();
        }
        for (String category : categActions.keySet()) {
            List<PositronAIActionBase> actions = categActions.get(category);
            for (PositronAIActionBase openAICompletionAction : actions) {
                String actionID = openAICompletionAction.getActionDetails().getId();
                registeredShortcutIDs.add(actionID);
                pluginWorkspaceAccess.getActionsProvider().registerAction(actionID, (Object)openAICompletionAction, null);
            }
        }
    }

    public static void populateAiMenu(Menu aiMenu, Map<String, List<PositronAIActionBase>> categActions, AICompletionProvidersManager aiCompletionProvidersManager, CompletionActionsManager completionActionsManager, ChatUserInputInteractor userInteractor) {
        if (aiMenu != null) {
            if (PositronOptionsUtil.isPositronEnabled()) {
                URL editorLocation;
                WSEditor currentEditorAccess;
                MenusActionsManager.clearAiMenu(aiMenu);
                StandalonePluginWorkspace pluginWorkspace = (StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
                MenusActionsManager.registerShortcuts(pluginWorkspace, categActions, aiCompletionProvidersManager, completionActionsManager, userInteractor);
                for (String category : categActions.keySet()) {
                    Menu categoryMenu = OxygenUIComponentsFactory.createMenu((String)category);
                    aiMenu.add((JMenuItem)categoryMenu);
                    List<PositronAIActionBase> actions = categActions.get(category);
                    for (PositronAIActionBase openAICompletionAction : actions) {
                        categoryMenu.add((Action)openAICompletionAction);
                    }
                }
                boolean isAIMainMenu = aiMenu.getParent() instanceof JMenuBar;
                if (!isAIMainMenu && (currentEditorAccess = pluginWorkspace.getCurrentEditorAccess(0)) != null && URLUtil.isFromLocalDrive((URL)(editorLocation = currentEditorAccess.getEditorLocation()))) {
                    aiMenu.addSeparator();
                    aiMenu.add((Action)MenusActionsManager.createAiIgnoreAction(() -> Arrays.asList(editorLocation), null));
                }
                aiMenu.addSeparator();
                aiMenu.add((Action)ActionsUtil.createShowPositronAssistantViewAction());
                aiMenu.addSeparator();
                aiMenu.add((Action)new OpenPreferencesPageAction());
            } else {
                MenusActionsManager.populateDisabledPositronMenu(aiMenu);
            }
        }
    }

    public static void populateDisabledPositronMenu(Menu aiMenu) {
        if (aiMenu != null) {
            MenusActionsManager.clearAiMenu(aiMenu);
            aiMenu.add((Action)ActionsUtil.createShowPositronAssistantViewAction());
            aiMenu.addSeparator();
            aiMenu.add((Action)new OpenPreferencesPageAction());
        }
    }

    private static void clearAiMenu(Menu aiMenu) {
        aiMenu.removeAll();
    }

    public static AbstractAction createAiIgnoreAction(final Supplier<List<URL>> resourcesToAddSupplier, final Runnable additionalActionTOPerformedAfterAiIgnoreFinishes) {
        AbstractAction addToAiIgnore = new AbstractAction(TRANSLATOR.getTranslation("Exclude_from_AI"), IconsLoader.loadIcon("/images/AddToAiIgnore16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AiIgnoreManager aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker();
                if (aiIgnoreChecker != null) {
                    aiIgnoreChecker.addToAiIgnore((List)resourcesToAddSupplier.get());
                    if (additionalActionTOPerformedAfterAiIgnoreFinishes != null) {
                        additionalActionTOPerformedAfterAiIgnoreFinishes.run();
                    }
                }
            }
        };
        addToAiIgnore.putValue("ShortDescription", TRANSLATOR.getTranslation("Exclude_from_AI_description"));
        return addToAiIgnore;
    }
}

