/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.functions.SAToolsExecutionHandler;
import com.oxygenxml.positron.mcp.MCPInput;
import com.oxygenxml.positron.mcp.MCPManager;
import com.oxygenxml.positron.mcp.MCPStdioServer;
import com.oxygenxml.positron.mcp.MCPValueResolver;
import com.oxygenxml.positron.plugin.preferences.MCPOptionPageExtension;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ActionType;
import com.oxygenxml.positron.utilities.json.ChatFunctionRef;
import com.oxygenxml.positron.utilities.json.Parameters;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.project.ProjectChangeListener;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyConnectionInfo;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;
import ro.sync.util.editorvars.EditorVariables;

public class MCPInstaller {
    static int MAX_LOAD_WAIT_COUNTER = 10;
    private static MCPManager mcpManager;
    private static final Logger LOGGER;

    public static MCPManager installMCPManager(StandalonePluginWorkspace pluginWorkspaceAccess, Supplier<SAToolsExecutionHandler> toolsExecutorProvider) {
        mcpManager = new MCPManager();
        MCPInstaller.installMCPManagerInternal(pluginWorkspaceAccess, toolsExecutorProvider, mcpManager);
        return mcpManager;
    }

    @VisibleForTesting
    static MCPManager installMCPManagerInternal(final StandalonePluginWorkspace pluginWorkspaceAccess, Supplier<SAToolsExecutionHandler> toolsExecutorProvider, final MCPManager mcpManager) {
        mcpManager.setValueResolver(MCPInstaller.createVariablesResolver(pluginWorkspaceAccess));
        try {
            MCPInstaller.configureHttpProxySelector(pluginWorkspaceAccess, mcpManager);
            mcpManager.addMCPManagerListener(() -> {
                if (toolsExecutorProvider.get() != null) {
                    ((SAToolsExecutionHandler)((Object)((Object)toolsExecutorProvider.get()))).getToolsExecutor().reloadFunctions();
                }
            });
            MCPOptionPageExtension.setMCPManager(mcpManager);
            final WSOptionsStorage optionsStorage = pluginWorkspaceAccess.getOptionsStorage();
            MCPInstaller.configureMCPTimeout(pluginWorkspaceAccess, optionsStorage, mcpManager);
            optionsStorage.addOptionListener(new WSOptionListener("oxygen.positron.plugin.mcp.timeout"){

                public void optionValueChanged(WSOptionChangedEvent event) {
                    MCPInstaller.configureMCPTimeout(pluginWorkspaceAccess, optionsStorage, mcpManager);
                }
            });
            optionsStorage.addOptionListener(new WSOptionListener("oxygen.positron.plugin.mcp.config.file"){

                public void optionValueChanged(WSOptionChangedEvent event) {
                    MCPInstaller.loadMCPConfigAfterMainFrameLoads(pluginWorkspaceAccess, mcpManager);
                }
            });
            optionsStorage.addOptionListener(new WSOptionListener("oxygen.positron.plugin.mcp.local.servers.enable"){

                public void optionValueChanged(WSOptionChangedEvent event) {
                    MCPInstaller.loadMCPConfigAfterMainFrameLoads(pluginWorkspaceAccess, mcpManager);
                }
            });
            if (pluginWorkspaceAccess.getProjectManager() != null) {
                pluginWorkspaceAccess.getProjectManager().addProjectChangeListener(new ProjectChangeListener(){

                    public void projectChanged(URL oldProjectURL, URL newProjectURL) {
                        MCPInstaller.loadMCPConfigAfterMainFrameLoads(pluginWorkspaceAccess, mcpManager);
                    }
                });
            }
            MCPInstaller.loadMCPConfigAfterMainFrameLoads(pluginWorkspaceAccess, mcpManager);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return mcpManager;
    }

    private static MCPValueResolver createVariablesResolver(final StandalonePluginWorkspace pluginWorkspaceAccess) {
        return new MCPValueResolver(){

            public Map<String, String> resolveInputValues(List<MCPInput> inputs) {
                HashMap<String, String> resolved = new HashMap<String, String>();
                if (inputs != null) {
                    for (MCPInput mcpInput : inputs) {
                        String askEditorVariable = "${ask('" + Translator.getInstance().getTranslation("Model_Context_Protocol") + " - " + mcpInput.getDescription() + "', " + (mcpInput.isPassword() ? "password" : "generic") + ", '')}";
                        String resolvedValue = pluginWorkspaceAccess.getUtilAccess().expandEditorVariables(askEditorVariable, null, true);
                        if (resolvedValue == null) continue;
                        resolved.put(mcpInput.getId(), resolvedValue);
                    }
                }
                return resolved;
            }

            public String resolveEditorVariable(String value) {
                return EditorVariables.expandEditorVariables((String)value, null);
            }
        };
    }

    private static void configureHttpProxySelector(final StandalonePluginWorkspace pluginWorkspaceAccess, MCPManager mcpManager) {
        mcpManager.setProxySelector(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                ArrayList<Proxy> proxies = new ArrayList<Proxy>();
                ProxyDetailsProvider pdp = pluginWorkspaceAccess.getProxyDetailsProvider();
                try {
                    ProxyConnectionInfo pi = pdp.getProxyConnectionInfo(new URL(uri.toString()));
                    if (pi != null && pi.getHost() != null) {
                        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(InetAddress.getByName(pi.getHost()), pi.getPort()));
                        proxies.add(proxy);
                    }
                }
                catch (MalformedURLException | UnknownHostException e) {
                    LOGGER.error("Cannot create URL from " + uri, (Throwable)e);
                }
                if (proxies.isEmpty()) {
                    proxies.add(Proxy.NO_PROXY);
                }
                return proxies;
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        });
    }

    private static void loadMCPConfigAfterMainFrameLoads(final StandalonePluginWorkspace pluginWorkspaceAccess, final MCPManager mcpManager) {
        new Thread("Load MCP Config"){

            @Override
            public void run() {
                Object parentFrame = pluginWorkspaceAccess.getParentFrame();
                for (int counter = MAX_LOAD_WAIT_COUNTER; !(counter <= 0 || parentFrame != null && ((JFrame)parentFrame).isVisible()); --counter) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    MCPInstaller.loadMCPConfig(pluginWorkspaceAccess, mcpManager, false);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }.start();
    }

    private static void loadMCPConfig(StandalonePluginWorkspace pluginWorkspaceAccess, MCPManager mcpManager, boolean isForceReload) throws MalformedURLException {
        if (pluginWorkspaceAccess == null || pluginWorkspaceAccess.getOptionsStorage() == null) {
            return;
        }
        WSOptionsStorage optionsStorage = pluginWorkspaceAccess.getOptionsStorage();
        String mcpConfigFile = optionsStorage.getOption("oxygen.positron.plugin.mcp.config.file", "${pd}/positron-ai-actions/mcp-config.json");
        if (mcpConfigFile != null && !mcpConfigFile.isEmpty()) {
            mcpConfigFile = pluginWorkspaceAccess.getUtilAccess().expandEditorVariables(mcpConfigFile, null);
            File configFile = new File(mcpConfigFile);
            mcpManager.reloadConfiguration(URLUtil.correct((File)configFile), Boolean.valueOf(optionsStorage.getOption("oxygen.positron.plugin.mcp.local.servers.enable", "false")).booleanValue(), isForceReload);
        }
    }

    private static void configureMCPTimeout(StandalonePluginWorkspace pluginWorkspaceAccess, WSOptionsStorage optionsStorage, MCPManager mcpManager) {
        String mcpTimeout = optionsStorage.getOption("oxygen.positron.plugin.mcp.timeout", "10");
        if (mcpTimeout != null && !mcpTimeout.isEmpty()) {
            try {
                int timeout = Integer.parseInt(mcpTimeout);
                mcpManager.setTimeout(Duration.ofSeconds(timeout));
            }
            catch (NumberFormatException ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    static AIActionDetails addExtraFunctionRefs(WSOptionsStorage optionsStorage, MCPManager mcpManager, AIActionDetails actionDetails) {
        Boolean isAddMCPToolsToChatModes = Boolean.valueOf(optionsStorage.getOption("oxygen.positron.plugin.mcp.add.tools.all.chatmodes", "true"));
        if (isAddMCPToolsToChatModes.booleanValue()) {
            try {
                List tools;
                boolean isChatAction;
                boolean bl = isChatAction = actionDetails.getComputedType() == ActionType.CHAT_MODE;
                if (isChatAction && !(tools = mcpManager.getTools()).isEmpty()) {
                    AIActionDetails enhanced = actionDetails.clone();
                    Parameters params = enhanced.getParameters();
                    List functionRefs = params.getFunctionRefs();
                    ArrayList<ChatFunctionRef> enhancedRefs = new ArrayList<ChatFunctionRef>();
                    if (functionRefs != null) {
                        enhancedRefs.addAll(functionRefs);
                    }
                    for (FunctionExecutor functionExecutor : tools) {
                        ChatFunctionRef chatFunctioRef = new ChatFunctionRef();
                        chatFunctioRef.setRef(functionExecutor.getFunctionSignature().getName());
                        enhancedRefs.add(chatFunctioRef);
                    }
                    params.setFunctionRefs(enhancedRefs);
                    actionDetails = enhanced;
                }
            }
            catch (CloneNotSupportedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return actionDetails;
    }

    public static void startMCPServer(Supplier<SAToolsExecutionHandler> toolsExecutorProvider) {
        try {
            WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
            boolean isEnableRunOxygenAsLocalMCP = optionsStorage != null && Boolean.valueOf(optionsStorage.getOption("oxygen.positron.plugin.mcp.oxygen.app.mcp.server.enable", "false")) != false;
            OutputStream mcpOutput = (OutputStream)UIManager.get("MCPServerOut");
            InputStream mcpIn = (InputStream)UIManager.get("MCPServerIn");
            if (isEnableRunOxygenAsLocalMCP && mcpIn != null && mcpOutput != null) {
                MCPStdioServer mcpServer = new MCPStdioServer(() -> ((SAToolsExecutionHandler)((Object)((Object)toolsExecutorProvider.get()))).getToolsExecutor().getFunctionExecutors());
                ((CompletableFuture)mcpServer.start(mcpIn, mcpOutput).thenRun(() -> LOGGER.info("MCP server started successfully"))).exceptionally(throwable -> {
                    LOGGER.error("Failed to start MCP server: {}", (Object)throwable.getMessage(), throwable);
                    return null;
                });
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    if (mcpServer != null) {
                        try {
                            mcpServer.stop().get();
                            LOGGER.info("MCP server stopped gracefully");
                        }
                        catch (Exception e) {
                            LOGGER.error("Error stopping MCP server: {}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                }));
            } else if (!isEnableRunOxygenAsLocalMCP && mcpIn != null && mcpOutput != null) {
                LOGGER.error("!!! IMPORTANT !!!: Please go to the Oxygen Preferences->'Oxygen AI Positron / Model Context Protocol' page and enable the 'Allow running the Oxygen XML application as a local MCP server', then save the settings, close Oxygen XML and re-start the LLM application.");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error starting MCP server: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void reloadMCPServers() {
        try {
            MCPInstaller.loadMCPConfig((StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace(), mcpManager, true);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)MCPInstaller.class.getName());
    }
}

