/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.functions;

import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.tools.internal.ToolsDocumentsChangesManager;
import com.oxygenxml.positron.core.util.WSEditorUtils;
import com.oxygenxml.positron.functions.DocumentChange;
import com.oxygenxml.positron.functions.DocumentChangesApprovalCallback;
import com.oxygenxml.positron.functions.DocumentChangesApprovalCallbackResult;
import com.oxygenxml.positron.plugin.chat.ChatScrollUpdater;
import com.oxygenxml.positron.plugin.util.DiffPresenter;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.xml.encoding.EncodingDetectorInterface;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.xml.encoding.EncodingDetector;

public abstract class ToolsDocumentsChangesManagerBase
implements ToolsDocumentsChangesManager {
    private static final Logger log = LoggerFactory.getLogger(ToolsDocumentsChangesManagerBase.class);
    private ChatInteractor chatInteractor;
    protected Map<String, Set<DocumentChange>> toolsDocumentChanges = new LinkedHashMap<String, Set<DocumentChange>>();
    private List<Runnable> clearChangesListeners = new ArrayList<Runnable>();
    private ChatScrollUpdater scrollUpdater;

    public void storeChange(String toolId, URL docURL, String newContent, String previousContent) {
        this.storeChange(toolId, docURL, newContent, previousContent, true);
    }

    public void storeChange(String toolId, URL docURL, String newContent, String previousContent, boolean discardable) {
        this.toolsDocumentChanges.computeIfAbsent(toolId, k -> new LinkedHashSet());
        this.toolsDocumentChanges.get(toolId).add(new DocumentChange(docURL, previousContent, newContent, discardable));
    }

    public void showChangesForApproval(String approvalMessage, boolean forceShowReviewChangesDialog) {
        if (this.hasChangesWhichCanBeApproved()) {
            Map<URL, DocumentChange> documentChanges = this.getDocumentChanges();
            DocumentChangesApprovalCallback changesApprovalCallback = this.getDocumentChangesApprovalCallback(approvalMessage, forceShowReviewChangesDialog);
            this.processApprovalResult(changesApprovalCallback.requestUserApproval(new ArrayList<DocumentChange>(documentChanges.values())));
        }
    }

    public Map<URL, DocumentChange> getDocumentChanges() {
        LinkedHashMap<URL, DocumentChange> documentChanges = new LinkedHashMap<URL, DocumentChange>();
        this.toolsDocumentChanges.forEach((toolId, toolChanges) -> toolChanges.forEach(change -> {
            if (change.isCanDiscardChange()) {
                documentChanges.computeIfAbsent(change.getDocURL(), url -> new DocumentChange(change.getDocURL(), change.getPreviousContent(), this.getDocumentContent(change.getDocURL()), true));
            }
        }));
        return documentChanges;
    }

    private void notifyChangeListeners() {
        this.clearChangesListeners.forEach(Runnable::run);
        if (!this.hasChanges()) {
            this.clearChangesListeners.clear();
        }
    }

    private void processApprovalResult(DocumentChangesApprovalCallbackResult approvalResult) {
        Collection<DocumentChange> rejectedChanges = approvalResult.getRejectedChanges();
        List<DocumentChange> discarded = this.discardChangesNow(rejectedChanges);
        this.showDiscardedChangesInChat(discarded);
        List<URL> urlsOfAccepted = approvalResult.getAcceptedChanges().stream().map(DocumentChange::getDocURL).collect(Collectors.toList());
        this.removeChangesForDocumentsUrls(urlsOfAccepted);
    }

    public void showDiscardedChangesInChat(List<DocumentChange> discarded) {
        if (this.chatInteractor != null && !this.chatInteractor.isClearingChat() && !discarded.isEmpty()) {
            StringBuilder messageBuilder = new StringBuilder("The following file changes were rejected:");
            for (DocumentChange docChange : discarded) {
                String fileName = URLUtil.extractFileName((URL)docChange.getDocURL());
                messageBuilder.append('\n').append(fileName);
            }
            Message message = new Message(RoleType.USER, (MessageContent)new MessageTextContent(messageBuilder.toString()));
            this.chatInteractor.storeMessage(message);
            this.chatInteractor.showMessage(message);
            if (this.scrollUpdater != null) {
                SwingUtilities.invokeLater(() -> this.scrollUpdater.forceScrollToBottomNow());
            }
        }
    }

    public List<DocumentChange> discardChangesNow(Collection<DocumentChange> rejectedChanges) {
        List<DocumentChange> discarded = this.discardIfPossible(rejectedChanges);
        List<URL> urlsOfDiscarded = discarded.stream().map(DocumentChange::getDocURL).collect(Collectors.toList());
        this.removeChangesForDocumentsUrls(urlsOfDiscarded);
        return discarded;
    }

    private List<DocumentChange> discardIfPossible(Collection<DocumentChange> rejectedChanges) {
        LinkedHashMap<DocumentChange, IOException> couldNotDiscard = new LinkedHashMap<DocumentChange, IOException>();
        ArrayList<DocumentChange> discarded = new ArrayList<DocumentChange>();
        for (DocumentChange documentChange : rejectedChanges) {
            try {
                this.discardDocumentChange(documentChange);
                discarded.add(documentChange);
            }
            catch (IOException e) {
                couldNotDiscard.put(documentChange, e);
            }
        }
        if (!couldNotDiscard.isEmpty()) {
            ArrayList<URL> notDiscardedURLs = new ArrayList<URL>();
            StringBuilder problems = new StringBuilder();
            problems.append("Could not discard the following resources: \n");
            for (Map.Entry problem : couldNotDiscard.entrySet()) {
                URL docURL = ((DocumentChange)problem.getKey()).getDocURL();
                problems.append(" - " + URLUtil.getDescription((URL)docURL) + ", because: " + ((IOException)problem.getValue()).getMessage());
                notDiscardedURLs.add(docURL);
            }
            String errorMessage = problems.toString();
            PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage(errorMessage);
            if (!notDiscardedURLs.isEmpty()) {
                this.chatInteractor.showMessageForNotSuccessfulAction(errorMessage, false, false, false, null);
                this.removeChangesForDocumentsUrls(notDiscardedURLs);
            }
        }
        return discarded;
    }

    private void removeChangesForDocumentsUrls(List<URL> docURLs) {
        this.toolsDocumentChanges.values().forEach(changes -> changes.removeIf(change -> docURLs.contains(change.getDocURL())));
        List<String> emptyKeys = this.toolsDocumentChanges.entrySet().stream().filter(entry -> ((Set)entry.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toList());
        emptyKeys.forEach(this.toolsDocumentChanges::remove);
        this.notifyChangeListeners();
    }

    public void acceptChanges(URL docURL) {
        this.removeChangesForDocumentsUrls(Collections.singletonList(docURL));
    }

    public boolean hasChangesForURL(URL docURL) {
        return this.toolsDocumentChanges.values().stream().anyMatch(changes -> changes.stream().anyMatch(change -> change != null && change.getDocURL().equals(docURL) && change.isCanDiscardChange()));
    }

    public void rollback(String toolId) {
        Set<DocumentChange> changesOfTool = this.toolsDocumentChanges.getOrDefault(toolId, Collections.emptySet());
        this.discardIfPossible(changesOfTool);
    }

    protected void discardDocumentChange(DocumentChange change) throws IOException {
        if (!change.isCanDiscardChange()) {
            return;
        }
        if (change.getPreviousContent() == null) {
            URL docUrl = change.getDocURL();
            PluginWorkspaceProvider.getPluginWorkspace().delete(docUrl);
        } else {
            URL docUrl = change.getDocURL();
            WSEditor editor = WSEditorUtils.getEditor((URL)docUrl);
            if (WSEditorUtils.isNewDocument((WSEditor)editor)) {
                WSEditorUtils.reloadEditorContent((WSEditor)editor, (String)change.getPreviousContent());
            } else {
                ToolsDocumentsChangesManagerBase.writeToURL(change.getPreviousContent(), docUrl);
            }
        }
        change.setCanDiscardChange(false);
    }

    public void seeChanges(String toolId) {
        this.showDocumentsChanges(this.toolsDocumentChanges.getOrDefault(toolId, Collections.emptySet()), false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> showDocumentsChanges(Set<DocumentChange> changesToSee, boolean enableCopyChangesFromRightToLeft, boolean enableCopyChangesFromLeftToRight) {
        ArrayList<URL> acceptedChanges = new ArrayList<URL>();
        ArrayList<File> tmpFiles = new ArrayList<File>();
        LinkedHashMap<URL, URL> filesToPreview = new LinkedHashMap<URL, URL>();
        LinkedHashMap<URL, URL> originalUrlsMap = new LinkedHashMap<URL, URL>();
        try {
            this.createTemporaryFilesFromChanges(changesToSee, tmpFiles, filesToPreview, originalUrlsMap);
            LinkedHashMap<URL, URL> filesToDiff = filesToPreview;
            LinkedHashMap<URL, URL> withPreviewHandler = this.prepareWithPreviewURLHandler(filesToPreview, originalUrlsMap);
            if (withPreviewHandler != null) {
                filesToDiff = withPreviewHandler;
            }
            String title = Translator.getInstance().getTranslation("See_Changes");
            String leftDiffLabel = Translator.getInstance().getTranslation("Previous_Version");
            String rightDiffLabel = Translator.getInstance().getTranslation("Proposed_Version");
            if (filesToDiff.size() == 1) {
                boolean changesApplyed;
                boolean allowCopyChangesInDiff;
                Map.Entry<URL, URL> firstEntry = filesToDiff.entrySet().iterator().next();
                URL originalURL = firstEntry.getKey();
                URL changedURL = firstEntry.getValue();
                boolean bl = allowCopyChangesInDiff = enableCopyChangesFromLeftToRight && originalUrlsMap.size() == 1;
                if (allowCopyChangesInDiff) {
                    changedURL = originalUrlsMap.entrySet().iterator().next().getValue();
                    title = Translator.getInstance().getTranslation("Review_Changes");
                }
                if (changesApplyed = DiffPresenter.doShowDiff(title, originalURL, leftDiffLabel, enableCopyChangesFromRightToLeft, changedURL, rightDiffLabel, enableCopyChangesFromLeftToRight)) {
                    acceptedChanges.add(changedURL);
                }
            } else {
                List<URL> chosenURLs = this.openPreviewDialog(Translator.getInstance().getTranslation("Changes"), Translator.getInstance().getTranslation("Accept_Changes"), Translator.getInstance().getTranslation("Current_diff"), Translator.getInstance().getTranslation("Proposed_changes"), filesToDiff);
                chosenURLs = this.unwrapPreviewHandlerProtocol(chosenURLs);
                acceptedChanges.addAll(Optional.ofNullable(chosenURLs).orElse(Collections.emptyList()).stream().map(originalUrlsMap::get).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.disposePreviewHandlerCache();
            tmpFiles.forEach(File::delete);
        }
        return acceptedChanges;
    }

    private void createTemporaryFilesFromChanges(Set<DocumentChange> changesToSee, List<File> tmpFiles, LinkedHashMap<URL, URL> filesToPreview, LinkedHashMap<URL, URL> originalUrlsMap) {
        changesToSee.forEach(change -> {
            try {
                File oldTmpFile = new File(FileSystemUtil.getOxygenTempDirectory(), FileSystemUtil.getName((String)change.getDocURL().toExternalForm()));
                File currentTmpFile = new File(FileSystemUtil.getOxygenTempDirectory(), "current-" + FileSystemUtil.getName((String)change.getDocURL().toExternalForm()));
                ToolsDocumentsChangesManagerBase.writeToURL(change.getPreviousContent() != null ? change.getPreviousContent() : "", URLUtil.correct((File)oldTmpFile));
                ToolsDocumentsChangesManagerBase.writeToURL(change.getNewContent() != null ? change.getNewContent() : "", URLUtil.correct((File)currentTmpFile));
                tmpFiles.add(oldTmpFile);
                tmpFiles.add(currentTmpFile);
                originalUrlsMap.put(URLUtil.correct((File)oldTmpFile), change.getDocURL());
                filesToPreview.put(URLUtil.correct((File)oldTmpFile), URLUtil.correct((File)currentTmpFile));
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    protected abstract List<URL> unwrapPreviewHandlerProtocol(List<URL> var1);

    protected abstract void disposePreviewHandlerCache();

    protected abstract LinkedHashMap<URL, URL> prepareWithPreviewURLHandler(LinkedHashMap<URL, URL> var1, LinkedHashMap<URL, URL> var2) throws MalformedURLException;

    static void writeToURL(String content, URL urlToWriteTo) throws IOException {
        EncodingDetectorInterface encodingDetector = EncodingDetector.getInstance();
        String javaEncoding = encodingDetector.getJavaEncoding((Reader)new StringReader(content), false, new ArrayList());
        try (OutputStream outputStreamFromURL = URLUtil.openOutputStream((URL)urlToWriteTo);
             OutputStreamWriter writerWithEncoding = new OutputStreamWriter(outputStreamFromURL, javaEncoding != null ? javaEncoding : StandardCharsets.UTF_8.name());){
            writerWithEncoding.write(content);
        }
    }

    public boolean hasChanges(String toolId) {
        return !this.toolsDocumentChanges.getOrDefault(toolId, Collections.emptySet()).isEmpty();
    }

    public boolean hasChangesWhichCanBeApproved() {
        return this.toolsDocumentChanges.values().stream().anyMatch(docChanges -> docChanges.stream().anyMatch(docChange -> docChange != null && docChange.isCanDiscardChange()));
    }

    protected abstract List<URL> openPreviewDialog(String var1, String var2, String var3, String var4, LinkedHashMap<URL, URL> var5) throws Exception;

    public void rollback(Collection<String> toolIds) {
        Map<URL, Set<DocumentChange>> changesMap = this.groupChangesByDocumentURL(toolIds);
        Set<DocumentChange> changesToDiscard = this.computeLatestToNewestChanges(changesMap);
        HashSet<DocumentChange> notSuccesfullyDiscarded = new HashSet<DocumentChange>(changesToDiscard);
        List<DocumentChange> succesfullyDiscarded = this.discardIfPossible(changesToDiscard);
        notSuccesfullyDiscarded.removeAll(succesfullyDiscarded);
        changesMap.values().forEach(changes -> changes.forEach(change -> {
            if (!notSuccesfullyDiscarded.contains(change)) {
                change.setCanDiscardChange(false);
            }
        }));
    }

    public void seeChanges(Collection<String> toolIds) {
        Map<URL, Set<DocumentChange>> changesMap = this.groupChangesByDocumentURL(toolIds);
        Set<DocumentChange> changesToPreview = this.computeLatestToNewestChanges(changesMap);
        List<URL> changesToKeep = this.showDocumentsChanges(changesToPreview, false, false);
        changesToKeep.forEach(urlToKeep -> toolIds.forEach(toolId -> {
            Set changes = this.toolsDocumentChanges.getOrDefault(toolId, Collections.emptySet());
            changes.removeIf(change -> Objects.equals(change.getDocURL(), urlToKeep));
            this.toolsDocumentChanges.put((String)toolId, changes);
            if (changes.isEmpty()) {
                this.toolsDocumentChanges.remove(toolId);
            }
        }));
        this.notifyChangeListeners();
    }

    private Map<URL, Set<DocumentChange>> groupChangesByDocumentURL(Collection<String> toolIds) {
        LinkedHashMap<URL, Set<DocumentChange>> changesMap = new LinkedHashMap<URL, Set<DocumentChange>>();
        toolIds.forEach(toolId -> {
            Set<DocumentChange> changes = this.toolsDocumentChanges.getOrDefault(toolId, Collections.emptySet());
            changes.forEach(change -> {
                if (!changesMap.containsKey(change.getDocURL())) {
                    changesMap.put(change.getDocURL(), new LinkedHashSet());
                }
                ((Set)changesMap.get(change.getDocURL())).add(change);
            });
        });
        return changesMap;
    }

    private Set<DocumentChange> computeLatestToNewestChanges(Map<URL, Set<DocumentChange>> changesMap) {
        LinkedHashSet<DocumentChange> changesToPreview = new LinkedHashSet<DocumentChange>();
        changesMap.forEach((docURL, changes) -> {
            ArrayList sortedChanges = new ArrayList(changes);
            if (sortedChanges.size() > 1) {
                DocumentChange oldestChange = (DocumentChange)sortedChanges.get(0);
                DocumentChange mostRecentChange = (DocumentChange)sortedChanges.get(sortedChanges.size() - 1);
                DocumentChange mergedChange = new DocumentChange((URL)docURL, oldestChange.getPreviousContent(), mostRecentChange.getNewContent(), false);
                changesToPreview.add(mergedChange);
            } else if (sortedChanges.size() == 1) {
                changesToPreview.add((DocumentChange)sortedChanges.get(0));
            }
        });
        return changesToPreview;
    }

    public boolean hasChanges() {
        return this.toolsDocumentChanges.keySet().stream().anyMatch(this::hasChanges);
    }

    private String getDocumentContent(URL docURL) {
        try {
            return FunctionsAndRAGHelperProvider.getProjectRAGHelper().getDocumentContent(docURL.toExternalForm(), null);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected abstract DocumentChangesApprovalCallback getDocumentChangesApprovalCallback(String var1, boolean var2);

    public void setChatInteractor(ChatInteractor chatInteractor) {
        this.chatInteractor = chatInteractor;
    }

    public void executeOnClearChanges(Runnable clearChangesRunnable) {
        this.clearChangesListeners.add(clearChangesRunnable);
    }

    public void setChatScrollUpdater(ChatScrollUpdater scrollUpdater) {
        this.scrollUpdater = scrollUpdater;
    }
}

