/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.functions;

import com.oxygenxml.positron.functions.DefaultDocumentChangesApprovalCallback;
import com.oxygenxml.positron.functions.DocumentChangesApprovalCallback;
import com.oxygenxml.positron.functions.ToolsDocumentsChangesManagerBase;
import com.oxygenxml.positron.plugin.diff.PreviewURLHandler;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.DiffAndMergeTools;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;

public class ToolsDocumentsChangesManager
extends ToolsDocumentsChangesManagerBase {
    private static final Logger log = LoggerFactory.getLogger(ToolsDocumentsChangesManager.class);

    @Override
    protected List<URL> openPreviewDialog(String dialogTitle, String updateButtonText, String leftSideLabelText, String rightSideLabelText, LinkedHashMap<URL, URL> filesToPreview) throws Exception {
        List result = Collections.emptyList();
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWorkspace instanceof StandalonePluginWorkspace) {
            try {
                Method openPreviewChangesDialogMethod = DiffAndMergeTools.class.getMethod("openPreviewDialog", String.class, String.class, String.class, String.class, String.class, LinkedHashMap.class);
                if (openPreviewChangesDialogMethod != null) {
                    result = (List)openPreviewChangesDialogMethod.invoke((Object)pluginWorkspace, dialogTitle, updateButtonText, null, leftSideLabelText, rightSideLabelText, filesToPreview);
                }
            }
            catch (Exception e) {
                result = ((StandalonePluginWorkspace)pluginWorkspace).openPreviewDialog(dialogTitle, rightSideLabelText, filesToPreview);
            }
        }
        return result;
    }

    @Override
    protected DocumentChangesApprovalCallback getDocumentChangesApprovalCallback(String approvalMessage, boolean forceShowReviewChangesDialog) {
        return new DefaultDocumentChangesApprovalCallback(approvalMessage, forceShowReviewChangesDialog);
    }

    @Override
    protected LinkedHashMap<URL, URL> prepareWithPreviewURLHandler(LinkedHashMap<URL, URL> filesToPreview, LinkedHashMap<URL, URL> originalUrlsMap) throws MalformedURLException {
        LinkedHashMap<URL, URL> filesToDiff = null;
        LinkedHashMap<URL, URL> filesToPreviewWithCustomPreviewProtocol = new LinkedHashMap<URL, URL>();
        final LinkedHashMap<URL, URL> previewURLToOld = new LinkedHashMap<URL, URL>();
        final LinkedHashMap<URL, URL> previewURLToNew = new LinkedHashMap<URL, URL>();
        for (Map.Entry<URL, URL> toPreview : filesToPreview.entrySet()) {
            URL oldUrl = toPreview.getKey();
            URL url = originalUrlsMap.get(oldUrl);
            URL original = PreviewURLHandler.encodeURL("before", url.toString());
            URL changed = PreviewURLHandler.encodeURL("after", url.toString());
            filesToPreviewWithCustomPreviewProtocol.put(original, changed);
            previewURLToOld.put(original, oldUrl);
            previewURLToNew.put(changed, toPreview.getValue());
        }
        filesToDiff = filesToPreviewWithCustomPreviewProtocol;
        PreviewURLHandler.setBeforeAfterSuppliers(new Function<URL, URL>(){

            @Override
            public URL apply(URL url) {
                return (URL)previewURLToOld.get(url);
            }
        }, new Function<URL, URL>(){

            @Override
            public URL apply(URL url) {
                return (URL)previewURLToNew.get(url);
            }
        });
        return filesToDiff;
    }

    @Override
    protected void disposePreviewHandlerCache() {
        PreviewURLHandler.setBeforeAfterSuppliers(null, null);
    }

    @Override
    protected List<URL> unwrapPreviewHandlerProtocol(List<URL> chosenURLs) {
        if (chosenURLs != null) {
            try {
                ArrayList<URL> chosenUnwrapped = new ArrayList<URL>();
                for (URL url : chosenURLs) {
                    URL afterURL = PreviewURLHandler.resolveToTempFileBeforeChangeURL(url);
                    if (afterURL != null) {
                        chosenUnwrapped.add(afterURL);
                        continue;
                    }
                    throw new IOException("Could not locate temp file for: " + url);
                }
                chosenURLs = chosenUnwrapped;
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
        return chosenURLs;
    }
}

