/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.functions;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.functions.DocumentChange;
import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.TextUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.PopupMenu;

public class DocumentChangesList
extends JList<DocumentChange> {
    private static final Translator I18N = Translator.getInstance();
    private static final ImageIcon REMOVE_CHANGE = IconsLoader.loadIcon("/images/RejectChanges12.png");
    private static final ImageIcon KEEP_CHANGE = IconsLoader.loadIcon("/images/KeepChanges12.png");
    private static final ImageIcon REVIEW_CHANGE = IconsLoader.loadIcon("/images/ReviewChanges12.png");
    private static final ImageIcon FILE_ADDED = IconsLoader.loadIcon("/images/FileAdded12.png");
    private static final ImageIcon FILE_MODIFIED = IconsLoader.loadIcon("/images/FileModified12.png");
    private static final int INDEX_OF_REVIEW_CHANGE_BUTTON = 0;
    private static final int INDEX_OF_KEEP_CHANGE_BUTTON = 1;
    private static final int INDEX_OF_REJECT_CHANGE_BUTTON = 2;
    private static final AbstractAction REVIEW_CHANGE_DUMMY_ACTION = new AbstractAction(I18N.getTranslation("Review_changes_sentence_capitalization"), REVIEW_CHANGE){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    private static final AbstractAction KEEP_CHANGE_DUMMY_ACTION = new AbstractAction(I18N.getTranslation("Keep_changes"), KEEP_CHANGE){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    private static final AbstractAction REJECT_CHANGE_DUMMY_ACTION = new AbstractAction(I18N.getTranslation("Reject_Changes"), REMOVE_CHANGE){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    private static final Insets RENDERER_LABEL_INSETS = new Insets(5, 5, 5, 5);
    private static final Insets RENDERER_ZERO_INSETS = new Insets(0, 0, 0, 0);
    private static final Insets RENDERER_BUTTON_INSETS = new Insets(5, 0, 5, 3);
    private static final Insets RENDERER_LAST_BUTTON_INSETS = new Insets(5, 0, 5, 5);
    private final DefaultListModel<DocumentChange> model = new DefaultListModel();
    private Consumer<DocumentChange> onDoubleClick;
    private Runnable onListEmpty;
    private final boolean darkTheme = PluginWorkspaceProvider.getPluginWorkspace().getColorTheme().isDarkTheme();
    private int hoveredIndex = -1;
    private int hoveredButtonIndex = -1;
    private int hoveredButtonListItemIndex = -1;
    private Consumer<DocumentChange> onKeepOnItem;
    private Consumer<DocumentChange> onRejectOnItem;

    public DocumentChangesList(List<DocumentChange> changes) {
        this.model.addAll(changes);
        this.setModel(this.model);
        this.setSelectionMode(0);
        this.setupCellRenderer();
        this.setupModelEmptyListener();
        this.setupDoubleClickListener();
        this.installListItemButtonInteractionHandlers();
        this.setupContextulMenu();
    }

    private void setupContextulMenu() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseReleased(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int index;
                if (e.isPopupTrigger() && DocumentChangesList.this.hoveredButtonListItemIndex == -1 && (index = DocumentChangesList.this.locationToIndex(e.getPoint())) != -1) {
                    e.consume();
                    DocumentChangesList.this.setSelectedIndex(index);
                    PopupMenu contextualMenu = OxygenUIComponentsFactory.createPopupMenu();
                    contextualMenu.add(new AbstractAction(I18N.getTranslation("Review_changes_sentence_capitalization"), IconsLoader.loadIcon("/images/ManageReviews16.png")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Optional.ofNullable(DocumentChangesList.this.onDoubleClick).ifPresent(t -> t.accept(DocumentChangesList.this.model.getElementAt(index)));
                        }
                    });
                    contextualMenu.add(new AbstractAction(I18N.getTranslation("Keep_changes"), IconsLoader.loadIcon("/images/KeepChanges16.png")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Optional.ofNullable(DocumentChangesList.this.onKeepOnItem).ifPresent(t -> t.accept(DocumentChangesList.this.model.getElementAt(index)));
                        }
                    });
                    contextualMenu.add(new AbstractAction(I18N.getTranslation("Reject_Changes"), IconsLoader.loadIcon("/images/RejectChanges16.png")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Optional.ofNullable(DocumentChangesList.this.onRejectOnItem).ifPresent(t -> t.accept(DocumentChangesList.this.model.getElementAt(index)));
                        }
                    });
                    contextualMenu.show(DocumentChangesList.this, e.getX(), e.getY());
                }
            }
        });
    }

    private void installListItemButtonInteractionHandlers() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int newHoveredIndex = DocumentChangesList.this.locationToIndex(e.getPoint());
                boolean needsRepaint = false;
                if (newHoveredIndex != DocumentChangesList.this.hoveredIndex) {
                    DocumentChangesList.this.hoveredIndex = newHoveredIndex;
                    needsRepaint = true;
                }
                int newHoveredButtonItemIndex = -1;
                int newHoveredButtonIndex = DocumentChangesList.this.findHoveredButtonIndex(e);
                if (newHoveredButtonIndex != -1) {
                    newHoveredButtonItemIndex = newHoveredIndex;
                }
                if (newHoveredButtonIndex != DocumentChangesList.this.hoveredButtonIndex || newHoveredButtonItemIndex != DocumentChangesList.this.hoveredButtonListItemIndex) {
                    DocumentChangesList.this.hoveredButtonIndex = newHoveredButtonIndex;
                    DocumentChangesList.this.hoveredButtonListItemIndex = newHoveredButtonItemIndex;
                    needsRepaint = true;
                    if (DocumentChangesList.this.hoveredButtonIndex != -1) {
                        DocumentChangesList.this.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        DocumentChangesList.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
                if (needsRepaint) {
                    DocumentChangesList.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                DocumentChangesList.this.hoveredIndex = -1;
                DocumentChangesList.this.hoveredButtonIndex = -1;
                DocumentChangesList.this.hoveredButtonListItemIndex = -1;
                DocumentChangesList.this.setCursor(Cursor.getDefaultCursor());
                DocumentChangesList.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (SwingUtilities.isLeftMouseButton(e) && (index = DocumentChangesList.this.locationToIndex(e.getPoint())) != -1) {
                    int clickedButtonIndex = DocumentChangesList.this.findHoveredButtonIndex(e);
                    switch (clickedButtonIndex) {
                        case 0: {
                            DocumentChangesList.this.handleReviewChange(index);
                            e.consume();
                            break;
                        }
                        case 1: {
                            DocumentChangesList.this.handleKeepChange(index);
                            e.consume();
                            break;
                        }
                        case 2: {
                            DocumentChangesList.this.handleRejectChange(index);
                            e.consume();
                        }
                    }
                }
            }
        });
    }

    public int findHoveredButtonIndex(MouseEvent e) {
        Rectangle cellBounds;
        int index = this.locationToIndex(e.getPoint());
        if (index != -1 && (cellBounds = this.getCellBounds(index, index)) != null) {
            Point clickPoint = new Point(e.getX() - cellBounds.x, e.getY() - cellBounds.y);
            Component rendererComponent = this.getCellRenderer().getListCellRendererComponent(this, this.model.getElementAt(index), index, false, false);
            if (rendererComponent instanceof JPanel) {
                JPanel panel = (JPanel)rendererComponent;
                panel.setSize(cellBounds.width, cellBounds.height);
                panel.doLayout();
                return this.findHoveredButtonIndexInPanel(panel, clickPoint);
            }
        }
        return -1;
    }

    private void setupModelEmptyListener() {
        this.model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                if (DocumentChangesList.this.onListEmpty != null && DocumentChangesList.this.model.isEmpty()) {
                    DocumentChangesList.this.onListEmpty.run();
                }
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
    }

    private void setupCellRenderer() {
        this.setCellRenderer(new ListCellRenderer<DocumentChange>(){
            private final ListCellRenderer<? super DocumentChange> defaultCellRenderer;
            private boolean currentIsSelected;
            private boolean currentIsHovered;
            private final JLabel fileNameLabel;
            private final JButton reviewButton;
            private final JButton keepButton;
            private final JButton rejectButton;
            private final JLabel glue;
            private final JPanel rendererPanel;
            private final int cachedButtonWidth;
            private final int cachedLabelIconWidth;
            private FontMetrics cachedFontMetrics;
            {
                this.defaultCellRenderer = DocumentChangesList.this.getCellRenderer();
                this.fileNameLabel = this.createFileNameLabel();
                this.reviewButton = OxygenUIComponentsFactory.createToolbarButton((Action)REVIEW_CHANGE_DUMMY_ACTION, (boolean)false);
                this.keepButton = OxygenUIComponentsFactory.createToolbarButton((Action)KEEP_CHANGE_DUMMY_ACTION, (boolean)false);
                this.rejectButton = OxygenUIComponentsFactory.createToolbarButton((Action)REJECT_CHANGE_DUMMY_ACTION, (boolean)false);
                this.glue = new JLabel();
                this.rendererPanel = this.createInternalRendererComponentPanel();
                this.cachedButtonWidth = this.computeButtonWidth(this.keepButton);
                this.cachedLabelIconWidth = FILE_MODIFIED.getIconWidth() + this.fileNameLabel.getIconTextGap();
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends DocumentChange> list, DocumentChange value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value != null) {
                    this.currentIsSelected = isSelected;
                    this.currentIsHovered = DocumentChangesList.this.hoveredIndex == index && !isSelected;
                    this.updateButtonStyle(this.reviewButton, index, 0);
                    this.updateButtonStyle(this.keepButton, index, 1);
                    this.updateButtonStyle(this.rejectButton, index, 2);
                    this.fileNameLabel.setIcon(value.getPreviousContent() == null ? FILE_ADDED : FILE_MODIFIED);
                    int availableLabelWidth = this.computeAvailableLabelWidth(list, this.cachedLabelIconWidth, this.cachedButtonWidth);
                    int availableTextWidth = Math.max(50, availableLabelWidth - this.cachedLabelIconWidth);
                    if (this.cachedFontMetrics == null) {
                        this.cachedFontMetrics = this.fileNameLabel.getFontMetrics(this.fileNameLabel.getFont());
                    }
                    String fileName = URLUtil.extractFileName((URL)value.getDocURL());
                    String displayText = TextUtil.getTruncatedText(fileName, this.cachedFontMetrics, availableTextWidth);
                    this.fileNameLabel.setText(URLUtil.uncorrect((String)displayText));
                    int labelHeight = this.fileNameLabel.getPreferredSize().height;
                    this.fileNameLabel.setPreferredSize(new Dimension(this.cachedLabelIconWidth + availableTextWidth, labelHeight));
                    this.fileNameLabel.setMinimumSize(new Dimension(this.cachedLabelIconWidth + 50, labelHeight));
                    return this.rendererPanel;
                }
                return this.defaultCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }

            private JLabel createFileNameLabel() {
                JLabel lbl = new JLabel();
                lbl.setBorder(null);
                lbl.setOpaque(false);
                return lbl;
            }

            private JPanel createInternalRendererComponentPanel() {
                JPanel p = new JPanel(){

                    @Override
                    protected void paintComponent(Graphics g) {
                        if (currentIsSelected || currentIsHovered) {
                            Graphics2D g2 = (Graphics2D)g.create();
                            try {
                                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                if (currentIsSelected) {
                                    g2.setColor(ThemeColorProvider.getInstance().getListItemSelectedColor());
                                } else {
                                    g2.setColor(ThemeColorProvider.getInstance().getListItemHoverColor());
                                }
                                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                            }
                            finally {
                                g2.dispose();
                            }
                        }
                        super.paintComponent(g);
                    }
                };
                p.setOpaque(false);
                p.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 0;
                c.weightx = 0.0;
                c.anchor = 17;
                c.fill = 0;
                c.insets = RENDERER_LABEL_INSETS;
                p.add((Component)this.fileNameLabel, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.fill = 2;
                c.insets = RENDERER_ZERO_INSETS;
                p.add((Component)this.glue, c);
                ++c.gridx;
                c.weightx = 0.0;
                c.fill = 0;
                c.anchor = 13;
                c.insets = RENDERER_BUTTON_INSETS;
                p.add((Component)this.reviewButton, c);
                ++c.gridx;
                p.add((Component)this.keepButton, c);
                ++c.gridx;
                c.insets = RENDERER_LAST_BUTTON_INSETS;
                p.add((Component)this.rejectButton, c);
                return p;
            }

            private int computeAvailableLabelWidth(JList<? extends DocumentChange> list, int listItemIconSpace, int buttonWidth) {
                int listWidth = this.getListWidth(list);
                int totalButtonsWidth = buttonWidth * 3;
                int horizontalInsets = 15;
                int glueMinSpace = 10;
                return listWidth - totalButtonsWidth - horizontalInsets - glueMinSpace;
            }

            private int computeButtonWidth(JButton tempButton) {
                int width = tempButton.getPreferredSize().width;
                return width > 0 ? width : 12;
            }

            private int getListWidth(JList<? extends DocumentChange> list) {
                int listWidth = list.getWidth();
                if (listWidth <= 0) {
                    listWidth = list.getVisibleRect().width;
                }
                if (listWidth <= 0) {
                    int n = listWidth = list.getParent() != null ? list.getParent().getWidth() : 0;
                }
                if (listWidth <= 0) {
                    listWidth = 200;
                }
                return listWidth;
            }

            private void updateButtonStyle(JButton button, int index, int buttonIndex) {
                boolean isButtonHovered;
                boolean bl = isButtonHovered = index == DocumentChangesList.this.hoveredButtonListItemIndex && DocumentChangesList.this.hoveredButtonIndex == buttonIndex;
                if (isButtonHovered) {
                    button.setOpaque(true);
                    button.setBackground(ThemeColorProvider.getInstance().getListItemButtonsBackgroundColor());
                    button.setBorder(BorderFactory.createLineBorder(DocumentChangesList.this.darkTheme ? Color.LIGHT_GRAY : Color.GRAY, 1));
                } else {
                    button.setOpaque(false);
                    button.setBackground(null);
                    button.setBorder(null);
                }
            }
        });
    }

    private void setupDoubleClickListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && DocumentChangesList.this.hoveredButtonListItemIndex == -1) {
                    DocumentChangesList.this.handleReviewChange(DocumentChangesList.this.locationToIndex(e.getPoint()));
                }
            }
        });
    }

    public void removeChangesByUrls(List<URL> acceptedUrls) {
        for (int i = this.model.getSize() - 1; i >= 0; --i) {
            DocumentChange change = this.model.getElementAt(i);
            if (!acceptedUrls.contains(change.getDocURL())) continue;
            this.model.remove(i);
        }
    }

    public List<DocumentChange> getRemainingChanges() {
        return IntStream.range(0, this.model.getSize()).mapToObj(this.model::getElementAt).collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return this.model.isEmpty();
    }

    public void setOnDoubleClick(Consumer<DocumentChange> onDoubleClick) {
        this.onDoubleClick = onDoubleClick;
    }

    public void setOnListEmpty(Runnable onListEmpty) {
        this.onListEmpty = onListEmpty;
    }

    @Override
    public DefaultListModel<DocumentChange> getModel() {
        return this.model;
    }

    public void setDataModel(List<DocumentChange> data) {
        this.model.clear();
        this.model.addAll(data);
    }

    @Override
    public JToolTip createToolTip() {
        return OxygenUIComponentsFactory.installMultilineTooltip((JComponent)this);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String tooltipText = super.getToolTipText(e);
        int index = this.locationToIndex(e.getPoint());
        if (index != -1) {
            int hoveredButtonIndex = this.findHoveredButtonIndex(e);
            switch (hoveredButtonIndex) {
                case 0: {
                    tooltipText = I18N.getTranslation("Review_changes_sentence_capitalization");
                    break;
                }
                case 1: {
                    tooltipText = I18N.getTranslation("Keep_all_changes");
                    break;
                }
                case 2: {
                    tooltipText = I18N.getTranslation("Reject_all_changes");
                    break;
                }
                default: {
                    DocumentChange change = this.model.getElementAt(index);
                    tooltipText = URLUtil.getDescription((URL)change.getDocURL());
                }
            }
        }
        return tooltipText;
    }

    private int findHoveredButtonIndexInPanel(JPanel panel, Point cellPoint) {
        int buttonCount = 0;
        for (Component comp : panel.getComponents()) {
            if (!(comp instanceof JButton)) continue;
            if (comp.getBounds() != null && comp.getBounds().contains(cellPoint)) {
                return buttonCount;
            }
            ++buttonCount;
        }
        return -1;
    }

    private void handleKeepChange(int index) {
        if (this.onKeepOnItem != null && index >= 0 && index < this.model.getSize()) {
            this.onKeepOnItem.accept(this.model.getElementAt(index));
        }
    }

    private void handleRejectChange(int index) {
        if (this.onRejectOnItem != null && index >= 0 && index < this.model.getSize()) {
            this.onRejectOnItem.accept(this.model.getElementAt(index));
        }
    }

    private void handleReviewChange(int index) {
        if (this.onDoubleClick != null && index >= 0 && index < this.model.getSize()) {
            this.onDoubleClick.accept(this.model.getElementAt(index));
        }
    }

    public void setOnKeepAtListEntry(Consumer<DocumentChange> onKeepOnItem) {
        this.onKeepOnItem = onKeepOnItem;
    }

    public void setOnRejectAtListEntry(Consumer<DocumentChange> onRejectOnItem) {
        this.onRejectOnItem = onRejectOnItem;
    }
}

