/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.functions;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.functions.DocumentChange;
import com.oxygenxml.positron.functions.DocumentChangesList;
import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class DocumentChangesCollapsablePanel
extends JPanel {
    private static final int MAX_VISIBLE_ROWS_IN_LIST = 3;
    private static final Translator I18N = Translator.getInstance();
    private boolean isExpanded = true;
    private JLabel expandCollapseLabel = new JLabel(I18N.getTranslation("Waiting_for_approval"), this.computeIcon(), 0);
    private static final ThemeColorProvider THEME = ThemeColorProvider.getInstance();
    private DocumentChangesList list;
    JScrollPane scrollPane;
    private Runnable onAcceptAll;
    private Runnable onRejectAll;
    private Consumer<Boolean> onExpandCollapseCallback;

    public DocumentChangesCollapsablePanel(List<DocumentChange> changes) {
        this.list = new DocumentChangesList(changes);
        this.list.setVisibleRowCount(this.computeVisibleRowsForList());
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 5);
        this.expandCollapseLabel.setToolTipText(I18N.getTranslation("Waiting_for_approval"));
        this.add((Component)this.expandCollapseLabel, c);
        JPanel filler = new JPanel();
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)filler, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        JButton accept = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction(I18N.getTranslation("Keep_all")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DocumentChangesCollapsablePanel.this.onAcceptAll != null) {
                    DocumentChangesCollapsablePanel.this.onAcceptAll.run();
                }
            }
        }, (boolean)true);
        accept.setToolTipText(null);
        this.setTopButtonsStyle(accept);
        this.add((Component)accept, c);
        ++c.gridx;
        c.insets.left = 0;
        JButton reject = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction(I18N.getTranslation("Reject_all")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DocumentChangesCollapsablePanel.this.onRejectAll != null) {
                    DocumentChangesCollapsablePanel.this.onRejectAll.run();
                }
            }
        }, (boolean)true);
        reject.setToolTipText(null);
        this.setTopButtonsStyle(reject);
        this.add((Component)reject, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 4;
        c.anchor = 17;
        c.fill = 1;
        c.insets.left = 5;
        c.insets.top = 0;
        this.scrollPane = OxygenUIComponentsFactory.createScrollPane((Component)this.list, (int)20, (int)31);
        this.scrollPane.setBorder(null);
        this.add((Component)this.scrollPane, c);
        this.scrollPane.setVisible(this.isExpanded);
        this.setComponentsSizesToFit();
        MouseAdapter expandCollapsMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DocumentChangesCollapsablePanel.this.isExpanded = !DocumentChangesCollapsablePanel.this.isExpanded;
                DocumentChangesCollapsablePanel.this.expandCollapseLabel.setIcon(DocumentChangesCollapsablePanel.this.computeIcon());
                DocumentChangesCollapsablePanel.this.scrollPane.setVisible(DocumentChangesCollapsablePanel.this.isExpanded);
                if (DocumentChangesCollapsablePanel.this.onExpandCollapseCallback != null) {
                    DocumentChangesCollapsablePanel.this.onExpandCollapseCallback.accept(DocumentChangesCollapsablePanel.this.isExpanded);
                }
                DocumentChangesCollapsablePanel.this.revalidate();
                DocumentChangesCollapsablePanel.this.repaint();
            }
        };
        this.expandCollapseLabel.addMouseListener(expandCollapsMouseListener);
        this.expandCollapseLabel.setCursor(Cursor.getPredefinedCursor(12));
        filler.addMouseListener(expandCollapsMouseListener);
        filler.setCursor(Cursor.getPredefinedCursor(12));
        Color backgroundColor = THEME.getMeCardBackgroundColor();
        this.setBackground(backgroundColor);
        this.list.setBackground(backgroundColor);
        this.scrollPane.setBackground(backgroundColor);
        filler.setBackground(backgroundColor);
    }

    private void setComponentsSizesToFit() {
        int visibleRows = this.computeVisibleRowsForList();
        Dimension minSize = new Dimension(this.getPreferredSize().width, visibleRows * this.getRowHeight());
        this.list.setMinimumSize(new Dimension(0, minSize.height));
        this.scrollPane.setMinimumSize(new Dimension(0, minSize.height));
        int nrOfEntries = ((DefaultListModel)this.list.getModel()).getSize();
        Dimension preferredSize = new Dimension(this.getPreferredSize().width, nrOfEntries * this.getRowHeight());
        this.list.setPreferredSize(new Dimension(this.list.getPreferredSize().width, preferredSize.height));
        this.scrollPane.setPreferredSize(new Dimension(this.scrollPane.getPreferredSize().width, preferredSize.height));
    }

    private int getRowHeight() {
        int cellHeight = this.list.getFixedCellHeight();
        if (cellHeight <= 0) {
            cellHeight = this.list.getCellBounds(0, 0) != null ? this.list.getCellBounds((int)0, (int)0).height : 30;
        }
        return cellHeight;
    }

    private void setTopButtonsStyle(JButton button) {
        Color color = ThemeColorProvider.getInstance().getKeepRejectChangesButtonsBackgroundColor();
        button.setBackground(color);
        button.setBorder(BorderFactory.createLineBorder(color, 2));
        button.setBorderPainted(true);
        button.setMargin(new Insets(5, 5, 5, 5));
        button.setOpaque(true);
    }

    private ImageIcon computeIcon() {
        return IconsLoader.loadIcon(this.isExpanded ? "/images/Expanded16.png" : "/images/Collapsed16.png");
    }

    public void setOnListEmpty(Runnable onListEmpty) {
        this.list.setOnListEmpty(onListEmpty);
    }

    public void setOnDoubleClick(Consumer<DocumentChange> callback) {
        this.list.setOnDoubleClick(callback);
    }

    public void setOnAcceptAll(Runnable onAcceptAll) {
        this.onAcceptAll = onAcceptAll;
    }

    public void setOnRejectAll(Runnable onRejectAll) {
        this.onRejectAll = onRejectAll;
    }

    public void setOnKeepAtListEntry(Consumer<DocumentChange> onKeepOnItem) {
        this.list.setOnKeepAtListEntry(onKeepOnItem);
    }

    public void setOnRejectAtListEntry(Consumer<DocumentChange> onRejectOnItem) {
        this.list.setOnRejectAtListEntry(onRejectOnItem);
    }

    public void setDataModel(List<DocumentChange> data) {
        this.list.setDataModel(data);
    }

    public void removeReviewedDocumentChangeFromView(DocumentChange item) {
        ((DefaultListModel)this.list.getModel()).removeElement(item);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DocumentChangesCollapsablePanel.this.setComponentsSizesToFit();
                DocumentChangesCollapsablePanel.this.scrollPane.revalidate();
                DocumentChangesCollapsablePanel.this.revalidate();
                DocumentChangesCollapsablePanel.this.scrollPane.repaint();
                DocumentChangesCollapsablePanel.this.repaint();
            }
        });
    }

    private int computeVisibleRowsForList() {
        return Math.min(3, ((DefaultListModel)this.list.getModel()).getSize());
    }

    public List<DocumentChange> getRemainingChanges() {
        return this.list.getRemainingChanges();
    }

    public void setOnExpandCollapseCallback(Consumer<Boolean> callback) {
        this.onExpandCollapseCallback = callback;
    }
}

