/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.functions;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.tools.ToolsSessionManager;
import com.oxygenxml.positron.functions.ConfirmToolsDocumentChangesDialog;
import com.oxygenxml.positron.functions.DocumentChange;
import com.oxygenxml.positron.functions.DocumentChangesApprovalCallback;
import com.oxygenxml.positron.functions.DocumentChangesApprovalCallbackResult;
import com.oxygenxml.positron.functions.ToolsDocumentsChangesManagerBase;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class DefaultDocumentChangesApprovalCallback
implements DocumentChangesApprovalCallback {
    private static final Translator I18N = Translator.getInstance();
    private static final int CONTINUE_IN_CHAT_OPTION = 1;
    private static final int REJECT_CHANGES_OPTION = 2;
    private String approvalMessage;
    private boolean forceShowReviewChangesDialog;

    public DefaultDocumentChangesApprovalCallback(String approvalMessage, boolean forceShowReviewChangesDialog) {
        this.approvalMessage = approvalMessage;
        this.forceShowReviewChangesDialog = forceShowReviewChangesDialog;
    }

    @Override
    public DocumentChangesApprovalCallbackResult requestUserApproval(List<DocumentChange> changedDocuments) {
        if (!this.forceShowReviewChangesDialog && changedDocuments.stream().map(DocumentChange::getDocURL).distinct().count() == 1L) {
            return this.reviewIndependentChanges(changedDocuments);
        }
        ConfirmToolsDocumentChangesDialog dialog = new ConfirmToolsDocumentChangesDialog(changedDocuments, this.approvalMessage);
        dialog.setVisible(true);
        return this.createDocumentChangesApprovalCallbackResult(dialog.getAcceptedChangesByUser(), dialog.getRejectedChangesByUser());
    }

    private DocumentChangesApprovalCallbackResult reviewIndependentChanges(List<DocumentChange> changedDocuments) {
        ToolsDocumentsChangesManagerBase changesManager = (ToolsDocumentsChangesManagerBase)ToolsSessionManager.getInstance().getToolsDocumentsChangesManager();
        List<URL> acceptedDocumentChanges = changesManager.showDocumentsChanges(new LinkedHashSet<DocumentChange>(changedDocuments), false, true);
        List<DocumentChange> acceptedChanges = Collections.emptyList();
        List<DocumentChange> rejectedChanges = Collections.emptyList();
        boolean userClosedDiffWithoutApplyingChnages = acceptedDocumentChanges.isEmpty();
        if (userClosedDiffWithoutApplyingChnages) {
            int showConfirmDialog = PluginWorkspaceProvider.getPluginWorkspace().showConfirmDialog(I18N.getTranslation("Review_In_Progress"), I18N.getTranslation("Review_not_completed_Continue_in_chat_or_reject"), new String[]{I18N.getTranslation("Continue_in_chat"), I18N.getTranslation("Reject_Changes")}, new int[]{1, 2});
            if (showConfirmDialog == 2) {
                rejectedChanges = changedDocuments;
            }
        } else {
            acceptedChanges = changedDocuments;
        }
        return this.createDocumentChangesApprovalCallbackResult(acceptedChanges, rejectedChanges);
    }

    private DocumentChangesApprovalCallbackResult createDocumentChangesApprovalCallbackResult(final Collection<DocumentChange> acceptedChanges, final Collection<DocumentChange> rejectedChanges) {
        return new DocumentChangesApprovalCallbackResult(){

            @Override
            public Collection<DocumentChange> getRejectedChanges() {
                return rejectedChanges;
            }

            @Override
            public Collection<DocumentChange> getAcceptedChanges() {
                return acceptedChanges;
            }
        };
    }
}

