/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connection.ui;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.ui.LinkLabel;
import com.oxygenxml.positron.plugin.ui.MultilineLabel;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.MessageFormat;
import java.util.Optional;
import javax.swing.JPanel;

public class EmailNotVerifiedPanel
extends JPanel {
    private MultilineLabel accountValidationDescription;

    public EmailNotVerifiedPanel(Runnable refreshAction, Runnable resendEmailAction) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = UIUtil.getSpacingInsets();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        constraints.insets.top = 11;
        Translator translator = Translator.getInstance();
        this.add((Component)new MultilineLabel(translator.getTranslation("Verify_your_email"), true), constraints);
        constraints.insets.top = 5;
        ++constraints.gridy;
        this.accountValidationDescription = new MultilineLabel();
        this.add((Component)this.accountValidationDescription, constraints);
        constraints.fill = 0;
        ++constraints.gridy;
        this.add((Component)this.createLinkLabel(translator.getTranslation("Refresh"), refreshAction), constraints);
        ++constraints.gridy;
        this.add((Component)this.createLinkLabel(translator.getTranslation("Resend_email"), resendEmailAction), constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = UIUtil.getNoInsets();
        this.add((Component)new JPanel(), constraints);
    }

    private LinkLabel createLinkLabel(String text, final Runnable toRunOnClick) {
        LinkLabel label = new LinkLabel(text){

            @Override
            public void performAction() {
                Optional.ofNullable(toRunOnClick).ifPresent(Runnable::run);
            }
        };
        label.setHorizontalAlignment(2);
        return label;
    }

    public void updateUser(String userEmail) {
        this.accountValidationDescription.setText(MessageFormat.format(Translator.getInstance().getTranslation("Account_not_verified_description"), userEmail));
    }
}

