/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.actions.dialog.internal;

import com.oxygenxml.positron.actions.dialog.internal.DialogInfo;
import com.oxygenxml.positron.actions.dialog.internal.DialogType;
import com.oxygenxml.positron.actions.dialog.internal.MessageDialog;
import java.util.Map;
import lombok.NonNull;

public class MessageDialogBuilder {
    protected DialogInfo dialogInfo;

    public MessageDialogBuilder(@NonNull String title, @NonNull DialogType type) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.dialogInfo = new DialogInfo();
        this.dialogInfo.title = title;
        this.dialogInfo.iconPath = type.getIconPath();
    }

    public MessageDialogBuilder setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.dialogInfo.title = title;
        return this;
    }

    public MessageDialogBuilder setType(@NonNull DialogType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.dialogInfo.iconPath = type.getIconPath();
        return this;
    }

    public MessageDialogBuilder setMessage(String message) {
        this.dialogInfo.message = message;
        return this;
    }

    public MessageDialogBuilder setLinks(Map<String, String> links) {
        this.dialogInfo.links = links;
        return this;
    }

    public MessageDialogBuilder setQuestionMessage(String questionMessage) {
        this.dialogInfo.questionMessage = questionMessage;
        return this;
    }

    public MessageDialogBuilder setOkButtonName(String okButtonName) {
        this.dialogInfo.okButtonName = okButtonName;
        return this;
    }

    public MessageDialogBuilder setCancelButtonName(String cancelButtonName) {
        this.dialogInfo.cancelButtonName = cancelButtonName;
        return this;
    }

    public MessageDialogBuilder setOkButtonVisible(boolean isOkButtonVisible) {
        this.dialogInfo.showOkButton = isOkButtonVisible;
        return this;
    }

    public MessageDialogBuilder setCancelButtonVisible(boolean isCancelButtonVisible) {
        this.dialogInfo.showCancelButton = isCancelButtonVisible;
        return this;
    }

    public MessageDialog build() {
        return new MessageDialog(this.dialogInfo);
    }

    public MessageDialog buildAndShow() {
        MessageDialog dialog = new MessageDialog(this.dialogInfo);
        dialog.setVisible(true);
        return dialog;
    }

    public MessageDialogBuilder reset() {
        DialogInfo newDialogInfo = new DialogInfo();
        newDialogInfo.title = this.dialogInfo.title;
        newDialogInfo.iconPath = this.dialogInfo.iconPath;
        this.dialogInfo = newDialogInfo;
        return this;
    }
}

