/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.actions.dialog.internal;

import com.oxygenxml.positron.actions.dialog.internal.DialogInfo;
import com.oxygenxml.positron.core.auth.BrowserOpener;
import com.oxygenxml.positron.plugin.ui.LinkLabel;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.LinkOpener;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OKCancelDialog;

public class MessageDialog
extends OKCancelDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MessageDialog.class.getName());
    public static final int FILES_SCROLLPANE_PREFERRED_WIDTH = 300;
    public static final int FILES_SCROLLPANE_PREFERRED_HEIGHT = 100;
    public static final int WARN_MESSAGE_DLG_MINIMUM_WIDTH = 300;
    public static final int WARN_MESSAGE_DLG_MINIMUM_HEIGHT = 150;
    private final DialogInfo info;
    final BrowserOpener browserOpener = new BrowserOpener();

    protected MessageDialog(@NonNull DialogInfo info) {
        super(PluginWorkspaceProvider.getPluginWorkspace() != null ? (JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame() : null, info.title, true);
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        this.info = info;
        this.createUI();
    }

    private void createUI() {
        JTextArea textArea;
        ImageIcon infoIcon;
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel iconLabel = new JLabel();
        if (this.info.iconPath != null && (infoIcon = IconsLoader.loadIcon(this.info.iconPath)) != null) {
            iconLabel.setIcon(infoIcon);
        }
        gbc.insets = new Insets(0, 5, 5, 10);
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        panel.add((Component)iconLabel, gbc);
        if (this.info.message != null) {
            textArea = UIUtil.createMessageArea("");
            textArea.setDocument(new CustomWrapDocument());
            textArea.setLineWrap(false);
            textArea.setText(this.info.message);
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridx = 1;
            gbc.gridheight = 1;
            panel.add((Component)textArea, gbc);
            ++gbc.gridy;
        }
        if (this.info.links != null && !this.info.links.isEmpty()) {
            JPanel linksPanel = new JPanel(new GridBagLayout());
            GridBagConstraints panelGBC = new GridBagConstraints();
            panelGBC.gridwidth = 1;
            panelGBC.gridheight = 1;
            panelGBC.weightx = 0.0;
            panelGBC.weighty = 0.0;
            panelGBC.gridy = 0;
            panelGBC.gridx = 0;
            panelGBC.fill = 0;
            panelGBC.anchor = 17;
            this.info.links.keySet().stream().sorted().forEach(link -> {
                LinkLabel linkLabel = new LinkLabel((String)link, (String)link){
                    final /* synthetic */ String val$link;
                    {
                        this.val$link = string;
                        super(text);
                    }

                    @Override
                    public void performAction() {
                        new LinkOpener(MessageDialog.this.browserOpener).openLink(MessageDialog.this.info.links.get(this.val$link));
                    }
                };
                panelGBC.insets.right = 5;
                linksPanel.add((Component)linkLabel, panelGBC);
                ++panelGBC.gridx;
            });
            panelGBC.fill = 1;
            panelGBC.weightx = 1.0;
            panelGBC.weighty = 1.0;
            linksPanel.add((Component)new JPanel(), panelGBC);
            panel.add((Component)linksPanel, gbc);
            ++gbc.gridy;
        }
        if (this.info.questionMessage != null) {
            textArea = UIUtil.createMessageArea("");
            textArea.setDocument(new CustomWrapDocument());
            textArea.setLineWrap(false);
            textArea.setText(this.info.questionMessage);
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridx = 1;
            gbc.gridheight = 1;
            panel.add((Component)textArea, gbc);
        }
        this.getCancelButton().setVisible(this.info.showCancelButton);
        this.getOkButton().setVisible(this.info.showOkButton);
        if (this.info.showOkButton && this.info.okButtonName != null && !this.info.okButtonName.isEmpty()) {
            this.setOkButtonText(this.info.okButtonName);
        }
        if (this.info.showCancelButton && this.info.cancelButtonName != null && !this.info.cancelButtonName.isEmpty()) {
            this.setCancelButtonText(this.info.cancelButtonName);
        }
        this.getContentPane().add(panel);
        this.setResizable(this.info.links != null && this.info.links.isEmpty());
        this.setMinimumSize(new Dimension(300, 150));
        this.pack();
        if (PluginWorkspaceProvider.getPluginWorkspace() != null) {
            this.setLocationRelativeTo((JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame());
        }
    }

    public String toString() {
        return this.info.toString();
    }

    public static class CustomWrapDocument
    extends DefaultStyledDocument {
        private static final int MAX_NO_OF_CHARS_PER_LINE = 100;

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] charArray;
            StringBuilder sb = new StringBuilder();
            int charsSinceLastNewline = 0;
            for (char ch : charArray = str.toCharArray()) {
                if (charsSinceLastNewline >= 100) {
                    if (Character.isWhitespace(ch)) {
                        sb.append('\n');
                        charsSinceLastNewline = 0;
                    } else {
                        sb.append(ch);
                    }
                } else {
                    if (ch == '\n') {
                        charsSinceLastNewline = 0;
                    }
                    sb.append(ch);
                }
                ++charsSinceLastNewline;
            }
            super.insertString(offs, sb.toString(), a);
        }
    }
}

