/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.actions;

import com.oxygenxml.positron.api.connector.AIConnectionException;
import com.oxygenxml.positron.api.connector.dto.SpeechToTextRequest;
import com.oxygenxml.positron.core.AICompletionDetailsProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.chat.UserInputTextHandler;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class RecordMicAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RecordMicAction.class.getName());
    private static final String DEFAULT_AUDIO_FORMAT = "audio/wav";
    private static final int MAX_RECORD_TIME = 60000;
    private boolean isRecordingChanges = false;
    private File recordFile;
    private long recordingStartTime;
    private TargetDataLine line = null;
    private UserInputTextHandler chatArea;
    private Supplier<AICompletionDetailsProvider> aiCompletionProvider;
    private boolean autoSubmit;

    public RecordMicAction(UserInputTextHandler chatArea, Supplier<AICompletionDetailsProvider> aiCompletionProvider, boolean autoSubmit) {
        super(Translator.getInstance().getTranslation("Start_recording_mic"), IconsLoader.loadIcon("/images/MicrophoneStartButton16.png"));
        this.putValue("ShortDescription", Translator.getInstance().getTranslation("Start_recording_mic"));
        this.autoSubmit = autoSubmit;
        this.chatArea = chatArea;
        this.aiCompletionProvider = aiCompletionProvider;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isRecordingChanges) {
            this.isRecordingChanges = true;
            this.putValue("ShortDescription", Translator.getInstance().getTranslation("Stop_recording_mic"));
            this.putValue("SmallIcon", IconsLoader.loadIcon("/images/MicrophoneStopButton16.png"));
            new Thread(() -> {
                try {
                    this.record();
                }
                catch (IOException | IllegalArgumentException | LineUnavailableException ex) {
                    PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage("Could not start recording. Cause: " + ex.getMessage(), (Throwable)ex);
                    LOGGER.error(ex.getMessage(), (Throwable)ex);
                }
                finally {
                    this.resetRecordingState();
                }
            }).start();
            long before = System.currentTimeMillis();
            new Thread(() -> {
                while (this.isRecordingChanges) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.error(ex.getMessage(), (Throwable)ex);
                    }
                    if (System.currentTimeMillis() - before <= 60000L) continue;
                    this.stopRecording(false);
                    break;
                }
            }).start();
        } else {
            this.stopRecording(this.autoSubmit);
        }
    }

    private void record() throws LineUnavailableException, IOException {
        this.recordFile = File.createTempFile("recording", ".wav");
        this.recordFile.deleteOnExit();
        this.recordingStartTime = System.currentTimeMillis();
        AudioFormat format = new AudioFormat(16000.0f, 16, 1, true, false);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
        this.line = (TargetDataLine)AudioSystem.getLine(info);
        this.line.open(format);
        this.line.start();
        this.recordFile.delete();
        AudioSystem.write(new AudioInputStream(this.line), AudioFileFormat.Type.WAVE, this.recordFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stopRecording(boolean submit) {
        this.line.stop();
        this.line.close();
        if (this.recordFile == null) return;
        AICompletionDetailsProvider provider = this.aiCompletionProvider.get();
        if (provider != null && provider.isEnabledSpeechToText()) {
            try (FileInputStream fis = new FileInputStream(this.recordFile);){
                SpeechToTextRequest request = new SpeechToTextRequest(IOUtil.readBytes((InputStream)fis), (int)((System.currentTimeMillis() - this.recordingStartTime) / 1000L), DEFAULT_AUDIO_FORMAT, this.getInputLanguage());
                String content = provider.convertSpeechToText(request);
                this.chatArea.insertTextAtCurrentPosition(content);
                if (!submit) return;
                this.chatArea.submitToAI();
                return;
            }
            catch (AIConnectionException | IOException e1) {
                PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage(e1.getMessage(), e1);
                LOGGER.error(e1.getMessage(), e1);
                return;
            }
            finally {
                this.recordFile.delete();
                this.recordFile = null;
                this.recordingStartTime = 0L;
            }
        } else {
            PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage(Translator.getInstance().getTranslation("Speech_text_not_available"));
        }
    }

    private String getInputLanguage() {
        String userInterfaceLanguage;
        String lang = "en-US";
        if (PluginWorkspaceProvider.getPluginWorkspace() != null && (userInterfaceLanguage = PluginWorkspaceProvider.getPluginWorkspace().getUserInterfaceLanguage()) != null) {
            lang = userInterfaceLanguage;
            if (userInterfaceLanguage.contains("_")) {
                lang = userInterfaceLanguage.replace('_', '-');
            }
        }
        return lang;
    }

    private void resetRecordingState() {
        this.putValue("ShortDescription", Translator.getInstance().getTranslation("Start_recording_mic"));
        this.putValue("SmallIcon", IconsLoader.loadIcon("/images/MicrophoneStartButton16.png"));
        this.isRecordingChanges = false;
    }
}

