/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.actions;

import com.oxygenxml.positron.actions.ParamExpanderUIInterface;
import com.oxygenxml.positron.actions.RecentlyUsedActionsOptionsStorageUtil;
import com.oxygenxml.positron.core.actions.ParamsExpander;
import com.oxygenxml.positron.core.actions.PositronActionConfigurationResult;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.utilities.json.ActionParam;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OKCancelDialog;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class ParamExpanderUi
implements ParamExpanderUIInterface {
    private static final int COMBO_BOX_PREFERRED_WIDTH = 200;

    @Override
    public PositronActionConfigurationResult configureAction(PositronAIActionBase action, List<ActionParam> actionParams, boolean wasConfigurationStartedByActionExecution) {
        String actionName = action.getActionDetails().getShortDescription();
        JFrame parentFrame = (JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame();
        OKCancelDialog dlg = new OKCancelDialog(parentFrame, actionName, true);
        if (parentFrame != null) {
            dlg.setIconImage(parentFrame.getIconImage());
        }
        dlg.setTitle(actionName);
        dlg.setResizable(false);
        dlg.setOkButtonText(Translator.getInstance().getTranslation("Save_and_execute"));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        dlg.getContentPane().add((Component)mainPanel, "Center");
        ((JPanel)dlg.getContentPane().getParent()).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.anchor = 17;
        constr.fill = 0;
        constr.insets = new Insets(0, 0, 5, 0);
        String actionID = action.getActionDetails().getId();
        HashMap<String, Set<String>> chosenValsTotal = new HashMap<String, Set<String>>();
        for (ActionParam actionParam : actionParams) {
            ParamExpanderUi.buildParamUI(actionID, mainPanel, constr, chosenValsTotal, actionParam);
        }
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        dlg.pack();
        dlg.setVisible(true);
        PositronActionConfigurationResult result = PositronActionConfigurationResult.CANCELLED;
        if (dlg.getResult() == 1) {
            result = PositronActionConfigurationResult.DONE;
            ParamsExpander.storeActionParams((String)actionID, chosenValsTotal);
            if (!wasConfigurationStartedByActionExecution) {
                action.actionPerformed(new ActionEvent(new Object(), 1001, ""));
            } else {
                RecentlyUsedActionsOptionsStorageUtil.addToRecentlyUsedInfoAboutActionThatStartsWithConfiguration(actionID, chosenValsTotal);
            }
        }
        return result;
    }

    private static void buildParamUI(String actionID, JPanel mainPanel, GridBagConstraints constr, Map<String, Set<String>> chosenValsTotal, ActionParam actionParam) {
        ButtonGroup bg;
        String[] vals = actionParam.getAlternateValues();
        if (vals == null) {
            vals = new String[]{};
        }
        String[] labels = actionParam.getAlternateValueLabels();
        LinkedHashSet<String> chosenVals = new LinkedHashSet<String>();
        chosenValsTotal.put(actionParam.getName(), chosenVals);
        LinkedHashSet<String> initialValuesSet = new LinkedHashSet<String>();
        String initialVals = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption("oxygen.positron.plugin." + actionID + "###---####" + actionParam.getName(), "");
        if (!initialVals.isEmpty()) {
            initialValuesSet.addAll(Arrays.asList(initialVals.split("###---####")));
            chosenVals.addAll(initialValuesSet);
        }
        constr.insets.right = 5;
        String labelVal = actionParam.getLabel() != null ? actionParam.getLabel() : actionParam.getName();
        mainPanel.add((Component)new JLabel(labelVal + ":"), constr);
        constr.insets.right = 0;
        String choiceType = actionParam.getChoiceType();
        ButtonGroup buttonGroup = bg = "single-choice".equals(choiceType) ? new ButtonGroup() : null;
        if ("editable-combo-choice".equals(choiceType)) {
            JComboBox<String> comboBox = ParamExpanderUi.createEditableComboBox(vals, chosenVals);
            ++constr.gridx;
            mainPanel.add(comboBox, constr);
        } else {
            for (int i = 0; i < vals.length; ++i) {
                int index = i;
                AbstractButton button = ParamExpanderUi.createButton(actionParam, vals[index], labels != null && labels.length > index ? labels[index] : vals[index], chosenVals, initialValuesSet, bg);
                ++constr.gridx;
                mainPanel.add((Component)button, constr);
            }
        }
        ++constr.gridy;
        constr.gridx = 0;
    }

    private static JComboBox<String> createEditableComboBox(String[] vals, final Set<String> chosenVals) {
        JComboBox comboBox = OxygenUIComponentsFactory.createComboBox(new JComboBox().getModel());
        comboBox.setPreferredSize(new Dimension(200, comboBox.getPreferredSize().height));
        comboBox.setEditable(true);
        for (int i = 0; i < vals.length; ++i) {
            comboBox.addItem(vals[i]);
        }
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    chosenVals.clear();
                    chosenVals.add((String)e.getItem());
                }
            }
        });
        Iterator<String> chosenActionsIterator = chosenVals.iterator();
        if (chosenActionsIterator.hasNext()) {
            comboBox.setSelectedItem(chosenActionsIterator.next());
        } else if (comboBox.getItemCount() > 0) {
            comboBox.setSelectedIndex(0);
            chosenVals.clear();
            chosenVals.add((String)comboBox.getItemAt(0));
        }
        return comboBox;
    }

    private static AbstractButton createButton(ActionParam actionParam, final String value, String label, final Set<String> chosenVals, Set<String> initialValuesSet, ButtonGroup bg) {
        JToggleButton button = null;
        button = "single-choice".equals(actionParam.getChoiceType()) ? new JRadioButton(new AbstractAction(label){

            @Override
            public void actionPerformed(ActionEvent e) {
                chosenVals.clear();
                chosenVals.add(value);
            }
        }) : new JCheckBox(new AbstractAction(label){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    chosenVals.add(value);
                } else {
                    chosenVals.remove(value);
                }
            }
        });
        if (initialValuesSet.contains(value) || "single-choice".equals(actionParam.getChoiceType()) && initialValuesSet.isEmpty() && value != null && value.equals(actionParam.getValue())) {
            button.setSelected(true);
        }
        if (bg != null) {
            bg.add(button);
        }
        return button;
    }
}

