/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.actions;

import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.CompletionActionsProvider;
import com.oxygenxml.positron.plugin.chat.quickfind.QuickSearchItemDialog;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.AbstractAction;

public class AIActionsUtil {
    public static final String OTHER_CATEGORY = "Other";
    public static final String DEVELOPMENT_CATEGORY = "Development";

    private AIActionsUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static Map<String, List<PositronAIActionBase>> groupActionByCategory(List<PositronAIActionBase> completionActions) {
        LinkedHashMap<String, List> customAndDevActions = new LinkedHashMap<String, List>();
        LinkedHashMap<String, List> builtinActions = new LinkedHashMap<String, List>();
        customAndDevActions.put(DEVELOPMENT_CATEGORY, new ArrayList());
        if (completionActions != null) {
            int nuOfActions = completionActions.size();
            for (int i = 0; i < nuOfActions; ++i) {
                PositronAIActionBase action = completionActions.get(i);
                if (!action.getActionDetails().isVisibleInUI()) continue;
                String categoryName2 = action.getActionDetails().getCategoryId();
                if (categoryName2 == null) {
                    categoryName2 = OTHER_CATEGORY;
                }
                boolean isCustomAction = !action.getActionDetails().isBuiltinAction();
                boolean isDevelopmentCategory = DEVELOPMENT_CATEGORY.equals(categoryName2);
                if (isCustomAction || isDevelopmentCategory) {
                    customAndDevActions.computeIfAbsent(categoryName2, key -> new ArrayList()).add(action);
                    continue;
                }
                builtinActions.computeIfAbsent(categoryName2, key -> new ArrayList()).add(action);
            }
        }
        if (builtinActions.containsKey(OTHER_CATEGORY)) {
            List otherActions = (List)builtinActions.get(OTHER_CATEGORY);
            builtinActions.remove(OTHER_CATEGORY);
            builtinActions.put(OTHER_CATEGORY, otherActions);
        }
        if (((List)customAndDevActions.get(DEVELOPMENT_CATEGORY)).isEmpty()) {
            customAndDevActions.remove(DEVELOPMENT_CATEGORY);
        }
        LinkedHashMap<String, List<PositronAIActionBase>> finalActions = new LinkedHashMap<String, List<PositronAIActionBase>>();
        finalActions.putAll(customAndDevActions);
        builtinActions.forEach((categoryName, actionsArray) -> finalActions.computeIfAbsent((String)categoryName, key -> new ArrayList()).addAll(actionsArray));
        return finalActions;
    }

    public static AbstractAction createQuickFindAction(final Supplier<Component> componentRelativeToSupplier, final CompletionActionsProvider completionActionsProvider, final boolean shouldPlaceDialogAboveComponent) {
        return new AbstractAction(Translator.getInstance().getTranslation("Quick_Search_Action"), IconsLoader.loadIcon("/images/SearchTextField16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (completionActionsProvider != null) {
                    QuickSearchItemDialog quickSearchDialog = new QuickSearchItemDialog(componentRelativeToSupplier, completionActionsProvider, shouldPlaceDialogAboveComponent);
                    quickSearchDialog.setVisible(true);
                }
            }
        };
    }
}

