/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.api.connector.dto;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.oxygenxml.positron.api.connector.dto.ImageUrl;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageImageUrlContent;
import com.oxygenxml.positron.api.connector.dto.MessageImageUrlWithResolutionContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MessageContentDeserializer
extends StdDeserializer {
    public MessageContentDeserializer() {
        super(Object.class);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        try {
            String value = (String)p.readValueAs(String.class);
            if (value != null) {
                ArrayList<MessageTextContent> list = new ArrayList<MessageTextContent>(1);
                list.add(new MessageTextContent(value));
                return list;
            }
        }
        catch (Exception ex) {
            return MessageContentDeserializer.readAsList(p);
        }
        return null;
    }

    private static Object readAsList(JsonParser p) throws IOException {
        Object vals = p.readValueAs(List.class);
        ArrayList<MessageContent> list = new ArrayList<MessageContent>(1);
        if (vals != null) {
            List valuesList = (List)vals;
            for (Object val : valuesList) {
                if (val instanceof MessageContent) {
                    list.add((MessageContent)val);
                    continue;
                }
                if (!(val instanceof Map)) continue;
                Map valmap = (Map)val;
                String type = (String)valmap.get("type");
                Pair<Integer, Integer> resolution = null;
                if (valmap.containsKey("image_resolution")) {
                    Map pairMap = (Map)valmap.get("image_resolution");
                    resolution = new Pair<Integer, Integer>((Integer)pairMap.get("first"), (Integer)pairMap.get("second"));
                }
                if ("text".equals(type)) {
                    list.add(new MessageTextContent((String)valmap.get("text")));
                    continue;
                }
                if (!"image_url".equals(type)) continue;
                Object url = valmap.get("image_url");
                if (resolution != null) {
                    list.add(new MessageImageUrlWithResolutionContent(new ImageUrl((String)((Map)url).get("url")), resolution));
                    continue;
                }
                list.add(new MessageImageUrlContent(new ImageUrl((String)((Map)url).get("url"))));
            }
        }
        return list;
    }
}

